class Config:

    #################### For BERT fine-tuning ####################
    # control
    datatype = "e2e"
    retrain = False                       # Reuse trained model weights
    test_mode = "validation" # "validation", "data"
    data_mode = "multi" #"single"      # single or multi intent in data
    domain = "movie_all" # "movie_all", "restaurant_all", "taxi_all", "", "_flights"
    model = "kg_att2_context_local" # kg_att2_context_as_hidden_gating, kg_att2_context_as_hidden_lka, kg_att2_context_global, kg_att2_context_local, glka_trans, new_fuse
    run_baseline = 'no'
    #################################
    
    if datatype == "e2e":
        # Microsoft e2e dialogue dataset
        # train_path = "data/e2e_dialogue/dialogue_data_multi_with_slots.pkl"
        # dic_path = "data/e2e_dialogue/intent2id.pkl" if data_mode == "single" else "data/e2e_dialogue/intent2id_multi.pkl"
        # dic_path_with_tokens = "data/e2e_dialogue/intent2id_multi_with_tokens.pkl"
        # slot_path = "data/e2e_dialogue/slot2id_with_tokens.pkl"

        train_path = "data/e2e_dialogue/dialogue_data_{}_kg_test.pkl".format(domain)
        dic_path = "data/e2e_dialogue/intent2id.pkl" if data_mode == "single" else "data/e2e_dialogue/intent2id_multi.pkl"
        dic_path_with_tokens = "data/e2e_dialogue/intent2id_multi_with_tokens_kg_test.pkl"
        slot_path = "data/e2e_dialogue/slot2id_with_tokens_kg_test.pkl"
        nslots = ['numberofpeople', 'date', 'starttime', 'zip', 'pickup_time', 'cost', 'critic_rating', 'price', 'mpaa_rating', 'numberofkids', 'pricing', 'rating', 'address', 'dress_code', 'implicit_value']
    
    elif datatype == "sgd":
        # dstc8-sgd dialogue dataset
        train_path = "data/sgd_dialogue/dialogue_data_multi_with_slots_kg{}_test.pkl".format(domain)
        dic_path = "data/sgd_dialogue/intent2id.pkl" if data_mode == "single" else "data/sgd_dialogue/intent2id_multi.pkl"
        dic_path_with_tokens = "data/sgd_dialogue/intent2id_multi_with_tokens_kg{}_test.pkl".format(domain)
        slot_path = "data/sgd_dialogue/slot2id_with_tokens_kg{}_test.pkl".format(domain)
        if domain == "":
            nslots = ['street_address', 'phone_number', 'time', 'date', 'event_time', 'event_date', 'appointment_time', 'appointment_date', 'average_rating', 'show_time', 'price', 'wait_time', 'ride_fare']
        else:
            nslots = ['departure_date', 'outbound_departure_time', 'price', 'outbound_arrival_time', 'fare', 'return_date', 'date', 'temperature', 'precipitation', 
            'humidity', 'address', 'rating', 'phone_number']

    model_path = None if not retrain else 'checkpoints/best_{}_{}_{}.pth'.format(datatype, model, domain)

    maxlen = 60
    batch_size = 2 #KABEM: e2e 4 sgd 4  GLKA: e2e 2 sgd 1 # multi 128 eca 8 
    epochs = 30
    learning_rate_bert = 5e-5 #1e-3
    learning_rate_classifier = 5e-3
    interval = 1

    rnn_hidden = 256
    memory_size = 100
    hop = 3


opt = Config()