#!/usr/bin/env bash

# bash xgiga_zmbart_zero.sh mspm4_xgiga en debug


DATAVER="$1"
LG="$2"
NAME="$3"
NAME=ZmBART_zero_${NAME}_${LG}

argslist=""
for (( i = 4; i <= $# ; i++ ))
  do
    j=${!i}
    argslist="${argslist} $j "
  done
echo $argslist >&2

cd "$(dirname $0)" || return
echo "Install fairseq" >&2

sudo mkdir -p /usr/lib/python3.7/site-packages/
sudo pip3 install -e fairseq
sudo pip3 install -r requirements.txt -i http://pypi.byted.org/simple/ --trusted-host=pypi.byted.org
pip3 install torch==1.8.0 -i http://pypi.byted.org/simple/ --trusted-host=pypi.byted.org

export PYROUGE_HOME_DIR=$(pwd)/RELEASE-1.5.5
export PYROUGE_TEMP_PATH=/opt/tiger

pyrouge_set_rouge_path $PYROUGE_HOME_DIR
chmod +x $PYROUGE_HOME_DIR/ROUGE-1.5.5.pl

# prefix=hdfs://haruna/home/byte_arnold_lq_mlnlc/user/wangdanqing.122
wxz_prefix=hdfs://haruna/home/byte_arnold_hl_mlnlc/user/wuxianze.0

dataset_path=${wxz_prefix}/Datasets/multilingual/data-bin/${DATAVER}/${LG}
tensorboard_logdir=${wxz_prefix}/Workspace/Multilingual/xgiga/${LG}/logs/${NAME}
pretrained_path=${wxz_prefix}/Workspace/Multilingual/pretrained

# change checkpoint path
hdfs dfs -mkdir -p $tensorboard_logdir

local_root=~/xgiga_${NAME}
resource_root=${local_root}/resource
output_path=${local_root}/output
model_path=${local_root}/model
mkdir -p ${resource_root}
mkdir -p ${output_path}
mkdir -p ${model_path}

local_dataset_path=${resource_root}/dataset
mkdir -p ${local_dataset_path}
hadoop fs -copyToLocal ${dataset_path}/* ${local_dataset_path}
echo "Download resource from ${dataset_path} to ${local_dataset_path}" >&2

local_tensorboard_path=${output_path}/tensorboard_logdir
mkdir -p ${local_tensorboard_path}

local_pretrained_path=${model_path}/mbart.cc25
if [ ! -d ${local_pretrained_path} ]; then
#   echo "Load pretrained model from ${pretrained_path}/mbart.CC25.tar.gz to ${local_pretrained_path}" >&2
#   hadoop fs -copyToLocal ${pretrained_path}/mbart.CC25.tar.gz ${model_path}
#   tar -xvzf ${model_path}/mbart.CC25.tar.gz -C ${model_path}
  echo "Load pretrained model from ${pretrained_path}/checkpoint_ZmBART.pt to ${pretrained_path}/checkpoint_ZmBART.pt" >&2
  hdfs dfs -get ${pretrained_path}/checkpoint_ZmBART.pt ${model_path}/
else
  echo "Pretrained model in ${local_pretrained_path}" >&2
fi

echo "Finish download files" >&2

langs=ar_AR,cs_CZ,de_DE,en_XX,es_XX,et_EE,fi_FI,fr_XX,gu_IN,hi_IN,it_IT,ja_XX,kk_KZ,ko_KR,lt_LT,lv_LV,my_MM,ne_NP,nl_XX,ro_RO,ru_RU,si_LK,tr_TR,vi_VN,zh_CN

echo "Generating..."

suffix=$(echo "$argslist" | sed -e "s/-//g"  -e "s/  */_/g")

# --model-overrides "{'layernorm_embedding': True}" \

python3 fairseq/generate.py ${local_dataset_path}  \
    --path ${model_path}/checkpoint_ZmBART.pt \
    --task summarization_from_pretrained_mbart_mspm4 \
    --gen-subset test \
    --source-lang doc --target-lang sum \
    --langs $langs \
    --remove-bpe 'sentencepiece'  \
    --min-len 2 \
    --max-len-a 0.78 \
    --max-len-b 2 \
    --lenpen 0.6 \
    --no-repeat-ngram-size 3 \
    --truncate-source \
    --user-dir examples/summarization \
    --batch-size 1 \
    --model-overrides "{'layernorm_embedding': True}" \
    $argslist \
    > ${local_tensorboard_path}/"output$suffix"

cat ${local_tensorboard_path}/"output$suffix" | grep -P "^H" | sort -V |cut -f 3- | sed -e  "s/\[[a-z]\{2\}_[A-Z]\{2\}\]//g" > ${local_tensorboard_path}/"test$suffix.hypo"

echo "Load ground truth file from ${wxz_prefix}/Datasets/multilingual/xgiga/raw/test.y.${LG}"
hadoop fs -get ${wxz_prefix}/Datasets/multilingual/xgiga/raw/test.y.${LG} ${local_dataset_path}/

hypo=${local_tensorboard_path}/"test$suffix.hypo"
ref=${local_dataset_path}/test.y.${LG}

if [ ${LG} == "zh" ]; then
  # split the reference and hypothesis into chars
  cat ${hypo} | python3 -u ./xnlg/zh_split_words.py > ${local_tensorboard_path}/"test$suffix.hypo.char"
  cat ${ref} | python3 -u ./xnlg/zh_split_words.py > ${local_dataset_path}/test.y.${LG}.char
  hypo=${local_tensorboard_path}/"test$suffix.hypo.char"
  ref=${local_dataset_path}/test.y.${LG}.char
  python3 ./xnlg/calc_rouge.py --ref ${ref} --hyp ${hypo} --zh True
else
  python3 ./xnlg/calc_rouge.py --ref ${ref} --hyp ${hypo}
fi


echo "Put ${local_tensorboard_path} to ${tensorboard_logdir}" >&2
hadoop fs -put -f ${local_tensorboard_path}/* ${tensorboard_logdir}/
sleep 600
