LANG="de en fr zh"
INPUT="input1 input2 input3 input4 input0"

get_seeded_random()
{
  seed="$1"
  openssl enc -aes-256-ctr -pass pass:"$seed" -nosalt \
    </dev/zero 2>/dev/null
}

for TYPE in $INPUT
do
    echo "cat training data for $TYPE"
    cat de/ranking/train.$TYPE.spm en/ranking/train.$TYPE.spm fr/ranking/train.$TYPE.spm zh/ranking/train.$TYPE.spm > lang4/train.noshuffle.$TYPE.spm
    echo "shuffling"
    shuf --random-source=<(get_seeded_random 66) lang4/train.noshuffle.$TYPE.spm > lang4/train.$TYPE.spm
    echo "cat dev data for $TYPE"
    cat de/ranking/dev.$TYPE.spm en/ranking/dev.$TYPE.spm fr/ranking/dev.$TYPE.spm zh/ranking/dev.$TYPE.spm > lang4/dev.$TYPE.spm
done

echo "cat training data for label"
cat de/ranking/train.label en/ranking/train.label fr/ranking/train.label zh/ranking/train.label > lang4/train.noshuffle.label
echo "shuffling"
shuf --random-source=<(get_seeded_random 66) lang4/train.noshuffle.label > lang4/train.label
echo "cat dev data for label"
cat de/ranking/dev.label en/ranking/dev.label fr/ranking/dev.label zh/ranking/dev.label > lang4/dev.label



