bert_dir = 'data/BertModel/bert-large-cased'

from transformers import AutoTokenizer 
tokenizer = AutoTokenizer.from_pretrained(bert_dir, do_lower_case=False)

event_type = ['O', 'Arriving', 'Communication', 'Getting', 'Name_conferral', 'Award', 'Recovering', 'Cause_to_amalgamate', 'Hiding_objects', 'Damaging', 'Arrest', 'Attack', 'Practice', 'Military_operation', 'Theft', 'Manufacturing', 'Legality', 'Change_tool', 'Institutionalization', 'Renting', 'Carry_goods', 'Cost', 'Bodily_harm', 'Research', 'Adducing', 'Know', 'Emptying', 'Legal_rulings', 'Presence', 'Cause_to_make_progress', 'Rewards_and_punishments', 'Giving', 'Terrorism', 'Process_end', 'Emergency', 'Rescuing', 'Deciding', 'Scouring', 'Breathing', 'Warning', 'Building', 'Expansion', 'Creating', 'Placing', 'Cause_change_of_strength', 'Submitting_documents', 'Preserving', 'Becoming', 'Defending', 'Sign_agreement', 'Confronting_problem', 'Expend_resource', 'Using', 'Testing', 'Choosing', 'Achieve', 'Hindering', 'Coming_to_believe', 'Temporary_stay', 'Employment', 'Participation', 'Aiming', 'Patrolling', 'Cause_change_of_position_on_a_scale', 'Assistance', 'Departing', 'Commerce_pay', 'Preventing_or_letting', 'Openness', 'Releasing', 'Social_event', 'Robbery', 'Revenge', 'Create_artwork', 'Education_teaching', 'Judgment_communication', 'Becoming_a_member', 'Traveling', 'Filling', 'Expressing_publicly', 'Containing', 'Self_motion', 'Motion_directional', 'Committing_crime', 'GiveUp', 'Kidnapping', 'Reporting', 'Perception_active', 'Collaboration', 'Extradition', 'Forming_relationships', 'Cause_to_be_included', 'Check', 'Causation', 'Lighting', 'Surrounding', 'Surrendering', 'Cure', 'Besieging', 'Hostile_encounter', 'Arranging', 'Wearing', 'Quarreling', 'Change_event_time', 'Escaping', 'Reforming_a_system', 'Bearing_arms', 'Body_movement', 'Request', 'Bringing', 'Conquering', 'Commitment', 'Exchange', 'Incident', 'Vocalizations', 'Suspicion', 'Violence', 'Risk', 'Scrutiny', 'Earnings_and_losses', 'Motion', 'Action', 'Telling', 'Criminal_investigation', 'Commerce_buy', 'Influence', 'Writing', 'Death', 'Ingestion', 'Come_together', 'Connect', 'Sending', 'Rite', 'Statement', 'Change_of_leadership', 'Justifying', 'Publishing', 'Supporting', 'Response', 'Prison', 'Change', 'GetReady', 'Convincing', 'Use_firearm', 'Commerce_sell', 'Protest', 'Resolve_problem', 'Agree_or_refuse_to_act', 'Being_in_operation', 'Catastrophe', 'Process_start', 'Control', 'Killing', 'Reveal_secret', 'Supply', 'Labeling', 'Coming_to_be', 'Imposing_obligation', 'Recording', 'Competition', 'Removing', 'Having_or_lacking_access', 'Change_sentiment', 'Dispersal', 'Destroying', 'Hold', 'Ratification', 'Limiting', 'Receiving']

tag2idx = {tag: idx for idx, tag in enumerate(event_type)}
idx2tag = {idx: tag for idx, tag in enumerate(event_type)}


salient_type = ['Openness', 'Expansion', 'Supply', 'Removing', 'Change_of_leadership', 'Carry_goods', 'Surrounding', 'Hostile_encounter', 'Causation', 'Placing', 'Violence', 'Achieve', 'Participation', 'Warning', 'Hindering', 'Catastrophe', 'Attack', 'Preventing_or_letting', 'Presence', 'Exchange', 'Quarreling', 'Process_start', 'Giving', 'Releasing', 'Traveling', 'Wearing', 'Process_end', 'Judgment_communication', 'Cause_change_of_position_on_a_scale', 'Agree_or_refuse_to_act', 'Change', 'Publishing', 'Departing', 'Cause_to_be_included', 'Cause_to_amalgamate', 'Recovering', 'Getting', 'GiveUp', 'Reporting', 'Sign_agreement', 'Building', 'Using', 'Change_event_time', 'Name_conferral', 'Containing', 'Aiming', 'Becoming_a_member', 'Supporting', 'Recording', 'Request', 'Deciding', 'Arriving', 'Commerce_pay', 'Killing', 'Assistance', 'Motion_directional', 'Earnings_and_losses', 'Damaging', 'Coming_to_be', 'Commerce_buy', 'Influence', 'Preserving', 'Control', 'Sending', 'Dispersal', 'Arrest', 'Surrendering', 'Conquering', 'Expressing_publicly', 'Besieging', 'Defending', 'Competition', 'Cause_change_of_strength', 'Arranging', 'Death', 'Escaping', 'Destroying', 'Choosing', 'Bodily_harm', 'Becoming', 'Receiving', 'Use_firearm', 'Rescuing', 'Commerce_sell']
salient_type_set = list(set([tag2idx[x] for x in salient_type]))

unsalient_type = list(filter(lambda x: not tag2idx[x] in salient_type_set and x != 'O', event_type))
unsalient_type_set = list(set([tag2idx[x] for x in unsalient_type]))

print(salient_type)
print(unsalient_type)
