GPUS=$1
# The name of experiment
NAME=$2

# Create dirs and make backup
output=snap/vlpretrain/$NAME
mkdir -p $output/src/
cp -r vlpretrain $output/src/
cp $0 $output/run.bash


CUDA_VISIBLE_DEVICES=$GPUS python vlpretrain/main.py \
    --train-imgs mscoco_train,mscoco_nominival --valid-imgs mscoco_minival \
    --train-langs mscoco --valid-langs mscoco \
    --max-len 128 --dim 768 --losshp 1 \
    --lang-finetune \
    --lang-pretrained --visn-pretrained \
    --num-workers 8 --batchSize 16 --optim bert  --epochs 3 \
    --nodes 1 --nr 0 \
    --clloss --entire \
    --output $output ${@:3} | tee $output/log.log \
    

