# -*- coding: utf-8 -*-
from moverscore_v2 import get_idf_dict, word_mover_score
from collections import defaultdict
import csv
import pdb
import sys, os

sysfile = sys.argv[1] 
reffile =  "reference"
savefile = 'mscsv/3tasks_token_ms.csv'

with open(sysfile, 'r') as file1, open(reffile, 'r') as file2:
    syslines = file1.readlines()
    reflines = file2.readlines()
    syslines = [line.strip() for line in syslines]
    reflines = [line.strip() for line in reflines]

idf_dict_sys = get_idf_dict(syslines)
idf_dict_ref = get_idf_dict(reflines)

scores = word_mover_score(reflines, syslines, idf_dict_ref, idf_dict_sys, stop_words=[], n_gram=1, remove_subwords=True)

print(sum(scores)/len(scores))

newscores = [[score] for score in scores]
with open(savefile, "w") as csvfile:
    writer = csv.writer(csvfile)
    writer.writerow(["ms"])
    writer.writerows(newscores)
