#!/usr/bin/env python3
#Example script that feeds one line of input and expects one line of output.
#CC 0 public domain dedication.
#
#Remember to flush your stdout!
#Docker seems to buffer stdin/stdout, so it's better to run this script in the docker.
import subprocess
import sys

if len(sys.argv) < 2:
  print("Feeds a subprocess one sentence then reads one sentence at a time.  Example usage: " + sys.argv[0] + " cat")
  sys.exit(1)
process = subprocess.Popen(sys.argv[1:], stdin = subprocess.PIPE, stdout = subprocess.PIPE, stderr = sys.stderr)
for l in sys.stdin:
  process.stdin.write(l.encode('utf-8'))
  process.stdin.flush()
  translated = process.stdout.readline()
  sys.stdout.write(translated.decode('utf-8'))
