#!/bin/bash
set -eo pipefail
if [ ! -f $1/hyp ]; then
  echo usage: $0 \$dir where \$dir contains a hyp file 1>&2
  exit 1
fi
if [ $(wc -l <$1/hyp) != 1000000 ]; then
  echo $1/hyp does not contain 1000000 lines 1>&2
  exit 2
fi
python3.8 /fs/bil0/heafield/wmt21/testdata/restore.py /fs/bil0/heafield/wmt21/testdata/origins <$1/hyp $1/restored
/fs/meili0/heafield/matching/rejoin.py /fs/meili0/heafield/matching/en-de/wmt20/split_log <$1/restored/wmt20-split |sacrebleu --test-set wmt20/tworefs -l en-de --width 3 -b >$1/restored/wmt20-split.bleu2ref
/fs/meili0/heafield/matching/rejoin.py /fs/meili0/heafield/matching/en-de/wmt20/split_log <$1/restored/wmt20-split |sacrebleu --test-set wmt20 -l en-de --width 3 -b >$1/restored/wmt20-split.bleu
/fs/meili0/heafield/matching/rejoin.py /fs/meili0/heafield/matching/en-de/wmt20/split_log <$1/restored/wmt20-split |sacrebleu --test-set wmt20 -l en-de -b --width 3 --metrics chrf >$1/restored/wmt20-split.chrf
parallel sacrebleu --test-set wmt{} -l en-de -b --width 3 \<$1/restored/wmt{} \>$1/restored/wmt{}.bleu ::: 08 09 10 11 12 13 14 15 16 17 18 19
parallel sacrebleu --test-set wmt{} -l en-de -b --width 3 --metrics chrf \<$1/restored/wmt{} \>$1/restored/wmt{}.chrf ::: 08 09 10 11 12 13 14 15 16 17 18 19
/fs/meili0/heafield/matching/en-de/extractwmt21.py <$1/restored/wmt21 >$1/restored/wmt21-justtest
sacrebleu --width 3 -b /fs/bil0/heafield/wmt21/references/newstest2021.en-de.ref.ref-A.de <$1/restored/wmt21-justtest >$1/restored/wmt21-justtest.ref-A.bleu
sacrebleu --width 3 -b /fs/bil0/heafield/wmt21/references/newstest2021.en-de.ref.ref-A.de --metrics chrf <$1/restored/wmt21-justtest >$1/restored/wmt21-justtest.ref-A.chrf
/fs/meili0/heafield/matching/rejoin.py /fs/meili0/heafield/matching/en-de/wmt21-justtest/split_log <$1/restored/wmt21-justtest-split |sacrebleu --width 3 -b /fs/bil0/heafield/wmt21/references/newstest2021.en-de.ref.ref-A.de >$1/restored/wmt21-justtest-split.ref-A.bleu
/fs/meili0/heafield/matching/rejoin.py /fs/meili0/heafield/matching/en-de/wmt21-justtest/split_log <$1/restored/wmt21-justtest-split |sacrebleu --width 3 -b /fs/bil0/heafield/wmt21/references/newstest2021.en-de.ref.ref-A.de --metrics chrf >$1/restored/wmt21-justtest-split.ref-A.chrf
