import math
import numpy as np # imports a fast numerical programming library
import scipy as sp #imports stats functions, amongst other things
import matplotlib as mpl # this actually imports matplotlib
import matplotlib.cm as cm #allows us easy access to colormaps
import matplotlib.pyplot as plt #sets up plotting under plt
# plt.style.use('ggplot')
from itertools import islice
import pandas as pd #lets us handle data as dataframes
from numpy import argmax
from sklearn.metrics import precision_recall_curve
from sklearn.metrics import f1_score
from sklearn.metrics import auc
from matplotlib import pyplot
from sklearn.metrics import roc_curve
from sklearn.metrics import roc_auc_score
from scipy.interpolate import interp1d
from numpy import sqrt
from matplotlib import pyplot
from matplotlib import gridspec
# sns.set_style("whitegrid")
from sklearn import preprocessing
from sklearn.model_selection import train_test_split
from sklearn.calibration import CalibratedClassifierCV
# Classifier
from sklearn.svm import LinearSVC
from sklearn.svm import SVC

# Result Analysis
from sklearn.externals import joblib
from sklearn.metrics import recall_score, precision_score, confusion_matrix
from sklearn.metrics import accuracy_score, f1_score
from sklearn.model_selection import cross_val_score
from sklearn.model_selection import cross_val_predict
from sklearn import metrics


from tqdm import tqdm
from tqdm._tqdm_notebook import tqdm_notebook
tqdm_notebook.pandas()

# Some useful library
import os
from os.path import isfile

import json
import collections
import re, time , ntpath
import logging
import random
import glob
from pprint import pprint
from copy import deepcopy
from os import listdir
from collections import Counter
from pprint import pprint

from IPython.utils import io
from IPython.display import HTML, display
from ipywidgets import interact, Layout, HBox, VBox, Box
import ipywidgets as widgets
from IPython.display import clear_output

# from scipy.spatial.distance import jensenshannon
# from spacy.lang.en.stop_words import STOP_WORDS
# import en_core_sci_lg
import string



import pandas as pd
import re
import os
# For Ploting
import seaborn as sns

# Word Embedding
from sklearn.feature_extraction.text import CountVectorizer, TfidfVectorizer
from sklearn.model_selection import KFold

# File save
import pickle
import numpy as np
import pandas as pd
from sklearn.model_selection import train_test_split
from sklearn.preprocessing import StandardScaler
from sklearn.metrics import confusion_matrix
from sklearn.metrics import accuracy_score
from sklearn.svm import LinearSVC
import seaborn as sns
import sys
import warnings
from matplotlib import pyplot as plt 
from sklearn.metrics import accuracy_score, f1_score, precision_score, recall_score, classification_report, confusion_matrix
from sklearn.metrics import roc_curve
from sklearn.metrics import roc_auc_score

if not sys.warnoptions:
    warnings.simplefilter("ignore")
from sklearn.model_selection import GridSearchCV 
import os
from pathlib import Path
path = Path(os.getcwd())
# print(path)


def plot_threshold(exh_df_, marker_size = 10, genre_list = [1, 2], 
                                use_markers: bool = True, for_paper: bool = False):
        sns.set_style("whitegrid")
        plt.rcParams["figure.dpi"] = 500

        width = 26 
        height = 13

        fig, axes = plt.subplots(nrows=1, ncols=1, figsize=(30, 17))
        exh_df = exh_df_.copy().sort_values(by=["Number of Features"]).reset_index(drop=True)
        
        display(exh_df)
        print(exh_df.Genre.unique())

        if exh_df["Number of Features"].max() > 10:
            max_steps = exh_df["Number of Features"].max()
        else:
            max_steps = 10

        markers = ["o", "P", "s", "D", "p", "v", "H", "*", 'X']
        
        labels = exh_df_.Genre.unique()
        print(labels)
        labels.sort()
        
        color  = ['#e6194b', '#3cb44b', '#ffe119', '#4363d8', '#f58231', '#911eb4', '#46f0f0', '#f032e6', '#bcf60c']

        dict_col = {}
        ind = 0
        for genre in labels:
            dict_col[genre] = color[ind]
            ind+=1
            
        mx_fet = exh_df["Number of Features"].max()

        line_width = marker_edge_width = 2
        for (genre, data), m in zip(exh_df.groupby(by="Genre", as_index = False), markers):
            print(genre)
            
            data_sort = data.sort_values(by = 'Number of Features', ascending= True, ignore_index = True)
            display(data_sort)
            print(type(data_sort))
            
            
            
            
    
            
            ff = data_sort[data_sort['Number of Features']%15 == 0]
            
            ff_x = ff['Number of Features'].values.tolist()
            ff_y = ff['F1'].values.tolist()
            
            plt.scatter(ff_x, ff_y, s = 60, color= dict_col[genre])
            pre_x = data_sort['Number of Features'].values.tolist()
            pre_y = data_sort['F1'].values.tolist()
           
            coefficients = np.polyfit(pre_x, pre_y, 15)
            poly = np.poly1d(coefficients)
            
            new_x = np.linspace(50, mx_fet, 30) ## needs changing
            new_y = poly(new_x)
            
            f = interp1d(new_x, new_y, kind='quadratic')
            y_smooth=f(new_x)

            
#             print(type(pre_x), len(pre_x))
            

            axes.plot(new_x, y_smooth, color= dict_col[genre],
                                                          marker=m,
                                                          markersize=16,
                                                          markeredgewidth=marker_edge_width if genre != "All" else 2,
                                                          fillstyle="none", linewidth=line_width if genre != "All" else 4,
                                                          markevery = slice(50, 1015, 50))

        
        axes.invert_xaxis()
        axes.legend(labels=labels, bbox_to_anchor=(0.13, 1.15), loc="upper left", fontsize=16, ncol= math.ceil(len(labels) / 2))
        plt.setp(axes.get_legend().get_texts(), fontsize='32') # for legend text
        plt.setp(axes.get_legend().get_title(), fontsize='32') # for legend title
        axes.set_xlabel("No. of features",fontsize=30)
        axes.set_ylabel("Wg. F1 Score",fontsize=30)
#         axes.set_title("Feature Reduction",fontsize=50, y = 0.0)
        axes.tick_params(labelsize=20)
        # Major ticks every 20, minor ticks every 5
        major_xticks = np.arange(0, mx_fet, 200) ## needs changing
        minor_xticks = np.arange(0, mx_fet, 20) ## needs changing
        
        # Major ticks every 20, minor ticks every 5
        major_yticks = np.arange(0.2, 1.0, 0.10)
        minor_yticks = np.arange(0.2, 1.0, 0.02)

        axes.set_xticks(major_xticks)
        axes.set_xticks(minor_xticks, minor=True)
        axes.set_yticks(major_yticks)
        axes.set_yticks(minor_yticks, minor=True)

        # And a corresponding grid
        axes.grid(which='both')

        # Or if you want different settings for the grids:
        axes.grid(which='minor', alpha=0.95)
        axes.grid(which='major', alpha=0.95)
        axes.patch.set_edgecolor('black')  

        axes.patch.set_linewidth('2') 
        plt.margins(x=0.01, y=0.05)

        plt.show()