

gold="gold_and_pred_data/ptb_dev_gold.discbracket"

pred_bert="gold_and_pred_data/ptb_dev_pred_bert.discbracket"
pred_fast="gold_and_pred_data/ptb_dev_pred_fasttext.discbracket"
pred_supe="gold_and_pred_data/ptb_dev_pred_supervised.discbracket"


results="results"
mkdir -p ${results}


# Run per phenomenon evaluation with test suite:
cd test_suite
python eval.py ../${gold} ../${pred_bert} annotations_dev_v1.1.csv --prefix ../${results}/bert_ > ../${results}/bert_disco_errors
python eval.py ../${gold} ../${pred_supe} annotations_dev_v1.1.csv --prefix ../${results}/supe  > ../${results}/supe_disco_errors
python eval.py ../${gold} ../${pred_fast} annotations_dev_v1.1.csv --prefix ../${results}/fast  > ../${results}/fast_disco_errors
cd ..

# Run discontinuous extension of Berkeley Parser analyser: (need py2.7 because codebase is the original Berkeley Parser Analyser)
mkdir -p ${results}/bpa_bert
mkdir -p ${results}/bpa_supe
mkdir -p ${results}/bpa_fast


python2 disco_berkeley_parser_analyser/classify_english.py ${gold} ${pred_bert} ${results}/bpa_bert/full > ${results}/log_bpa_bert
python2 disco_berkeley_parser_analyser/classify_english.py ${gold} ${pred_supe} ${results}/bpa_supe/full > ${results}/log_bpa_supe
python2 disco_berkeley_parser_analyser/classify_english.py ${gold} ${pred_fast} ${results}/bpa_fast/full > ${results}/log_bpa_fast
