 | Idx | Table      | Column | Primary Key | Foreign Key | 
 | ----------- | ----------- | ----------- | ----------- | ----------- | 
  | 0 |  | * |   |   | 
 | 1 | **players** | player_id | + |   | 
 | 2 |   | first_name |   |   | 
 | 3 |   | last_name |   |   | 
 | 4 |   | hand |   |   | 
 | 5 |   | birth_date |   |   | 
 | 6 |   | country_code |   |   | 
 | 7 | **matches** | best_of |   |   | 
 | 8 |   | draw_size |   |   | 
 | 9 |   | loser_age |   |   | 
 | 10 |   | loser_entry |   |   | 
 | 11 |   | loser_hand |   |   | 
 | 12 |   | loser_ht |   |   | 
 | 13 |   | loser_id |   | --> 1 | 
 | 14 |   | loser_ioc |   |   | 
 | 15 |   | loser_name |   |   | 
 | 16 |   | loser_rank |   |   | 
 | 17 |   | loser_rank_points |   |   | 
 | 18 |   | loser_seed |   |   | 
 | 19 |   | match_num |   |   | 
 | 20 |   | minutes |   |   | 
 | 21 |   | round |   |   | 
 | 22 |   | score |   |   | 
 | 23 |   | surface |   |   | 
 | 24 |   | tourney_date |   |   | 
 | 25 |   | tourney_id |   |   | 
 | 26 |   | tourney_level |   |   | 
 | 27 |   | tourney_name |   |   | 
 | 28 |   | winner_age |   |   | 
 | 29 |   | winner_entry |   |   | 
 | 30 |   | winner_hand |   |   | 
 | 31 |   | winner_ht |   |   | 
 | 32 |   | winner_id |   | --> 1 | 
 | 33 |   | winner_ioc |   |   | 
 | 34 |   | winner_name |   |   | 
 | 35 |   | winner_rank |   |   | 
 | 36 |   | winner_rank_points |   |   | 
 | 37 |   | winner_seed |   |   | 
 | 38 |   | year |   |   | 
 | 39 | **rankings** | ranking_date |   |   | 
 | 40 |   | ranking |   |   | 
 | 41 |   | player_id |   | --> 1 | 
 | 42 |   | ranking_points |   |   | 
 | 43 |   | tours |   |   | 
 
  | Index | Question  | SQL | gold QDMR | pred QDMR | Exec | SQL hardness |
  | ----------- | ----------- | ----------- |  ----------- | ----------- | ----------- | ----------- | 
 | SPIDER_dev_429 | Find the total number of players. | SELECT count(*) FROM players | 1. SELECT[tbl:​players] <br>2. AGGREGATE[count, #1] <br> | 1. SELECT[tbl:​players] <br>2. AGGREGATE[count, #1] <br> | + | easy | 
  | SPIDER_dev_431 | Find the total number of matches. | SELECT count(*) FROM matches | 1. SELECT[tbl:​matches] <br>2. AGGREGATE[count, #1] <br> | 1. SELECT[tbl:​matches] <br>2. AGGREGATE[count, #1] <br> | + | easy | 
  | SPIDER_dev_432 | Count the number of matches. | SELECT count(*) FROM matches | 1. SELECT[tbl:​matches] <br>2. AGGREGATE[count, #1] <br> | 1. SELECT[tbl:​matches] <br>2. AGGREGATE[count, #1] <br> | + | easy | 
  | SPIDER_dev_433 | List the first name and birth date of all players from the country with code USA. | SELECT first_name ,  birth_date FROM players WHERE country_code  =  'USA' | 1. SELECT[tbl:​players] <br>2. PROJECT[col:​players:​country_code, #1] <br>3. PROJECT[col:​players:​country_code, #2] <br>4. COMPARATIVE[#1, #3, comparative:​=:​USA:​col:​players:​country_code] <br>5. PROJECT[col:​players:​first_name, #4] <br>6. PROJECT[col:​players:​birth_date, #4] <br>7. UNION[#5, #6] <br> | 1. SELECT[tbl:​players] <br>2. PROJECT[col:​players:​country_code, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​USA:​col:​players:​country_code] <br>4. PROJECT[col:​players:​first_name, #3] <br>5. PROJECT[col:​players:​birth_date, #3] <br>6. UNION[#4, #5] <br> | + | medium | 
  | SPIDER_dev_434 | What are the first names and birth dates of players from the USA? | SELECT first_name ,  birth_date FROM players WHERE country_code  =  'USA' | 1. SELECT[tbl:​players] <br>2. FILTER[#1, comparative:​=:​USA:​col:​players:​country_code] <br>3. PROJECT[col:​players:​first_name, #2] <br>4. PROJECT[col:​players:​birth_date, #2] <br>5. UNION[#3, #4] <br> | 1. SELECT[tbl:​players] <br>2. COMPARATIVE[#1, #1, comparative:​=:​USA:​col:​players:​country_code] <br>3. PROJECT[col:​players:​first_name, #2] <br>4. PROJECT[col:​players:​birth_date, #2] <br>5. UNION[#3, #4] <br> | + | medium | 
  | SPIDER_dev_435 | Find the average age of losers and winners of all matches. | SELECT avg(loser_age) ,  avg(winner_age) FROM matches | 1. SELECT[tbl:​matches] <br>2. PROJECT[col:​matches:​winner_age, #1] <br>3. PROJECT[col:​matches:​loser_age, #1] <br>4. PROJECT[col:​matches:​loser_age, #2] <br>5. PROJECT[col:​matches:​winner_age, #3] <br>6. UNION[#4, #5] <br>7. AGGREGATE[avg, #6] <br> | 1. SELECT[tbl:​matches] <br>2. PROJECT[col:​matches:​loser_age, #1] <br>3. PROJECT[col:​matches:​winner_age, #1] <br>4. AGGREGATE[avg, #2] <br>5. AGGREGATE[avg, #3] <br>6. UNION[#4, #5] <br> | + | medium | 
  | SPIDER_dev_436 | What are the average ages of losers and winners across matches? | SELECT avg(loser_age) ,  avg(winner_age) FROM matches | 1. SELECT[tbl:​matches] <br>2. PROJECT[col:​matches:​loser_age, #1] <br>3. PROJECT[col:​matches:​winner_age, #1] <br>4. PROJECT[col:​matches:​loser_age, #2] <br>5. PROJECT[col:​matches:​winner_age, #3] <br>6. AGGREGATE[avg, #4] <br>7. AGGREGATE[avg, #5] <br>8. UNION[#6, #7] <br> | 1. SELECT[tbl:​matches] <br>2. PROJECT[col:​matches:​loser_age, #1] <br>3. PROJECT[col:​matches:​winner_age, #1] <br>4. AGGREGATE[avg, #2] <br>5. AGGREGATE[avg, #3] <br>6. UNION[#4, #5] <br> | + | medium | 
  | SPIDER_dev_437 | Find the average rank of winners in all matches. | SELECT avg(winner_rank) FROM matches | 1. SELECT[tbl:​matches] <br>2. PROJECT[col:​matches:​winner_rank, #1] <br>3. PROJECT[col:​matches:​winner_rank, #2] <br>4. AGGREGATE[avg, #3] <br> | 1. SELECT[tbl:​matches] <br>2. PROJECT[col:​matches:​winner_rank, #1] <br>3. AGGREGATE[avg, #2] <br> | + | easy | 
  | SPIDER_dev_439 | Find the highest rank of losers in all matches. | SELECT min(loser_rank) FROM matches | 1. SELECT[tbl:​matches] <br>2. PROJECT[col:​matches:​loser_rank, #1] <br>3. PROJECT[col:​matches:​loser_rank, #2] <br>4. AGGREGATE[min, #3] <br> | 1. SELECT[tbl:​matches] <br>2. PROJECT[col:​matches:​loser_rank, #1] <br>3. GROUP[count, #1, #2] <br>4. SUPERLATIVE[comparative:​max:​None, #2, #3] <br> | - | easy | 
  | SPIDER_dev_440 | What is the best rank of losers across all matches? | SELECT min(loser_rank) FROM matches | 1. SELECT[tbl:​matches] <br>2. PROJECT[col:​matches:​loser_rank, #1] <br>3. PROJECT[col:​matches:​loser_rank, #2] <br>4. AGGREGATE[min, #3] <br> | 1. SELECT[tbl:​matches] <br>2. PROJECT[col:​matches:​loser_rank, #1] <br>3. SUPERLATIVE[comparative:​max:​None, #1, #2] <br> | - | easy | 
  | SPIDER_dev_441 | find the number of distinct country codes of all players. | SELECT count(DISTINCT country_code) FROM players | 1. SELECT[tbl:​players] <br>2. PROJECT[col:​players:​country_code, #1] <br>3.*(distinct)* PROJECT[distinct #REF, #2] <br>4. AGGREGATE[count, #3] <br> | 1. SELECT[tbl:​players] <br>2. PROJECT[col:​players:​country_code, #1] <br>3.*(distinct)* PROJECT[None, #2] <br>4. AGGREGATE[count, #3] <br> | + | easy | 
  | SPIDER_dev_442 | How many distinct countries do players come from? | SELECT count(DISTINCT country_code) FROM players | 1. SELECT[tbl:​players] <br>2.*(distinct)* PROJECT[col:​players:​country_code, #1] <br>3. AGGREGATE[count, #2] <br> | 1. SELECT[tbl:​players] <br>2. PROJECT[col:​players:​country_code, #1] <br>3.*(distinct)* PROJECT[None, #2] <br>4. AGGREGATE[count, #3] <br> | + | easy | 
  | SPIDER_dev_443 | Find the number of distinct name of losers. | SELECT count(DISTINCT loser_name) FROM matches | 1. SELECT[col:​matches:​loser_name] <br>2.*(distinct)* PROJECT[col:​matches:​loser_name, #1] <br>3. AGGREGATE[count, #2] <br> | 1. SELECT[col:​matches:​loser_name] <br>2.*(distinct)* PROJECT[None, #1] <br>3. AGGREGATE[count, #2] <br> | + | easy | 
  | SPIDER_dev_444 | How many different loser names are there? | SELECT count(DISTINCT loser_name) FROM matches | 1.*(distinct)* SELECT[col:​matches:​loser_name] <br>2. AGGREGATE[count, #1] <br> | 1. SELECT[col:​matches:​loser_name] <br>2. AGGREGATE[count, #1] <br> | + | easy | 
  | SPIDER_dev_445 | Find the name of tourney that has more than 10 matches. | SELECT tourney_name FROM matches GROUP BY tourney_name HAVING count(*)  >  10 | 1. SELECT[col:​matches:​tourney_name] <br>2. PROJECT[tbl:​matches, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​>:​10] <br>5. PROJECT[col:​matches:​tourney_name, #4] <br> | 1. SELECT[col:​matches:​tourney_name] <br>2. PROJECT[tbl:​matches, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​>:​10] <br>5. PROJECT[col:​matches:​tourney_name, #4] <br> | + | easy | 
  | SPIDER_dev_446 | What are the names of tournaments that have more than 10 matches? | SELECT tourney_name FROM matches GROUP BY tourney_name HAVING count(*)  >  10 | 1. SELECT[col:​matches:​tourney_name] <br>2. PROJECT[tbl:​matches, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​>:​10] <br>5. PROJECT[col:​matches:​tourney_name, #4] <br> | 1. SELECT[col:​matches:​tourney_name] <br>2. PROJECT[tbl:​matches, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​>:​10] <br>5. PROJECT[col:​matches:​tourney_name, #4] <br> | + | easy | 
  | SPIDER_dev_447 | List the names of all winners who played in both 2013 and 2016. | SELECT winner_name FROM matches WHERE YEAR  =  2013 INTERSECT SELECT winner_name FROM matches WHERE YEAR  =  2016 | 1. SELECT[col:​matches:​winner_name] <br>2. FILTER[#1, comparative:​=:​2013:​col:​matches:​year] <br>3. FILTER[#1, comparative:​=:​2016:​col:​matches:​year] <br>4. INTERSECTION[#1, #2, #3] <br>5. PROJECT[col:​matches:​winner_name, #4] <br> | 1. SELECT[col:​matches:​winner_name] <br>2. COMPARATIVE[#1, #1, comparative:​=:​2013:​col:​matches:​year] <br>3. COMPARATIVE[#1, #1, comparative:​=:​2016:​col:​matches:​year] <br>4. INTERSECTION[#1, #2, #3] <br>5. PROJECT[col:​matches:​winner_name, #4] <br> | + | hard | 
  | SPIDER_dev_449 | List the number of all matches who played in years of 2013 or 2016. | SELECT count(*) FROM matches WHERE YEAR  =  2013 OR YEAR  =  2016 | 1. SELECT[tbl:​matches] <br>2. FILTER[#1, comparative:​=:​2013:​col:​matches:​year] <br>3. FILTER[#1, comparative:​=:​2016:​col:​matches:​year] <br>4. UNION[#2, #3] <br>5. AGGREGATE[count, #4] <br> | 1. SELECT[tbl:​matches] <br>2. PROJECT[col:​matches:​year, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​2013:​col:​matches:​year] <br>4. COMPARATIVE[#1, #2, comparative:​=:​2016:​col:​matches:​year] <br>5. UNION[#3, #4] <br>6. AGGREGATE[count, #5] <br> | + | medium | 
  | SPIDER_dev_450 | How many matches were played in 2013 or 2016? | SELECT count(*) FROM matches WHERE YEAR  =  2013 OR YEAR  =  2016 | 1. SELECT[tbl:​matches] <br>2. FILTER[#1, comparative:​=:​2013:​col:​matches:​year] <br>3. FILTER[#1, comparative:​=:​2016:​col:​matches:​year] <br>4. UNION[#2, #3] <br>5. AGGREGATE[count, #4] <br> | 1. SELECT[tbl:​matches] <br>2. COMPARATIVE[#1, #1, comparative:​=:​2013:​col:​matches:​year] <br>3. COMPARATIVE[#1, #1, comparative:​=:​2016:​col:​matches:​year] <br>4. UNION[#2, #3] <br>5. AGGREGATE[count, #4] <br> | + | medium | 
  | SPIDER_dev_455 | List the first and last name of all players in the order of birth date. | SELECT first_name ,  last_name FROM players ORDER BY birth_date | 1. SELECT[tbl:​players] <br>2. PROJECT[col:​players:​first_name, #1] <br>3. PROJECT[col:​players:​last_name, #1] <br>4. PROJECT[col:​players:​birth_date, #1] <br>5. UNION[#2, #3] <br>6. SORT[#5, #4] <br> | 1. SELECT[tbl:​players] <br>2. PROJECT[col:​players:​first_name, #1] <br>3. PROJECT[col:​players:​last_name, #1] <br>4. PROJECT[col:​players:​birth_date, #1] <br>5. UNION[#2, #3] <br>6. SORT[#5, #4, sortdir:​ascending] <br> | + | medium | 
  | SPIDER_dev_457 | List the first and last name of all players who are left / L hand in the order of birth date. | SELECT first_name ,  last_name FROM players WHERE hand  =  'L' ORDER BY birth_date | 1. SELECT[tbl:​players] <br>2. PROJECT[col:​players:​hand, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​L:​col:​players:​hand] <br>4. PROJECT[col:​players:​first_name, #3] <br>5. PROJECT[col:​players:​last_name, #3] <br>6. PROJECT[col:​players:​birth_date, #3] <br>7. UNION[#4, #5] <br>8. SORT[#7, #6] <br> | 1. SELECT[tbl:​players] <br>2. PROJECT[col:​players:​hand, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​L:​col:​players:​hand] <br>4. PROJECT[col:​players:​first_name, #3] <br>5. PROJECT[col:​players:​last_name, #3] <br>6. PROJECT[col:​players:​birth_date, #3] <br>7. UNION[#4, #5] <br>8. SORT[#7, #6, sortdir:​ascending] <br> | + | medium | 
  | SPIDER_dev_459 | Find the first name and country code of the player who did the most number of tours. | SELECT DISTINCT T1.first_name ,  T1.country_code FROM players AS T1 JOIN rankings AS T2 ON T1.player_id  =  T2.player_id ORDER BY T2.tours DESC LIMIT 1 | 1. SELECT[tbl:​players] <br>2. PROJECT[col:​rankings:​tours, #1] <br>3. GROUP[col:​rankings:​tours, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br>5. PROJECT[col:​players:​first_name, #4] <br>6. PROJECT[col:​players:​country_code, #4] <br>7. UNION[#5, #6] <br> | 1. SELECT[tbl:​players] <br>2. PROJECT[col:​rankings:​tours, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br>5. PROJECT[col:​players:​first_name, #4] <br>6. PROJECT[col:​players:​country_code, #4] <br>7. UNION[#5, #6] <br> | - | hard | 
  | SPIDER_dev_460 | What is the first name and country code of the player with the most tours? | SELECT DISTINCT T1.first_name ,  T1.country_code FROM players AS T1 JOIN rankings AS T2 ON T1.player_id  =  T2.player_id ORDER BY T2.tours DESC LIMIT 1 | 1. SELECT[tbl:​players] <br>2. PROJECT[col:​rankings:​tours, #1] <br>3. GROUP[col:​rankings:​tours, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br>5. PROJECT[col:​players:​first_name, #4] <br>6. PROJECT[col:​players:​country_code, #4] <br>7. UNION[#5, #6] <br> | 1. SELECT[tbl:​players] <br>2. PROJECT[col:​rankings:​tours, #1] <br>3. GROUP[sum, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br>5. PROJECT[col:​players:​first_name, #4] <br>6. PROJECT[col:​players:​country_code, #4] <br>7. UNION[#5, #6] <br> | - | hard | 
  | SPIDER_dev_461 | Find the year that has the most number of matches. | SELECT YEAR FROM matches GROUP BY YEAR ORDER BY count(*) DESC LIMIT 1 | 1. SELECT[col:​matches:​year] <br>2. PROJECT[tbl:​matches, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br> | 1. SELECT[col:​matches:​year] <br>2. PROJECT[tbl:​matches, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br> | + | hard | 
  | SPIDER_dev_462 | Which year had the most matches? | SELECT YEAR FROM matches GROUP BY YEAR ORDER BY count(*) DESC LIMIT 1 | 1. SELECT[tbl:​matches] <br>2. PROJECT[col:​matches:​year, #1] <br>3. GROUP[count, #1, #2] <br>4. SUPERLATIVE[comparative:​max:​None, #2, #3] <br> | 1. SELECT[col:​matches:​year] <br>2. PROJECT[tbl:​matches, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br> | + | hard | 
  | SPIDER_dev_465 | Find the name of the winner who has the highest rank points and participated in the Australian Open tourney. | SELECT winner_name FROM matches WHERE tourney_name  =  'Australian Open' ORDER BY winner_rank_points DESC LIMIT 1 | 1. SELECT[col:​matches:​winner_rank_points] <br>2. PROJECT[col:​matches:​winner_rank_points, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Australian Open:​col:​matches:​tourney_name] <br>4. PROJECT[col:​matches:​winner_rank_points, #3] <br>5. SUPERLATIVE[comparative:​max:​None, #3, #4] <br>6. PROJECT[col:​matches:​winner_name, #5] <br> | 1. SELECT[col:​matches:​winner_rank_points] <br>2. PROJECT[col:​matches:​winner_rank_points, #1] <br>3. COMPARATIVE[#2, #2, comparative:​=:​Australian Open:​col:​matches:​tourney_name] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br>5. PROJECT[col:​matches:​winner_name, #4] <br> | + | hard | 
  | SPIDER_dev_466 | What is the name of the winner with the most rank points who participated in the Australian Open tournament? | SELECT winner_name FROM matches WHERE tourney_name  =  'Australian Open' ORDER BY winner_rank_points DESC LIMIT 1 | 1. SELECT[col:​matches:​winner_rank_points] <br>2. FILTER[#1, comparative:​=:​Australian Open:​col:​matches:​tourney_name] <br>3. PROJECT[col:​matches:​winner_rank_points, #2] <br>4. COMPARATIVE[#2, #3, comparative:​max:​None] <br>5. PROJECT[col:​matches:​winner_name, #4] <br> | 1. SELECT[col:​matches:​winner_rank_points] <br>2. PROJECT[col:​matches:​winner_rank_points, #1] <br>3. COMPARATIVE[#2, #2, comparative:​=:​Australian Open:​col:​matches:​tourney_name] <br>4. GROUP[count, #3, #1] <br>5. SUPERLATIVE[comparative:​max:​None, #1, #4] <br>6. PROJECT[col:​matches:​winner_name, #5] <br> | + | hard | 
  | SPIDER_dev_467 | find the names of loser and winner who played in the match with greatest number of minutes. | SELECT winner_name ,  loser_name FROM matches ORDER BY minutes DESC LIMIT 1 | 1. SELECT[tbl:​matches] <br>2. PROJECT[col:​matches:​minutes, #1] <br>3. GROUP[col:​matches:​minutes, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br>5. PROJECT[col:​matches:​winner_name, #4] <br>6. PROJECT[col:​matches:​winner_name, #5] <br>7. PROJECT[col:​matches:​loser_name, #4] <br>8. PROJECT[col:​matches:​loser_name, #7] <br>9. UNION[#6, #8] <br> | 1. SELECT[tbl:​matches] <br>2. PROJECT[col:​matches:​minutes, #1] <br>3. GROUP[sum, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br>5. PROJECT[col:​matches:​loser_name, #4] <br>6. PROJECT[col:​matches:​winner_name, #4] <br>7. UNION[#5, #6] <br> | + | medium | 
  | SPIDER_dev_469 | Find the average ranking for each player and their first name. | SELECT avg(ranking) ,  T1.first_name FROM players AS T1 JOIN rankings AS T2 ON T1.player_id  =  T2.player_id GROUP BY T1.first_name | 1. SELECT[col:​players:​first_name] <br>2. PROJECT[col:​rankings:​ranking, #1] <br>3. GROUP[avg, #2, #1] <br>4. PROJECT[col:​players:​first_name, #1] <br>5. UNION[#3, #4] <br> | 1. SELECT[tbl:​players] <br>2. PROJECT[col:​rankings:​ranking, #1] <br>3. GROUP[avg, #2, #1] <br>4. PROJECT[col:​players:​first_name, #1] <br>5. UNION[#3, #4] <br> | + | medium | 
  | SPIDER_dev_470 | What are the first names of all players, and their average rankings? | SELECT T1.first_name ,  avg(ranking) FROM players AS T1 JOIN rankings AS T2 ON T1.player_id  =  T2.player_id GROUP BY T1.first_name | 1. SELECT[col:​players:​first_name] <br>2. PROJECT[col:​players:​first_name, #1] <br>3. PROJECT[col:​rankings:​ranking, #1] <br>4. GROUP[avg, #3, #1] <br>5. UNION[#2, #4] <br> | 1. SELECT[tbl:​players] <br>2. PROJECT[col:​players:​first_name, #1] <br>3. PROJECT[col:​rankings:​ranking, #1] <br>4. GROUP[avg, #3, #1] <br>5. UNION[#2, #4] <br> | + | medium | 
  | SPIDER_dev_471 | Find the total ranking points for each player and their first name. | SELECT sum(ranking_points) ,  T1.first_name FROM players AS T1 JOIN rankings AS T2 ON T1.player_id  =  T2.player_id GROUP BY T1.first_name | 1. SELECT[col:​players:​first_name] <br>2. PROJECT[col:​rankings:​ranking_points, #1] <br>3. GROUP[sum, #2, #1] <br>4. PROJECT[col:​players:​first_name, #1] <br>5. UNION[#3, #4] <br> | 1. SELECT[tbl:​players] <br>2. PROJECT[col:​rankings:​ranking_points, #1] <br>3. GROUP[sum, #2, #1] <br>4. PROJECT[col:​players:​first_name, #1] <br>5. UNION[#3, #4] <br> | + | medium | 
  | SPIDER_dev_472 | What are the first names of all players, and their total ranking points? | SELECT T1.first_name ,  sum(ranking_points) FROM players AS T1 JOIN rankings AS T2 ON T1.player_id  =  T2.player_id GROUP BY T1.first_name | 1. SELECT[col:​players:​first_name] <br>2. PROJECT[col:​players:​first_name, #1] <br>3. PROJECT[col:​rankings:​ranking_points, #1] <br>4. GROUP[sum, #3, #1] <br>5. UNION[#2, #4] <br> | 1. SELECT[tbl:​players] <br>2. PROJECT[col:​players:​first_name, #1] <br>3. PROJECT[col:​rankings:​ranking_points, #1] <br>4. GROUP[sum, #3, #1] <br>5. UNION[#2, #4] <br> | + | medium | 
  | SPIDER_dev_473 | find the number of players for each country. | SELECT country_code ,  count(*) FROM players GROUP BY country_code | 1. SELECT[tbl:​players] <br>2. PROJECT[col:​players:​country_code, #1] <br>3. GROUP[count, #1, #2] <br>4. UNION[#2, #3] <br> | 1. SELECT[col:​players:​country_code] <br>2. PROJECT[tbl:​players, #1] <br>3. GROUP[count, #2, #1] <br>4. UNION[#1, #3] <br> | + | medium | 
  | SPIDER_dev_474 | How many players are from each country? | SELECT country_code ,  count(*) FROM players GROUP BY country_code | 1. SELECT[col:​players:​country_code] <br>2. PROJECT[tbl:​players, #1] <br>3. GROUP[count, #2, #1] <br>4. UNION[#1, #3] <br> | 1. SELECT[col:​players:​country_code] <br>2. PROJECT[tbl:​players, #1] <br>3. GROUP[count, #2, #1] <br>4. UNION[#1, #3] <br> | + | medium | 
  | SPIDER_dev_475 | find the code of the country where has the greatest number of players. | SELECT country_code FROM players GROUP BY country_code ORDER BY count(*) DESC LIMIT 1 | 1. SELECT[col:​players:​country_code] <br>2. PROJECT[tbl:​players, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​max:​None] <br>5. PROJECT[col:​players:​country_code, #4] <br> | 1. SELECT[col:​players:​country_code] <br>2. PROJECT[tbl:​players, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br>5. PROJECT[col:​players:​country_code, #4] <br> | + | hard | 
  | SPIDER_dev_476 | What is the code of the country with the most players? | SELECT country_code FROM players GROUP BY country_code ORDER BY count(*) DESC LIMIT 1 | 1. SELECT[col:​players:​country_code] <br>2. PROJECT[tbl:​players, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​max:​None] <br>5. PROJECT[col:​players:​country_code, #4] <br> | 1. SELECT[col:​players:​country_code] <br>2. PROJECT[tbl:​players, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br>5. PROJECT[col:​players:​country_code, #4] <br> | + | hard | 
  | SPIDER_dev_477 | Find the codes of countries that have more than 50 players. | SELECT country_code FROM players GROUP BY country_code HAVING count(*)  >  50 | 1. SELECT[col:​players:​country_code] <br>2. PROJECT[tbl:​players, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​>:​50] <br>5. PROJECT[col:​players:​country_code, #4] <br> | 1. SELECT[col:​players:​country_code] <br>2. PROJECT[tbl:​players, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​>:​50] <br>5. PROJECT[col:​players:​country_code, #4] <br> | + | easy | 
  | SPIDER_dev_478 | What are the codes of countries with more than 50 players? | SELECT country_code FROM players GROUP BY country_code HAVING count(*)  >  50 | 1. SELECT[col:​players:​country_code] <br>2. PROJECT[tbl:​players, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​>:​50] <br>5. PROJECT[col:​players:​country_code, #4] <br> | 1. SELECT[col:​players:​country_code] <br>2. PROJECT[tbl:​players, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​>:​50] <br>5. PROJECT[col:​players:​country_code, #4] <br> | + | easy | 
  | SPIDER_dev_479 | Find the total number of tours for each ranking date. | SELECT ranking_date ,  sum(tours) FROM rankings GROUP BY ranking_date | 1. SELECT[col:​rankings:​ranking_date] <br>2. PROJECT[col:​rankings:​tours, #1] <br>3. GROUP[sum, #2, #1] <br>4. UNION[#1, #3] <br> | 1. SELECT[col:​rankings:​ranking_date] <br>2. PROJECT[col:​rankings:​tours, #1] <br>3. GROUP[count, #2, #1] <br>4. UNION[#1, #3] <br> | - | medium | 
  | SPIDER_dev_480 | How many total tours were there for each ranking date? | SELECT ranking_date ,  sum(tours) FROM rankings GROUP BY ranking_date | 1. SELECT[col:​rankings:​ranking_date] <br>2. PROJECT[col:​rankings:​tours, #1] <br>3. GROUP[sum, #2, #1] <br>4. UNION[#1, #3] <br> | 1. SELECT[col:​rankings:​ranking_date] <br>2. PROJECT[col:​rankings:​tours, #1] <br>3. GROUP[sum, #2, #1] <br>4. UNION[#1, #3] <br> | + | medium | 
  | SPIDER_dev_481 | Find the number of matches happened in each year. | SELECT YEAR ,  count(*) FROM matches GROUP BY YEAR | 1. SELECT[col:​matches:​year] <br>2. PROJECT[tbl:​matches, #1] <br>3. GROUP[count, #2, #1] <br>4. UNION[#1, #3] <br> | 1. SELECT[col:​matches:​year] <br>2. PROJECT[tbl:​matches, #1] <br>3. GROUP[count, #2, #1] <br>4. UNION[#1, #3] <br> | + | medium | 
  | SPIDER_dev_482 | How many matches were played in each year? | SELECT YEAR ,  count(*) FROM matches GROUP BY YEAR | 1. SELECT[col:​matches:​year] <br>2. PROJECT[tbl:​matches, #1] <br>3. GROUP[count, #2, #1] <br>4. UNION[#1, #3] <br> | 1. SELECT[col:​matches:​year] <br>2. PROJECT[tbl:​matches, #1] <br>3. GROUP[count, #2, #1] <br>4. UNION[#1, #3] <br> | + | medium | 
  | SPIDER_dev_485 | How many different winners both participated in the WTA Championships and were left handed? | SELECT count(DISTINCT winner_name) FROM matches WHERE tourney_name  =  'WTA Championships' AND winner_hand  =  'L' | 1.*(distinct)* SELECT[col:​matches:​winner_name] <br>2. FILTER[#1, comparative:​=:​WTA Championships:​col:​matches:​tourney_name] <br>3. FILTER[#1, comparative:​=:​L:​col:​matches:​winner_hand] <br>4. INTERSECTION[#1, #2, #3] <br>5. AGGREGATE[count, #4] <br> | 1. SELECT[val:​matches:​tourney_name:​WTA Championships] <br>2. COMPARATIVE[#1, #1, comparative:​=:​WTA Championships:​col:​matches:​tourney_name] <br>3. COMPARATIVE[#1, #1, comparative:​=:​WTA Championships:​col:​matches:​tourney_name] <br>4. INTERSECTION[#1, #2, #3] <br>5. AGGREGATE[count, #4] <br> | - | medium | 
  | SPIDER_dev_486 | Find the number of left handed winners who participated in the WTA Championships. | SELECT count(DISTINCT winner_name) FROM matches WHERE tourney_name  =  'WTA Championships' AND winner_hand  =  'L' | 1. SELECT[col:​matches:​winner_name] <br>2. FILTER[#1, comparative:​=:​L:​col:​matches:​winner_hand] <br>3. FILTER[#2, comparative:​=:​WTA Championships:​col:​matches:​tourney_name] <br>4. AGGREGATE[count, #3] <br> | 1. SELECT[val:​matches:​tourney_name:​WTA Championships] <br>2. PROJECT[tbl:​matches, #1] <br>3. AGGREGATE[count, #2] <br> | - | medium | 
  | SPIDER_dev_487 | Find the first name, country code and birth date of the winner who has the highest rank points in all matches. | SELECT DISTINCT T1.first_name ,  T1.country_code ,  T1.birth_date FROM players AS T1 JOIN matches AS T2 ON T1.player_id  =  T2.winner_id ORDER BY T2.winner_rank_points DESC LIMIT 1 | 1. SELECT[col:​matches:​winner_id] <br>2. PROJECT[tbl:​matches, #1] <br>3. PROJECT[col:​matches:​winner_rank_points, #2] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br>5. PROJECT[col:​players:​first_name, #4] <br>6. PROJECT[col:​players:​country_code, #4] <br>7. PROJECT[col:​players:​country_code, #5] <br>8. PROJECT[col:​players:​birth_date, #4] <br>9. UNION[#5, #7, #8] <br> | 1. SELECT[tbl:​players] <br>2. PROJECT[tbl:​matches, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br>5. PROJECT[col:​players:​first_name, #4] <br>6. PROJECT[col:​players:​country_code, #4] <br>7. PROJECT[col:​players:​birth_date, #4] <br>8. UNION[#5, #6, #7] <br> | - | hard | 
  | SPIDER_dev_489 | Find the number of players for each hand type. | SELECT hand ,  count(*) FROM players GROUP BY hand | 1. SELECT[col:​players:​hand] <br>2. PROJECT[tbl:​players, #1] <br>3. GROUP[count, #2, #1] <br>4. UNION[#1, #3] <br> | 1. SELECT[col:​players:​hand] <br>2. PROJECT[tbl:​players, #1] <br>3. GROUP[count, #2, #1] <br>4. UNION[#1, #3] <br> | + | medium | 
  | SPIDER_dev_490 | How many players are there for each hand type? | SELECT hand ,  count(*) FROM players GROUP BY hand | 1. SELECT[col:​players:​hand] <br>2. PROJECT[tbl:​players, #1] <br>3. GROUP[count, #2, #1] <br>4. UNION[#1, #3] <br> | 1. SELECT[col:​players:​hand] <br>2. PROJECT[tbl:​players, #1] <br>3. GROUP[count, #2, #1] <br>4. UNION[#1, #3] <br> | + | medium | 
 ***
 Exec acc: **0.8298**
