import React, { Component } from 'react';
import { Link } from "react-router-dom";

import MTurk from './MTurk.jsx';
import { gup } from '../util/gup.js';

export default class Feedback extends Component {
  constructor(props) {
    super(props);

    this.state = {
      feedback: "",
      confidence: 50,
    };

    this.handleInputChange = this.handleInputChange.bind(this);
    this.handleSubmit = this.handleSubmit.bind(this);
  }

  handleInputChange(event) {
    const target = event.target;
    const value = target.value;
    const name = target.name;

    this.setState({
      [name]: value
    });
  }

  handleSubmit(event) {
    if (this.state.confidence != 50) {
      const user = gup("workerId");
      const assignment_id = gup("internalAssignment");
      Meteor.call('feedback.submit', user, this.state.feedback, this.state.confidence, assignment_id);
      return "ready";
    } else {
      return "Confidence question requires an answer";
    }
  }

  render() {
    return (
      <div>
        <form onSubmit={this.handleSubmit}>
          How confident are you that your answers are correct?
          <div className="rangef">
          Very confident, I think I completed the task perfectly.
          <br />
          <input
            name="confidence"
            type="range"
            min="0" max="100"
            value={this.state.confidence}
            onChange={this.handleInputChange}
            orient="vertical"
            step="0.1"/>
          <br />
          The task was very difficult, I am unsure of most of my answer.
      </div>
          <br />
          Any feedback for the developers of this HIT?
          <br />
          <label>
            <textarea 
              name="feedback"
              value={this.state.feedback}
              onChange={this.handleInputChange}
              rows="4" cols="50">
            </textarea>
          </label>
        </form>
        <MTurk validate={this.handleSubmit} label={this.state.confidence == 50 ? "Please answer confidence" : "Submit HIT"} />
      </div>
    );
  }
}
