Цель исследования.
Оценка влияния смены терапии с типичных нейролептиков на атипичный антипсихотический препарат рисперидон на резидуальные психотические симптомы.
Материал и методы.
Обследовали 15 пациентов, 8 мужчин и 7 женщин, в возрасте 49,1±10,25 года, с диагнозом 'параноидная шизофрения, состояние неполной ремиссии' (F20.0Х4 по МКБ-10), получающих регулярную поддерживающую антипсихотическую терапию.
Оценку состояния больных проводили в начале (до введения в терапевтическую схему рисперидона) и в конце исследования по шкалам позитивных и негативных симптомов (PANSS), глобальной клинической оценки (СGI) и глобальной оценки функционирования GAF.
Первичным критерием эффективности терапии была определена редукция бредовой и галлюцинаторной симптоматики до уровня 1 (отсутствие) или 2 (минимальная степень) по пунктам Р1 'Бред' и/или Р3 'Галлюцинаторное поведение' шкалы PANSS.
Вторичными критериями была оценка динамики других психопатологических расстройств и уровня социального функционирования.
Период монотерапии рисперидоном в стабильной дозировке составил 2 мес, средняя доза - 4,62±1,35 мг/сут.
Результаты и заключение.
При замене терапии была отмечена достоверная положительная динамика суммарного балла позитивной подшкалы и общего суммарного балла по шкале PANSS, а также показателя CGI-S. Небольшая, но статистически значимая динамика обнаруживалась и в отношении общего функционирования больных (увеличение показателя по GAF).
Динамика резидуальных психотических симптомов оказалась неравномерной: выраженность галлюцинаторной симптоматики достоверно уменьшилась, в то время как уровень бредовых расстройств практически не изменился.
Авторы считают, что в патогенезе резидуальных психотических симптомов значительную роль может играть чрезмерная блокада дофаминовых структур, чем может объясняться положительный эффект терапии в наблюдениях с меньшей степенью блокады этих структур.
В этом случае терапевтические стратегии в период становления и поддержания неполной ремиссии не могут быть прямым продолжением терапии острого периода и требуют пересмотра назначения препаратов и изменения их дозировок.
Цель исследования.
До последнего времени в мировой литературе активно обсуждается проблема характерного для шизофрении возраста начала заболевания.
Хотя все чаще указывается на возрастающую частоту случаев позднего и сверхпозднего начала заболевания, по-прежнему считается, что шизофрения - болезнь подросткового или молодого возраста.
В задачу работы входило установление предпочтительного возраста больных к периоду начала заболевания при шизофрении.
Материал и методы.
Изучались данные, полученные в результате многолетних эпидемиологических исследований, проведенных в Научном центре психического здоровья РАМН.
Общее число обследованных больных, страдавших шизофренией и близкими к ней расстройствами, - 5486.
Подгруппа больных, заболевание которых соответствует современным критериям диагностики шизофрении, насчитывает 1108 человек.
Использовались клинико-эпидемиологический и статистический методы исследования.
Результаты.
Установлено, что в изучавшихся группах больных наибольшее число случаев начала заболевания приходится на молодой возраст (максимум - в 16-20 лет).
Однако это зависит главным образом от демографических факторов, поскольку более половины больных к моменту обследования находились в молодом или среднем возрасте.
Изучение группы больных старше 60 лет, а также больных, принадлежащих 'условному поколению' (при 100% дожитии до данного возраста), показало, что максимум случаев начала заболевания приходится на возраст 30-40 лет.
Заключение.
Проведенное исследование показало значительное преобладание случаев начала заболевания в подростковом и молодом возрасте. По мнению автора, это связано главным образом с демографическими характеристиками изученных групп больных, а не с патогенетическими механизмами шизофрении.
Последние определяют преимущественно средний возраст начала заболевания (30-40 лет).
Случаи как раннего, так и позднего начала заболевания не редки и являются обычными колебаниями среднего показателя, возникающими от случайных воздействий.
Цель исследования.
Изучение состояния церебрального кровотока и структурных изменений вещества головного мозга, процессов перекисного окисления липидов и антиоксидантной защиты, параметров гемостаза, показателей эндотелиальной дисфункции и апоптоза в зависимости от степени артериальной гипертензии (АГ).
Материал и методы.
Проведено комплексное обследование 84 больных с АГ в возрасте от 43 до 64 лет.
Результаты и заключение.
Описываются принципы деятельности мультидисциплинарной бригады, обеспечивающей адекватное ведение пациентов с органическим поражением головного мозга.
Анализируются принципы проведения, преимущества и риски ранней реабилитации, а также особенности проведения пассивной вертикализации.
В 2010 году, непосредственно после реализации ключевых положений Закона о доступном медицинском обслуживании (Affordable Care Act, ACA), медицинское страховое покрытие отсутствовало у 18% жителей США в возрасте до 65 лет.
Отсутствие медицинского страхового покрытия вкупе с нездоровым образом жизни приводит к тому, что по ряду показателей США часто уступают другим странам с высоким уровнем доходов.
К марту 2014 года закон ACA существенно изменил медицинское страховое покрытие в США, однако большая часть его основных положений — биржи медицинского страхования, расширение программы Medicaid, создание ответственных организаций по оказанию медицинской помощи и дополнительный надзор за страховыми компаниями — внедрены лишь частично.
Закон ACA не предусматривает создание жестких механизмов контроля расходов, присущих многим европейским системам здравоохранения.
Он также недвусмысленно запрещает создание институтов оценки экономической эффективности лекарственных препаратов, медицинского обслуживания и технологий подобных Национальному институту здоровья и клинического совершенствования в Соединенном Королевстве Великобритании и Северной Ирландии,
Развитие современных технологий в физиотерапии с использованием минеральных вод, расширение сегмента лечебных и лечебно-столовых минеральных вод, повышение конкурентных преимуществ отечественной продукции требуют проведения маркетинговых исследований потребительских предпочтений на рынке минеральных вод.
Цель — провести маркетинговое исследование и оценку потребительских предпочтений использования минеральных вод в Москве в сегменте лечебных и лечебно-столовых минеральных вод.
Материал и методы.
В опросе участвовали 697 потребителей лечебных и лечебно-столовых минеральных вод.
Выборку осуществляли детерминированным квотным методом.
Полевые исследования проводили c помощью методов личного устного опроса (32%) и CATI to Web (телефонный рекрутинг и онлайн-опрос; 68%) с использованием структурированной анкеты.
Позиционирование осуществляли с применением двумерной карты-схемы и индивидуальных балльных оценок с расчетом интегральных показателей.
Результаты и обсуждение.
Маркетинговые исследования показали, что для более 40% респондентов основными мотивами покупки минеральных вод являлись лечение и профилактика заболеваний, а патологии мочеполовой системы, органов пищеварения и дыхания — наиболее частой причиной использования воды.
Проведена оценка факторов, формирующих потребительские предпочтения использования минеральных вод.
Решающее значение для около 40% потребителей (р<0,01) имели медицинские показания и степень фармакологической эффективности минеральной воды.
Далее следовали ее качество, стоимость, производитель и/или место производства, привлекательность упаковки и др.
Выводы.
Цель исследования - изучение динамики показателей системы гемостаза у больных острым коронарным синдромом (ОКС) в сочетании с тревожно-депрессивными расстройствами (ТДР) в процессе терапии препаратом антидепрессивного действия - вальдоксаном (агомелатин).
Материал и методы.
Обследовали 196 пациентов обоего пола (средний возраст 64,2±0,8 года) в первые 24 ч после развития ОКС.
Были сформированы три группы больных: 1-я - пациенты с ОКС без ТДР (n=88), 2-я - пациенты с ОКС и ТДР, не лечившиеся вальдоксаном (n=58) и 3-я - пациенты с ОКС и ТДР, которым был назначен вальдоксан (n=50).
В первые 24 ч после госпитализации пациентов и на 10-е сутки было проведено исследование показателей коагуляционного и сосудисто-тромбоцитарного гемостаза.
Результаты и заключение.
У больных ОКС на всех этапах обследования выявлены высокие уровни фибриногена, растворимых фибрин-мономерных комплексов и Д-димера.
В группе пациентов с ТДР значения этих показателей были существенно выше, чем у больных без ТДР.
В группе больных ОКС и ТДР на фоне терапии вальдоксаном уровень Д-димера на 10-е сутки обследования приближался к показателям пациентов с ОКС без ТДР.
В обеих группах больных ОКС с сопутствующими ТДР значения спонтанной агрегации в 1-е сутки госпитализации и при выписке на 10-е сутки значительно превышали не только показатели контрольной группы, но и значения пациентов в группе ОКС без ТДР.
У всех больных ОКС были высокими показатели агрегации тромбоцитов стимулированной аденозиндифосфатом в дозе 0,1 мкМ.
Малоизученность, отсутствие патогенетически обоснованного метода лечения и ассоциированность с прогрессированием возрастной макулярной дегенерации (ВМД) делают макулярные друзы (МД) интересным объектом для исследований.
Цель — дать клиническую характеристику МД с помощью современных визуализационных методов.
Материал и методы.
Результаты.
Проведенные диагностические исследования позволили верифицировать тип твердых друз, классифицировав их на кутикулярные друзы и ретикулярные псевдодрузы.
Для указанных типов друз, а также мягких друз, дана сравнительная характеристика по каждому из использованных методов визуализации.
Анализ витреоретинального интерфейса выявил высокую распространенность витреомакулярной адгезии у пациентов с сочетанием ретикулярных псевдодруз и кутикулярных друз.
Оценка толщины хориоидеи в девяти секторах макулярной зоны не позволила обнаружить отличия от показателей групп контроля.
У всех пациентов из группы регрессировавших до атрофии мягких друз ретроспективно обнаружены описанные ранее в литературе ОКТ-признаки «надвигающейся» ГА.
Заключение.
Продемонстрированы возможности современных диагностических методов в описании и дифференциальной диагностике различных типов МД.
Оценка прогностического значения выявляемых изменений требует отдельного исследования.
В позднем и резидуальном периодах инсульта наряду с традиционным восстановлением силы и баланса параартрикулярных мышц, подвижности суставов паретичной конечности необходимо уделять внимание тренировке сложных пространственных движений.
Цель исследования - оценить эффективность роботизированной терапии в восстановлении функции верхней конечности в поздней и резидуальной стадиях инсульта.
В исследовании приняли участие 52 пациента после ишемического инсульта в средней мозговой артерии, которые были разделены рандомизированно на 2 группы.
Больным обеих групп 5 дней в неделю в течение 3 нед проводили лечебную гимнастику по общепринятой методике, массаж, лазеротерапию и импульсные токи.
В основной группе (n=36) дополнительно осуществляли на аппаратном комплексе MultiJointSystem (MJS) тренинг сложных пространственных движений, скорости, плавности, точности и ловкости.  Занятия проходили по 40 мин 5 дней в неделю в течение 3 нед.
Анализ результатов исследования выявил статистически достоверные различия в увеличении объема движения в локтевом и плечевом суставах, повышении скорости и точности выполнения движений у больных основной группы по сравнению с контрольной.
Аппаратное восстановление сложных пространственных движений верхней конечностью в отдаленные сроки после перенесенного инсульта повышает функциональные возможности и бытовую независимость пациента.
Цель - оценка результатов клинического исхода двустороннего кистозного макулярного отека (КМО) у пациента с мультифокальной коррекцией афакии при операции факоэмульсификации катаракты.
Материал и методы.
В статье описан случай развития двустороннего КМО после операции неосложненной факоэмульсификации катаракты с имплантацией мультифокальных ИОЛ 'M-flex' Rayner у пациента 66 лет с благоприятным исходом.
Мониторинг заболевания осуществляли методами оптической когерентной томографии (ОКТ) сетчатки и мультифокальной электроретинографии (мф-ЭРГ).
Результаты.
КМО развился в первом глазу через 3 нед после операции. Процесс лечения занял около 1,5 года.
В содружественном глазу КМО развился через 2 нед после операции. Процесс лечения занял около 0,5 года.
Мониторинг сетчатки проводили в первом глазу около 5 лет, содружественного - 2 года.
Выводы.
Показано, что метод ОКТ сетчатки позволяет уточнить диагноз клинической формы КМО и подтверждает положительный эффект лечения; метод мф-ЭРГ дает возможность оценивать наиболее тонкие механизмы восстановления функции сетчатки после КМО, которое происходит в течение нескольких лет.
Реабилитация больных, страдающих от последствий ожоговой травмы, остается одной из актуальных проблем пластической хирургии.
До настоящего времени не существует единой стратегии, определяющей оптимальные сроки и этапность лечения, возможность и целесообразность проведения симультанных вмешательств на различных анатомических областях, сочетания хирургического и консервативного лечения, что необходимо для уменьшения сроков реабилитации пострадавших.
На основе анализа 12-летнего опыта лечения 1246 больных с последствиями ожоговой травмы авторы разработали универсальный алгоритм с целью оптимизации хирургического лечения, улучшения результатов и сокращения сроков лечения.
Цель исследования.  Оценить эффективность и безопасность длительной последовательной терапии препаратом мексидол у пациентов с полушарным ишемическим инсультом (ИИ) в остром и раннем восстановительном периодах.
Материал и методы.
В рандомизированное двойное слепое мультицентровое плацебо-контролируемое в параллельных группах исследование включен 151 пациент (62 мужчины и 89 женщин), рандомизированы 150 пациентов (62 мужчины и 88 женщин) в возрасте от 40 до 79 лет.
Пациенты методом простой рандомизации распределялись на 2 группы: больные 1-й группы получали терапию мексидолом по 500 мг/сут внутривенно капельно в течение 10 дней с последующим приемом по 1 таблетке (125 мг) 3 раза в сут в течение 8 нед.
Пациенты 2-й группы получали плацебо по аналогичной схеме.
Продолжительность участия в исследовании составила от 67 до 71 сут.
Результаты.
На момент окончания терапии средний балл по модифицированной шкале Рэнкина (мШР) был ниже в 1-й группе, чем во 2-й (p=0,04).
Динамика уменьшения среднего балла по мШР (1-5-й визиты) была более выраженной в 1-й группе (p=0,023). Доля пациентов, достигших восстановления, соответствующего 0-2 баллам по мШР (5-й визит), была достоверно выше в 1-й группе (p=0,039).
При тестировании по шкале инсульта Национального института здоровья на 5-м визите среднее значение было ниже в 1-й группе (p=0,035). Снижение балла по шкале инсульта Национального института здоровья на момент окончания курса терапии относительно исходного уровня у пациентов с сахарным диабетом было более выражено в 1-й группе (p=0,038).
В 1-й группе в общей популяции пациентов и субпопуляции пациентов с сахарным диабетом динамика улучшения качества жизни была более выраженной и наблюдалась со 2-го визита.
Доля пациентов с отсутствием проблем с передвижением в пространстве была достоверно выше в 1-й группе (p=0,022).
Достоверных различий по частоте нежелательных явлений у пациентов обеих групп выявлено не было.
Заключение.
Рекомендовано применение препарата мексидол в остром и раннем восстановительном периодах ИИ.
Цель - на основании анализа литературы и собственного опыта улучшить диагностику и результаты хирургического лечения разрыва - редкого осложнения истинных аневризм подколенных артерий.
Материал и методы.
За период с 1999 по 2015 г. в отделении сосудистой хирургии НИИ СП им.  Н.В. Склифосовского оперированы 8 пациентов по поводу разрыва аневризмы подколенной артерии.
Осложнение в виде разрыва составило 2,9% всех выявленных аневризм.
У 7 больных разрыв сопровождался ишемией конечности различной выраженности: острой I стадии - у 2 (25%), острой IIА стадии - у 1 (12,5%), острой IIБ стадии - у 1 (12,5%), хронической IIБ стадии - у 2 (25%), хронической III стадии - у 1 (12,5%), ишемии конечности не было у 1 (12,5%) больного.
Дооперационно во всех наблюдениях выполняли УЗДГ артерий, УЗИ мягких тканей нижних конечностей, в трех - МСКТ-исследование сосудистого русла и мягких тканей бедра и голени, в пяти - субтракционную дигитальную ангиографию.
Оценивали наличие и размер гематомы мягких тканей, состояние артериального русла проксимальнее и дистальнее подколенной артерии, а также выявляли аневризмы контралатеральной конечности и аневризмы иной локализации.
Результаты.
Оперированные конечности удалось сохранить в 6 наблюдениях.
5 больных выписаны с функционирующим протезом, полной компенсацией кровообращения, первичным заживлением послеоперационной раны.
Тяжелые послеоперационные осложнения, потребовавшие ампутации конечности, развились у 2 больных.
Умер один больной с реперфузионным синдромом, инфицированием гематомы и протеза, сепсисом.
Вывод.
1. Разрыв аневризмы подколенной артерии, возникающий крайне редко, тем не менее является тяжелым осложнением, угрожающим потерей конечности, а иногда и жизни больного.
2. С целью предотвращения грозных осложнений необходимы раннее выявление аневризмы подколенных артерий и хирургическое лечение до возникновения эмболии, тромбоза и разрыва.  3. Своевременная выявляемость как наличия самих аневризм подколенных артерий, так и их осложнений врачами общей практики, крайне низкая, что обусловлено редкостью и специфичностью заболевания, наличием множества симптомов.
Необходима популяризация знаний об этом заболевании среди врачей общей практики.
4. Скрининговым методом выявления и дифференциальной диагностики служит ультразвуковое исследование.  5. Для оценки состояния дистального артериального русла (так называемых путей оттока) при стабильном состоянии больного и неугрожающей ишемии конечности возможно выполнение мультиспиральной КТ-ангиографии или субтракционной ангиографии.
6. Оперативное лечение в объеме резекции аневризмы, протезирования подколенной артерии необходимо выполнять в ранние сроки после возникновения разрыва, чтобы сократить сроки ишемии конечности и предотвратить инфицирование гематомы на фоне ишемии конечности и анемизации больного.
Результаты анализа сведений из специальной литературы свидетельствуют, что в настоящее время в судебно-медицинской экспертной практике нет объективных данных, позволяющих диагностировать повреждения тела и одежды человека, причиненные выстрелами из духовых ружей.
Применение для стрельбы из этих метательных устройств различных дротиков, обладающих конструктивными особенностями, существенно влияет на морфологические признаки возникающих повреждений, что может служить предпосылкой для дифференцирования их от повреждений из других видов метательных устройств.
Цель - изучить полиморфизм гена CFH (Т402Н) у больных с глаукомой и пациентов группы контроля.
Материал и методы.
Генетический анализ проводили у 68 пациентов с разными стадиями первичной открытоугольной глаукомы (ПОУГ).
Контрольную группу составили 30 человек.
Материалом исследования служила венозная кровь.
Анализу подвергали геномную ДНК человека, выделенную из лейкоцитов цельной крови.Далее с образцами выделенной ДНК была проведена полимеразная цепная реакция (ПЦР).
Результаты.
Среди обследованных (как в группе больных с ПОУГ, так и в группе контроля) не было обнаружено пациентов с гомозиготным полиморфизмом по аллелю 402Н.
При прогрессировании патологического процесса (гибели ганглионарных клеток) количество гомозигот с отсутствием полиморфизма гена CFH увеличивается до 65%, а количество гетерозигот уменьшается до 35%.
Выводы.
Наши генетические исследования показали, что при начальной и развитой стадии ПОУГ превалируют гетерозиготы.
На этих стадиях патологического процесса большая вероятность повреждения собственных ганглионарных клеток.
С прогрессированием заболевания количество гетерозигот постепенно уменьшается до 35%, что связано со значительной гибелью клеток нейроэпителия и как следствие - снижением интенсивности аутоиммунной реакции из-за уменьшения числа клеток-мишеней.
Материал и методы.
Изучены результаты профилактики параколостомической грыжи с помощью сетчатого аллотрансплантата.
Всего в исследовании приняли участие 73 пациента с опухолевой патологией нижнеампулярного отдела прямой кишки.
Во всех наблюдениях выполняли брюшно-промежностную экстирпацию прямой кишки открытым или лапароскопическим способом.
У 21 больного применена профилактическая аллопластика параколостомической области по Sugarbaker.
Использованы модификации данного этапа операции для чрезбрюшной и забрюшинной стомы.
Результаты.
Послеоперационных осложнений, связанных с применением аллотрансплантата, не отмечено.
В группе профилактики грыжа выявлена в 1 (4,8%) случае, в контрольной группе у 14 (26,9%) больных.
Заключение.
Первые результаты применения композитного аллотрансплантата для профилактики параколостомической грыжи являются обнадеживающими.
Отсутствие специфических осложнений и благоприятные отдаленные результаты позволяют продолжить исследование.
Приведен случай интерстициального заболевания легких, установленный гистологическим исследованием.  Выявлены дефекты прижизненной диагностики.
Отмечена ошибка посмертной диагностики: при макроскопическом исследовании органов грудной полости выявлен линейный разрыв спайки в области корня правого легкого длиной и глубиной до 0,5 см, послуживший причиной гемоторакса и малокровия внутренних органов, что предположительно стало причиной смерти больного.
По результатам гистологического исследования установлено основное заболевание — интерстициальная болезнь легких.
Проиллюстрирована гистологическая картина процесса.
Рассмотрены особенности организации и ведения инновационной деятельности в Омском государственном медицинском университете, дан обзор инновационных разработок сотрудников стоматологического факультета ОмГМА.
Проанализированы: факторы, стимулирующие и затрудняющие инновационную детальность в медицинском вузе; проблемы внедрения медицинских инноваций, отсутствия в Россиии системы оценки медицинских технологий, регламентов организации инновационной деятельности в медицинских вузах; сформулированы перспективы в этой области, связанные с принятием решений на государственном уровне.
Цель исследования.  Одновременный анализ образцов ВИЧ-1 из всех российских регионов для характеристики эпидемиологии ВИЧ-инфекции в стране в целом.
Материалы и методы.
Выполнено наиболее обширное исследование нуклеотидных последовательностей гена pol образцов ВИЧ-1, выделенных от позитивных по ВИЧ лиц из разных регионов России с датой установления диагноза 1987-2015 гг.
Нуклеотидные последовательности генома ВИЧ-1 анализировали с помощью компьютерных программ и открытых он-лайн-приложений для определения подтипа вируса и выявления новых рекомбинантных форм.
Результаты.
Проведен анализ нуклеотидных последовательностей гена pol 1697 образцов ВИЧ-1 и получены данные о доминировании в России генетического варианта IDU-A подтипа А1 на всей территории России (более 80% всех случаев инфекции).
Проведен анализ других вариантов вируса, циркулирующих в России, в том числе подтверждено ранее описанное в литературе явление увеличения степени распространения рекомбинанта CRF63_02A1 в Сибири.
Выявлены 4 новые рекомбинантные формы, сформированные вирусами подтипа A1 (IDU-A) и B, а также две AG-рекомбинантные формы.
Обнаружено увеличение генетической дистанции между вирусами варианта IDU-A, циркулирующими в среде потребителей инъекционных наркотиков и в среде лиц, инфицированных в результате гетеросексуальных контактов, а также изменение вируса подтипа G, вызвавшего вспышку на юге страны в 1988-1989 гг., с течением времени.
Заключение.
Полученные данные демонстрируют непрерывность процесса генетической изменчивости и рекомбинации ВИЧ-1 в России с течением времени, а также увеличение генетического разнообразия с увеличением степени пораженности населения ВИЧ-инфекцией.
Цель исследования - оценка возможностей видеоэндоскопических технологий в лечении больных осложненными формами раком ободочной кишки.
Материал и методы.
В исследование вошли больные, оперированные с применением видеоэндоскопической техники (n=18) и из открытого доступа (n=11).
Результаты.
Среднее время, затраченное на выполнение хирургического вмешательства в этой группе больных, составило 158,8±10,7 мин.
В группе больных, оперированных планово, средняя длительность операции составила 161,3 мин (р>0,05).
Средняя кровопотеря была невелика, составив 122,5±17,9 мл.
Сроки общей госпитализации составили 23,1±2,4 сут, послеоперационной - 8,6±0,5 сут.
Интраоперационных и послеоперационных осложнений не было.
Видеоэндоскопические вмешательства могут быть выполнены у больных раком ободочной кишки по экстренным показаниям, в том числе у больных с тяжелыми осложнениями основного заболевания.
В статье на оригинальном клиническом и цитоморфологическом материале рассмотрены морфофункциональные характеристики эритроцитов в клинических моделях преждевременного старения (при эссенциальной артериальной гипертензии, ИБС и сахарном диабете).
Показано, что при процессах старения и преждевременного старения происходят изменения формы и размеров клеток, нарушаются межклеточные взаимодействия, изменяется эластичность мембран клеток и активизируются процессы клеточной деструкции.
Топографическая дезориентация - нарушение способности узнавать местность и ее ориентиры, распознавать свое положение в пространстве, находить ранее знакомые и запоминать новые маршруты, использовать карту для ориентации.
Функции топографической ориентировки обеспечиваются задними отделами теменной коры, ретроспленальной корой и задними отделами поясной извилины, медиальными отделами височной доли, язычной извилиной и префронтальной корой и осуществляются в эгоцентрической или аллоцентрической системах отсчета.
В эгоцентрической (тело-центрированной) системе человек оценивает расположение предметов по отношению к осям и плоскостям собственного тела; аллоцентрическая система основывается на пространственных отношениях между предметами и не связана с ориентацией субъекта.
Нарушения топографической ориентации наблюдаются при очаговых поражениях головного мозга и нейродегенеративных заболеваниях.
Они могут иметь в основе агнозию ориентиров на местности, эгоцентрическую дезориентацию, дезориентацию в направлении и антероградную дезориентацию.
В диагностике топографической дезориентации применяются бланковые методики, задания на перемещение в реальном или виртуальном трехмерном пространстве.
Реабилитация больных с топографической дезориентацией использует восстановительные и компенсаторные стратегии.
Выбор общей стратегии реабилитации и конкретных методик во многом зависит от причины и степени повреждения головного мозга.
Для изучения особенностей состояния сердечно-сосудистой системы у пациентов с сахарным диабетом 2-го типа в зависимости от наличия тиреоидной патологии и возраста были обследованы 264 больных.
Их разделили на три группы: 1-я пациенты с диффузно-узловыми изменениями щитовидной железы, 2-я пациенты с аутоиммунными болезнями щитовидной железы, 3-я пациенты без тиреоидной патологии (контрольная), в каждой из них обследовали разные возрастные группы.
Все пациенты находились в эутиреоидном состоянии.
В ходе обследования обнаружено, что выявляемая при сахарном диабете 2-го типа тиреоидная патология, даже в состоянии эутиреоза, вносит особенности в клиническую картину и течение сочетанной диабетической и сердечно-сосудистой патологии.
По данным лабораторно-инструментальных исследований установлено, что у пациентов с сочетанной диабетической и тиреоидной патологией имеются более высокая встречаемость фибрилляции предсердий, ИБС, желудочковой экстрасистолии высоких градаций.
У них также отмечали более неблагоприятные формы ремоделирования ЛЖ, чаще встречали сочетание диастолической и систолической дисфункций.
Сделан вывод о необходимости ранней диагностики и коррекции нарушений сердечно-сосудистой и тиреоидной систем у больных сахарным диабетом 2-го типа, в том числе в состоянии эутиреоза.
Цель — определить влияние активатора плазминогена урокиназного типа (АПУ) на культуру клеток пигментного эпителия сетчатки (ПЭС) человека.
Материал и методы.
Токсичность АПУ в концентрации 50 ЕД/мл была исследована с помощью теста исключения трипанового синего.
Влияние АПУ на миграционную активность оценивали в тестах заживления раны монослоя и миграции в камере Бойдена.
Кроме того, было изучено влияние АПУ на морфологию клеток, устойчивость к трипсину и экспрессию маркера клеточной пролиферации Ki67.
Результаты.
Тест исключения трипанового синего не выявил цитотоксических эффектов АПУ в отношении ПЭС.
АПУ в концентрации 50 ЕД/мл вызывал появление клеточных скоплений, увеличение количества веретеновидных клеток (в контроле и в присутствии 50 ЕД/мл АПУ соответственно 6,4±2,4 и 67,3±3,2 кл/поле, p<0,001) и статистически значимое увеличение миграционной способности в камере Бойдена (в 1,75 раза, p=0,012).
Статистически значимое (p<0,05) дозозависимое увеличение скорости заживления раны монослоя и количества Ki67-позитивных клеток было выявлено во всех опытных образцах (от 2,5 до 50 ЕД/мл).
Кроме того, под действием АПУ наблюдали уменьшение устойчивости клеток ПЭС к трипсину (количество устойчивых клеток в контроле и в присутствии 50 ЕД/мл АПУ соответственно 5,2±1,7 и 0,46±0,32 кл/поле, p<0,001).
Заключение.
АПУ не оказывает цитотоксические эффекты на ПЭС в концентрации до 50 ЕД/мл.
При этом эффекты АПУ в отношении ПЭС сводятся к стимуляции эпителиально-мезенхимального перехода, миграционной активности, клеточной пролиферации и межклеточного взаимодействия.
При этом изменение миграционной активности и пролиферации имеет дозозависимый характер.
В современной медицине при назначении препаратов учитывают патогенез заболевания и механизм действия лекарства.
В обзорной статье на примере буспирона показано, что в психиатрии рекомендации по назначению препаратов также должны учитывать патогенез заболеваний (расстройств) и механизм действия лекарства.
Эти данные будут способствовать сближению психиатрии с неврологией и другими медицинскими специальностями.
Рассматривается клинический случай успешного химиотерапевтического и лучевого лечения больной раком молочной железы с метастазами в головной мозг, с поражением его оболочек и с выраженным неврологическим дефицитом.
Проводилось комбинированное лечение (облучение всего головного мозга СОД 30 Гр и локальное облучение метастаза СОД 15 Гр на фоне приема капецитабина) с дальнейшим приемом капецитабина до частичного улучшения - метастаз уменьшился на 50%, наступил полный регресс неврологического дефицита.
Безрецидивный период составил 1 год и 10 мес, общая выживаемость - 2 года.
Внедрение в клиническую практику новых высокоэффективных антидепрессантов позволило существенно повысить качество терапии депрессии.
Однако достижение полной ремиссии, которое является основной целью терапии пациентов с депрессией, по-прежнему остается труднодостижимой задачей.
У значительного числа пациентов антидепрессанты оказываются недостаточно эффективными, в связи с чем в последние годы активно изучаются методы повышения эффективности терапии депрессивных состояний.
В обзоре представлены результаты исследований применения препарата буспирон как средства аугментации терапии антидепрессантами у пациентов с большим депрессивным расстройством.
Обоснование исследования - распространенность миопии в мире.
По данным ВОЗ, миопия - одна из пяти ведущих причин слепоты и слабовидения.
Среди имеющихся сообщений об использовании консервативных методов лечения для стабилизации миопии в последние годы заслуживают внимание два направления: это применение оптических методов коррекции (в частности, ортокератологической коррекции) с воздействием на периферическую рефракцию и фармакологических средств.
Цель исследования - оценка эффективности и безопасности контроля миопии у пациентов детского возраста при использовании сочетания двух методов - ортокератологической коррекции и инстилляций сверхмалых доз атропина (0,01%).
Материал и методы.
В проспективное когортное исследование включен 31 пациент (62 глаза) в возрасте от 8 до 14 лет с приобретенной миопией слабой 14 (28), средней 11 (22) и высокой 6 (12) степени.  Пациентов обследовали до и через 6 мес после присоединения 0,01% раствора атропина к ношению ортокератологических линз (ОКЛ) при продолжающемся процессе прогрессирования миопии.
Измеряли рефракцию (Huvitz MRK 3100P), переднезаднюю ось (IOL-Master, 'CarlZeiss', Германия), объективный аккомодационный ответ (Grand Seiko WRK-5100K), запасы относительной аккомодации, псевдоаккомодацию.
Результаты.
Наиболее заметная эффективность снижения темпов прогрессирования наблюдалась при миопии слабой (в 1,5 раза, р<0,05) и средней (в 1,7 раза, р<0,05) степени, при высокой миопии достоверных изменений не отмечено.
Очевидно, тормозящий эффект ОКЛ, обусловленный оптическими факторами (а именно - периферическим миопическим дефокусом), даже в сочетании с атропином не может остановить прогрессирование высокой миопии, в основе которого лежит нарушение структурных и биомеханических свойств склеральной капсулы.
Заключение.
На сегодняшний день предварительные результаты не позволяют говорить о 100% эффективности длительной атропинизации сверхмалыми концентрациями, тем не менее положительный результат наблюдался, исследование продолжается.
Представлен опыт лечения 432 больных хроническим геморроем с использованием различных вариантов латексного лигирования.
Разработана и предложена для практического применения новая методика латексного лигирования - лигирование слизистой и подслизистой оболочки нижнеампулярного отдела прямой кишки, которая одновременно обеспечивает несколько лечебных эффектов: лигирование геморроидальных сосудов, лифтинг и мукопексию.
Эту методику лигирования целесообразно использовать при I и II стадиях хронического внутреннего геморроя.
При III и IV стадиях заболевания авторы рекомендуют применять одномоментное комбинированное лигирование слизистой нижнеампулярного отдела прямой кишки и лигирование внутренних геморроидальных узлов.
У 103 больных были использованы различные варианты латексного лигирования в сочетании с иссечением наружных геморроидальных узлов.
Указанные варианты латексного лигирования в лечении хронического геморроя сохраняют важные преимущества процедуры - миниинвазивность, относительную простоту и широкую доступность, низкую стоимость.
В отдаленном периоде хорошие результаты использования различных вариантов лигирования получены в 87,3% наблюдений.
Предлагаемая тактика применения латексного лигирования расширяет диапазон использования данной методики и повышает результативность лечения больных хроническим геморроем разных стадий и клинических форм.
Цель - уточнить особенности морфохимических изменений клеточных структур черного вещества головного мозга при болезни Паркинсона.
Материал и методы.
На аутопсийном материале головного мозга умерших от интеркуррентных заболеваний с болезнью Паркинсона и лиц, у которых в анамнезе сведения о неврологических расстройствах отсутствовали (контрольная группа), изучали микроскопически и оценивали количественно структурные характеристики черного вещества, используя методы компьютерной морфометрии.
Результаты.
Проведенное исследование позволило уточнить особенности морфохимических изменений как нейронных структур, так и глиальных популяций черного вещества головного мозга при болезни Паркинсона.
По сравнению с контрольной группой у пациентов с болезнью Паркинсона в компактной части черного вещества (вентральная область) число нейронов, содержавших тирозингидроксилазу (маркер дофаминовых нейронов), было ниже, а плотность распределения телец Леви - выше.
Накопление соединений железа (II) в клеточных элементах и нейропиле, а также усиление экспрессии кислого глиофибриллярного белка в нейроглии при болезни Паркинсона было выражено более отчетливо, чем в контроле.
Заключение.
Патологоанатомический диагноз при болезни Паркинсона должен основываться на полном описании комплекса нейронных и глиальных морфохимических и структурных изменений черного вещества, а не только на выявлении клеточных маркеров нейродегенеративного процесса.
Сравнивали особенности самосознания у 17 лиц 65–89 лет с додементными когнитивными нарушениями и у 17 больных сосудистой деменцией 65–91 года.
Сопоставляли жалобы со стороны психической сферы и результаты нейропсихологического обследования.
Нейропсихологическая диагностика включала оценку степени нарушения ряда высших психических функций, таких как внимание, память, мышление, гнозис (зрительный, слуховой), праксис, речь.
Пожилые респонденты без деменции адекватно оценивали состояние высших психических функций.
Больные сосудистой деменцией, как правило, отрицали когнитивный дефицит или объясняли его возрастными изменениями.
Независимо от состояния соматического здоровья, пожилые лица с недементными когнитивными нарушениями занимали активную позицию по отношению к старению.
Они могли найти способы компенсации когнитивного снижения самостоятельно.
Больные сосудистой деменцией не могли компенсировать когнитивный дефект даже при поддержке.
Ефрем Осипович Мухин - один из основоположников русской судебно-медицинской школы, основатель отечественной травматологии, хирург, анатом, физиолог, токсиколог и гигиенист, действительный статский советник.
Е.О. Мухин 22 года руководил кафедрой анатомии, физиологии и судебной медицины Московского Императорского университета. Он преподавал судебную медицину, анатомию, физиологию, токсикологию и медицинскую полицию.
Впервые в русской физиологии представил основные положения рефлекторной теории. Наиболее полно для своего времени разработал проблему о единстве и взаимодействии организма и окружающей среды.
Е.О. Мухин является основоположником анатомо-физиологического направления в медицине.
Цель данного исследования - изучение взаимосвязи дистального смещения головок нижней челюсти в височно-нижнечелюстном суставе (ВНЧС) с постуральной патологией.
Мы обследовали 20 человек из контрольной группы (возраст 18-25 лет) и 70 пациентов того же возраста с мышечно-суставной дисфункцией (МСД ВНЧС), осложненной зубочелюстными аномалиями (дистальный прикус - 27 человек, ортогнатический с аномалиями положения отдельных зубов - 18, глубокий - 16, мезиальный - 4, прямой - 2, открытый - 2, перекрестный - 1), до и после лечения окклюзионными шинами.
Всем обследованным были сделаны конусно-лучевая компьютерная томография (КЛКТ) ВНЧС и фотометрический анализ.
Анализ КЛКТ был проведен по разработанной нами методике, фотометрический анализ - с помощью разработанной нами компьютерной программы.
Таким образом, в результате исследования у лиц с МСД ВНЧС, осложненной зубочелюстными аномалиями, было выявлено достоверное смещение нижней челюсти кзади и кверху, а также по данным фотометрического анализа наличие постуральных нарушений как во фронтальной плоскости (изменение положения головы относительно плеч и горизонтали, нарушение конфигурации лица в виде асимметрии расположения линий глаз, углов рта и плеч), так и в сагиттальной (переднее смещение головы и наклон вертикальной оси тела вперед).
Лечение пациентов с применением окклюзионных шин позволило нормализовать положение головок нижней челюсти и осанку.
Цель исследования - улучшение результатов лечения больных с варикозными пищеводно-желудочными кровотечениями (ВПЖК), происходящими на фоне тромбоцитопении цирротического генеза.
Материал и методы.
Располагая опытом лечения 338 больных с ВПЖК, из которых у 162 выполнена процедура эндоскопического лигирования (ЭЛ) вариксов, и у 157 - операции трансъюгулярного внутрипеченочного портосистемного шунтирования (TIPS/ТИПС), проанализирована эффективность медикаментозно-компрессионных гемостатических мероприятий.
Результаты.
Включение в комплекс мер медикаментозного гемостаза серотонина адипината в дозе 30-50 мг в сутки в течение 3-5 дней при невозможности выполнения неотложного ЭЛ позволяет добиться более эффективной остановки ВПЖК за счет усиления адгезивной способности тромбоцитов и формирования плотного фибринового сгустка.
Это приводит к снижению показателей летальности (33,3% против 46,7% в контрольной группе) и риска рецидива геморрагии (46,4 и 60,0% соответственно) и создает предпосылки для достижения устойчивого гемостаза с помощью процедуры ЭЛ впоследствии, а также выполнения эффективной портальной декомпрессии с помощью операции TIPS/ТИПС.
Цель исследования. Изучение особенностей стратегий самоконтроля эпилептических приступов и их связи с индивидуальным копинг-стилем у больных фокальной эпилепсией.
Материал и методы.
Наблюдали 21 пациента с фокальной эпилепсией.
Стратегии контроля развития эпилептических приступов проводили с помощью шкалы CBES-SC, копинг-стиль - по шкале Brief COPE.
В контрольную группу вошли 20 здоровых.
Результаты и заключение.
Контролировать эпилептические приступы пытались 86% пациентов, большинство из них (33%) отдавали приоритет поведенческим стратегиям, направленным на минимизацию последствий приступа.
Пациенты с высокой активностью в отношении контроля за возникновением приступов отличались от лиц с низким контролем адаптивным копинг-стилем (p<0,01).
Установлено, что психологическая поддержка, ориентированная на эффективный копинг-стиль, может мотивировать пациента к широкому использованию стратегий контроля за развитием приступов, способствуя тем самым лучшей психосоциальной адаптации пациента.
Тиреотропиномы (ТТГ-секретирующие опухоли)  — редкий тип аденом гипофиза, на долю которых приходится около 0,5—2,0% всех опухолей гипофиза.
Критерием тиреотропиномы является визуализация опухоли при нормальном или повышенном уровне тиреотропного гормона (ТТГ) в крови и при наличии повышенных концентраций свободного Т4 (св.Т4) и свободного Т3 (св.Т3).
Цель исследования — изучить клинические, диагностические, морфологические характеристики и результаты лечения ТТГ-секретирующих опухолей гипофиза.
Материал и методы.
В исследование включены пациенты с аденомой гипофиза и нормальным или повышенным уровнем ТТГ в крови в сочетании с повышенными уровнями св.Т4 и св.Т3, оперированные в НИИ нейрохирургии с 2002 по 2015 г., всего 21 человек от 15 до 67 лет.
До операции, в раннем послеоперационном периоде и через 6 мес после нее пациентам проводилось исследование уровней ТТГ, св.Т4, св.Т3, пролактина, кортизола, лютеинизирующего гормона (ЛГ), фолликулостимулирующего гормона (ФСГ), эстрадиола/тестостерона, инсулиноподобного фактора роста (ИФР-1).
При оценке тиреоидного статуса использовались следующие референсные значения: ТТГ 0,4—4,0 мЕд/л, св.Т4 11,5—22,7 пмоль/л, св.Т3 3,5—6,5 пмоль/л.
Иммуногистохимическое исследование материала проводили с антителами к ТТГ, ПРЛ, СТГ, АКТГ, ЛГ, ФСГ, Ki-67 (клон MiB-1), в 13 случаях исследование с антителами к соматостатиновым рецепторам 2-го и 5-го типа и дофаминовым рецепторам D2 подтипа.
Результаты.
Тиреотропиномы выявлялись у пациентов в возрасте от 15 до 67 лет (медиана 39 лет) с одинаковой частотой у мужчин (48%) и женщин (52%).
11 пациентов (52%) до поступления в НИИ нейрохирургии имели ошибочный диагноз первичного гипертиреоза, по поводу чего 7 из них были оперированы на щитовидной железе и/или получали тиреостатики (4 наблюдения).
Cимптоматика гипертиреоза отмечена у 16 (76%) больных.
Уровень ТТГ в крови составил 2,47—38,4 мЕд/л (медиана 6,56), св.Т4 22,8—54,8 нмоль/л (медиана 36), св.Т3 4,24—12,9 пмоль/л (медиана 9,66).
В 4 (19%) случаях опухоли были эндоселлярными, в 17 (91%) случаях — эндо-экстраселлярной локализации.
Радикальное удаление опухоли было проведено у 7 (33%) пациентов.
Все эти опухоли были эндоселлярной и эндо-супраселлярной локализации.
В случае инфильтративно растущей аденомы (врастающей в структуры основания черепа) ни у одного из пациентов радикального удаления не было.
При иммуногистохимическом исследовании препаратов удаленных опухолей экспрессия только ТТГ выявлена в 3 (14%) случаях, 18 (86%) опухолей были плюригормональные и секретировали ТТГ и СТГ и/или ПРЛ.
Из 13 опухолей экспрессия дофаминовых рецепторов 2-го типа выявлена в 9 (69%), соматостатиновых рецепторов 5-го типа — в 6 (46%), соматостатиновых рецепторов 2-го типа — в 2 (15%) случаях.
Заключение.
Критерием радикального удаления опухоли было снижение уровня ТТГ после операции до 0,1 мЕд/л и ниже.
Радикальное удаление опухоли было осуществимо у 33% пациентов только с эндоселлярной и эндо-супраселлярной локализацией.
В большинстве случаев опухоли были плюригормональные и секретировали ТТГ и СТГ и/или ПРЛ.
В настоящее время проблема лечения пациентов с варикозной болезнью нижних конечностей продолжает оставаться весьма актуальной, так как распространенность данного заболевания высока и число больных постоянно увеличивается.
Стоит отметить, что отечественные и зарубежные флебологи наряду с открытыми хирургическими операциями на венах все чаще используют миниинвазивные эндовенозные методики в комплексном лечении пациентов с варикозной болезнью.
В представленном литературном обзоре детально рассмотрены две самые распространенные и эффективные процедуры – радиочастотная облитерация вен нижних конечностей и эндовазальная лазерная коагуляция.
Продемонстрированы положительные стороны данных методик, ближайшие и отдаленные результаты их применения, отмечены возможные осложнения – типичные и редкие.
Большинство специалистов, применяющих радиочастотную облитерацию вен нижних конечностей и эндовазальную лазерную коагуляцию, отмечают высокую результативность их использования при варикозной болезни нижних конечностей, в том числе и у больных при наличии выраженных трофических нарушений.
Информация, полученная многими авторами при сравнении эффективности различных эндовенозных процедур, позволяет их оценивать объективно и правильно устанавливать показания к тому или иному вмешательству.
Цель работы - улучшение результатов хирургического лечения детей с протяженным стенозом трахеи.
Материал и методы.
С 2013 г. в ДГКБ #13 оперированы четверо детей с диагнозом протяженный стеноз трахеи методом скользящей трахеопластики в условиях экстракорпоральной мембранной оксигенации. Возраст пациентов находился в диапазоне от 1 года 2 мес до 4,5 лет.
Вес пациентов от 10,5 до 16 кг.
Всем пациентам после предоперационного обследования был установлен диагноз протяженный стеноз трахеи, полные хрящевые кольца.
Показания к оперативному вмешательству основывались на данных анамнеза, степени выраженности ДН и данных обследования.
Всем пациентам в условиях экстракорпоральной мембранной оксигенации выполнена скользящая трахеопластика из различных доступов.
Результаты.
Интраоперационных осложнений не наблюдалось.
В группе исследования 1 летальный исход - пациент погиб в отдаленном п/о периоде после выписки из стационара в связи с резким ухудшением состояния на фоне ОРВИ при переводе из стационара в стационар вследствие острой ДН.
Осложнение в ближайшем послеоперационном периоде у 1 пациента в виде выраженного роста грануляционной ткани в зоне анастомоза, что потребовало выполнения курса лазерной фотокоагуляции и длительной интубации.
Среднее время пребывания пациентов в отделении реанимации составило 24 дня, длительность ИВЛ - 11 дней.
Контрольное обследование пациентам проводилось на сроках 4-6 и 12 мес после операции.
У 2 пациентов первые 6-8 мес отмечались умеренные жалобы на рецидивирующий трахеобронхит без явлений дыхательной недостаточности в послеоперационном периоде.
У 1 ребенка жалобы полностью отсутствуют.
Экспрессия раково-тестикулярных (сancer/testis - СТ) генов варьирует в зависимости от типа опухоли.
Существуют опухоли с высокой, низкой и промежуточной экспрессией генов.
Опухолевые клетки разного происхождения характеризуются коэкспрессией генов СТ.
Экспрессия СТ генов возрастает на более поздних стадиях развития опухоли, при наличии метастазов.
При раке толстой кишки в опухолевых образцах чаще всего выявляется мРНК генов MAGE-A и SSX.
В образцах периферической крови чаще выявляется мРНК генов XAGE, MAGE-C и SSX.
У больных раком толстой кишки экспрессия генов TSP50, MAGE-A(1-6) и SSX1,2,4 ассоциирована с неблагоприятным прогнозом, экспрессия генов MAGE-C1 и XAGE1 - с благоприятным.
Цель  Провести качественное и количественное исследование эффективности программы по управлению контактами ребенка со взрослыми пациентами, больными туберкулезом, в Индонезии.
Методы
Для оценки недостатков программы управления контактами ребенка в легочной клинике была использована схема оценки, применяемая в системе здравоохранения.
Целевые значения показателей выполнения программы были получены на основе установленных целевых показателей программы, научной литературы и мнений экспертов.
Соблюдение правил скрининга туберкулеза, начало профилактической терапии изониазидом у детей младше 5 лет, точность диагностики туберкулеза и соблюдение правил профилактической терапии оценивалось в отношении 755 контактировавших детей в двух группах.
Кроме того, был проведен опрос 22 основных опекунов и 34 сотрудников клиники для оценки знаний и принятия ребенком правил управления контактами.
Кроме того, была учтена стоимость расходов опекунов.
Также была подсчитана разница между наблюдаемыми и целевыми значениями показателей.
Результаты
Разница между наблюдаемыми и целевыми показателями эффективности составила: 82% для соблюдения правил скрининга; от 64% до 100% для диагностической точности, 50% для начала профилактической терапии, 54% для соблюдения правил терапии и 50% для затрат.
Многие сотрудники не обладали достаточными знаниями в вопросах управления контактами детей или не проявляли должного отношения к данным вопросам, особенно в части профилактического лечения изониазидом.
Опекуны проявили хорошее знание скрининга, но не превентивной терапии, и им затруднительно было ездить в клинику и оплачивать расходы.
Исследование выявило широко распространенные недостатки в работе системы управления контактами детей в Индонезии, все из которых, похоже, поддаются устранению.
Использованная схема оценки системы здравоохранения может применяться и в других условиях, когда не удается осуществить управление контактами ребенка.
Цель исследования - изучение факторов риска развития инсульта у мужчин разных возрастных групп, подвергающихся воздействию неблагоприятных производственных факторов.
Материал и методы.
Обследованы 411 мужчин в возрасте от 30 до 65 лет, перенесших инсульт, из них 335 пациентов подвергались влиянию неблагоприятных производственных факторов и 76 пациентов, которые воздействия вредных факторов не испытывали (группа сравнения).
Результаты.
Установлена частота распределения факторов риска развития инсульта у мужчин в зависимости от характера профессиональных вредностей.
Сравнение ряда стеклоиономерных цементов российского производства - Цемион (ВладМиВа), Глассин Рест (Омега-Дент) и Цемфил 10 (СтомаДент) - и зарубежного Fuji VIII (GC Corporation) показало, что по адгезии к твердым тканям зубов и динамике выхода фторида в водную вытяжку эти цементы сопоставимы.
При близком содержании фтора скорость выхода фторида в водную вытяжку у кальциевых и кальций-бариевых стекол значительно выше, чем у стронциевых.
Синдром Веста — одна из самых известных эпилептических энцефалопатий, катастрофическая эпилепсия раннего детского возраста.
Прогноз течения болезни определяется его этиологией, а также терапией.
В статье обзорного характера рассматривается гормональная терапия синдрома.
В международной практике предпочтение отдается адренокортикотропному гормону — в США или его синтетическому аналогу тетракозиду — в Европе (оба препарата не зарегистрированы в Российской Федерации).
Мнения по эффективности перорального применения кортикостероидов (в том числе преднизолона) противоречивы.
В последнее время появились данные о достаточно высокой эффективности преднизолона.
В статье обсуждаются разные аспекты гормональной терапии синдрома Веста: возможные механизмы действия, выбор препарата, дозы гормонов, продолжительность, эффективность и переносимость гормональной терапии.
Цель исследования.  Анализ факторов, способствующих увеличению риска развития стойкой послеоперационной когнитивной дисфункции (ПОКД) у пациентов, перенесших операцию коронарного шунтирования (КШ) в условиях искусственного кровообращения (ИК).
Материалы и методы.
Обследовали 257 пациентов мужского пола в возрасте от 45 до 69 лет с ишемической болезнью сердца (ИБС), которым выполнено плановое КШ в условиях ИК.
Всем пациентам, помимо стандартного клинического обследования, проводили нейрофизиологическое тестирование за 3-5 дней до операции, на 7-14-е сутки и через год после КШ.
Наличие стойкой ПОКД диагностировали у пациентов при наличии 20% снижения когнитивных показателей через 1 год после операции по сравнению с дооперационными 20% нейропсихологических тестов.
Для выявления факторов, предположительно влияющих на риск развития стойкой ПОКД, применяли регрессионный анализ в виде бинарной логистической регрессии.
Результаты.
Установлено, что при наличии у пациентов исходно высокого когнитивного статуса, развитии ПОКД в раннем послеоперационном периоде КШ, выполненного в условиях ИК, низкой степени соблюдения схемы назначенного лечения и прогрессировании стенозов сонных артерий (СА) через 1 год после операции можно с высокой долей вероятности (85%) прогнозировать развитие стойкой ПОКД.
Заключение.
Полученные результаты свидетельствуют о многофакторном происхождении стойкой ПОКД, в ее развитии значительную роль играет не только предоперационное состояние когнитивного статуса, но и факторы послеоперационного периода, такие как степень соблюдения схемы назначенного лечения, ранняя ПОКД и прогрессирование стенозов СА.
В статье представлен обзор результатов исследований влияния музыки на функцию различных физиологических систем организма, включая нервную, сердечно-сосудистую и эндокринную, а также по эффекту воздействия музыки Моцарта и позднего, зрелого барокко.
Особое внимание уделено сведениям о влиянии различных видов музыки (классической, джазовой, рок-музыки), характера и степени музыкальной активности (слушатели, любители, профессиональные исполнители) на когнитивные и поведенческие функции, состояние здоровья, продолжительность жизни и долголетие. Обсуждаются возможные механизмы влияния музыки на организм, обусловленные структурными акустическими и историко-культурологическими особенностями музыки разных эпох и стилей.
Описаны структурные и акустические свойства музыки, определяющие её лечебный эффект, при сравнении с влиянием в этих аспектах рока и классики.
Рассмотрены также перспективы применения музыки для лечения и профилактики ассоциированных с возрастом заболеваний.
Цель исследования - оценка валидности русскоязычной версии модифицированной Адденбрукской когнитивной шкалы (АКШ-м) в диагностике деменции при болезни Альцгеймера (БА).
Материал и методы.
Сравнивали АКШ-м с краткой шкалой оценки психического статуса (MMSE) в процессе обследования 78 человек, 49 больных БА и 29 здоровых.
Результаты и заключение.
АКШ-м показала высокую надежность в диагностике деменции при БА.
Коэффициент альфа Кронбаха составил 0,89.
АКШ-м является кратким и простым в применении тестом, который оценивает широкий спектр когнитивных функций, дает полное представление о когнитивном дефекте и выявляет деменцию при БА с большей надежностью, чем MMSE.
Данная шкала не только способствует постановке диагноза, но и помогает дифференцировать с другими причинами деменций.
Цель - установить зависимость основных биомеханических показателей роговицы от проводимой гипотензивной терапии и морфофункционального состояния глаза.
Материал и методы.
Проведено динамическое наблюдение 58 пациентов (62 глаза) с первичной открытоугольной глаукомой (ПОУГ) в сроки от 36 до 42 мес.
В первой части исследования пациенты были разделены на 2 группы в зависимости от значения корнеального гистерезиса (КГ).
Значение КГ в 1-й группе (37 глаз) соответствовало норме и составляло 8,3-12,4 мм рт.ст., во 2-й группе (25 глаз) было снижено до 5,6-8,2 мм рт.ст. Во второй части исследования пациентам 2-й группы с низким значением КГ в качестве дополнительной терапии назначали фиксированную комбинацию бримонидина 2 мг/мл и тимолола 5 мг/мл (Комбиган, Allergan) по следующей инстилляционной схеме: по 1 капле 2 раза в день с интервалом 12 ч.
Через 1, 3, 6, 12 и 18 мес оценивали субъективные и объективные показатели структурно-функционального состояния органа зрения.
Результаты.
В первой части исследования динамики морфофункциональных показателей зрительного нерва при разных показателях КГ было установлено, что при значении менее 8,2 мм рт.ст. структурно-функциональные изменения зрительного нерва более выражены и существенно повышается риск прогрессирования глаукомного процесса, что требует коррекции гипотензивного режима.
Во второй части исследования в группе динамического наблюдения с низкими значениями КГ, учитывая отрицательную структурно-функциональную динамику, гипотензивная терапия была назначена в комбинации с препаратом 'Комбиган'.
Дополнительная терапия оказала статистически значимое воздействие на уровень внутриглазного давления, в среднем снижая его на 4,6 мм рт.ст., и на значение КГ, в среднем повышая его на 2,3 мм рт.ст. Анализ изменений периметрического индекса корректированной внутригрупповой вариабельности снижения светочувствительности показал уменьшение количества относительных дефектов различной глубины (от 8,9 до 6,9 дБ).
Анализ данных оптической когерентной ретинотомограммы на фоне инстилляции фиксированной комбинации бримонидина и тимолола показал тенденцию к увеличению средней толщины ретинальных нервных волокон (от 0,11 до 0,18 мм).
Динамическое наблюдение в течение 18 мес продемонстрировало стабильность структурно-функциональных параметров диска зрительного нерва, т.е. целевое давление у этих пациентов было достигнуто.
Выводы.
При низких значениях КГ применение фиксированной комбинации бримонидина и тимолола (Комбиган) в комплексной терапии пациентов с ПОУГ позволяет нормализовать биомеханические параметры глаза и стабилизировать глаукомный процесс.
Цель исследования - уточнить эффективность дополнительных методов диагностики прижизненности образования странгуляционной борозды, а также рассмотреть вопросы установления темпа наступления смерти и асфиксии.
Материал и методы.
Материалом послужили 17 случаев (13 мужчин и 4 женщины) странгуляционной механической асфиксии в возрасте от 8 до 28 лет.
Повешение происходило на фоне различной степени алкоголемии с формированием типичных косовосходящих полужестких странгуляционных борозд.
Группу сравнения составили 3 случая утопления и 1 случай удавления руками.
Контролем служили 10 случаев острых форм ишемической болезни сердца и 5 случаев смерти от травматического шока.
Исследование всех трупов проводили по традиционной методике в первые сутки после смерти.
В качестве специальных лабораторных исследований использовали стандартные методики гистологического и иммуногистохимических исследований с поликлональными антителами к общему цитокератину, фибриногену, иммуноглобулину ламбда, фибронектину и CD-117.
Применяли окраску по Шпильмайеру и толуидиновым синим.
Результаты.
Результаты свидетельствуют о возможности диагностики странгуляционной механической асфиксии с помощью реакции с антителами к фибриногену в строме странгуляционной борозды даже при отсутствии иных признаков прижизненности, а также к антигену CD-117 в ткани легких.
Экспрессия последнего характерна преимущественно для альвеолярной гипоксии.
Обсуждается возможность применения других маркеров для дифференциальной диагностики механической асфиксии и других видов смерти.
Возрастная макулярная дегенерация (ВМД) — хроническое прогрессирующее заболевание, характеризующееся поражением центральной зоны сетчатки.
В основе патогенеза ВМД лежат характерные для старения изменения хориокапилляров, ретинального пигментного эпителия (РПЭ) и мембраны Бруха, но механизмы, запускающие переход обычных возрастных изменений в патологический процесс, неизвестны.
Результатами патологических изменений в РПЭ и хориоидее становятся гибель фоторецепторов и необратимая потеря зрения.
Несмотря на интенсивные исследования патогенеза ВМД, информация о молекулярно-генетических предпосылках событий, ведущих к гибели фоторецепторов, как и о путях их гибели, крайне ограничена, что затрудняет поиск эффективных методов лечения ВМД, прежде всего — наиболее распространенной атрофической («сухой») формы заболевания.  Недавние исследования показали, что не только апоптозные, но и аутофагические и некротические сигнальные каскады участвуют в клеточной гибели клеток в сетчатке.
В настоящем обзоре обобщены имеющиеся в литературе данные о трех основных формах программируемой клеточной гибели — апоптозе, некрозе и аутофагии и их роли в патогенезе ВМД.
Розацеа - полиэтиологическое хроническое воспалительное заболевание c различными клиническими проявлениями.
В первую очередь - это дерматологическое заболевание, однако нередки глазные проявления с поражением век, роговицы и конъюнктивы.
В статье освещены основные аспекты этиопатогенеза, варианты клинического течения заболевания и подходы к лечению.
Учитывая разнородную клиническую манифестацию розацеа, в том числе ее глазной формы, различную тяжесть патологического процесса, до конца не изученные этиологию и патогенез, универсальные схемы лечения на сегодняшний день отсутствуют.
Ведущая роль в патологическом процессе принадлежит нарушениям регуляторных механизмов в сосудистой, иммунной и нервной системах.
При этом выявляется повышенный уровень металлопротеиназ и сосудистого эндотелиального фактора роста (VEGF).
Не исключается влияние ряда микроорганизмов.
Базисная терапия включает использование препаратов как системного, так и местного действия.
К первым относят антибиотики тетрациклинового ряда.
Новым направлением в лечении розацеа с целью восстановления структурной и функциональной целостности эндотелия сосудов, улучшения микроциркуляции и нормализации реологических свойств крови является применение ангиопротекторов, в частности кальция добезилата (Докси-Хем).
В лечении глазных форм, помимо системной терапии, используют средства местного воздействия, такие как препараты искусственной слезы, выбор которых зависит от тяжести глазных симптомов, противовоспалительные средства и иммунодепрессанты.
В особо тяжелых случаях поражения роговицы возможно выполнение различных видов кератопластики.
Для выбора адекватной тактики лечения поражения глаз при розацеа необходима совместная работа офтальмологов и дерматологов.
В статье анализируется концепция латентной шизофрении E. Bleuler, ее связь с простой формой этого заболевания и обоснование идеи о том, что любая форма шизофрении может быть латентной.
Обсуждается блейлеровская интерпретация значения различных психопатологических симптомов для диагностики шизофрении и некоторые внутренние противоречия его диагностического подхода (декларируемая абсолютность критериев).
Отмечается также различное влияние представлений Е. Bleuler на последующие национальные концепции шизофрении и их развитие в отечественной психиатрии.
Под диэнцефальной кахексией (ДК) понимают прогрессирующее снижение массы тела, обусловленное опухолевым поражением гипоталамуса.
Это редкое (в литературе описано около 100 случаев), но потенциально смертельное расстройство с неизвестным до сих пор патогенезом.
В настоящее время не существует эффективных фармакологических методов его лечения.
Регресс кахексии может отмечаться только на фоне уменьшения объема опухоли, поэтому своевременная диагностика и лечение становятся жизненно важными для пациента.
Развитие ДК характерно для раннего детского возраста и лишь единичные случаи зарегистрированы у взрослых.
Мы представляем редкое наблюдение - развитие ДК у женщины 24 лет с папиллярной краниофарингиомой.
Имеющиеся в современной научной литературе данные свидетельствуют о том, что взаимоотношение между головной болью и деменцией представляется в настоящее время бо`льшим, чем просто коморбидность.
Так, в отношении мигрени и головной боли напряжения показана четкая связь между выраженностью цефалгии и тяжестью когнитивных расстройств.
В основе достоверной связи между развитием первичной головной боли и интеллектуально-мнестическим снижением, может лежать общность патофизиологических механизмов.
Предполагается связь изменений антиноцицептивной системы при первичных головных болях и развития глутаматергической эксайтотоксичности при деменциях, возникающей вследствие гипервозбудимости NMDA-рецепторов.
Это имеет важное практическое значение в аспекте возможной коррекции рассматриваемой патологии препаратами-модуляторами NMDA-рецепторов.
Мемантин оказывает терапевтический эффект не только в отношении когнитивных нарушений, но и существенно влияет на частоту эпизодов и выраженность первичной головной боли.
Цель исследования. Представить нейропсихологическую характеристику постинсультных когнитивных нарушений (ПИКН) в остром периоде ишемического инсульта (ИИ), а также оценить эффективность применения препарата целлекс.
Материал и методы.
Выполнено комплексное нейропсихологическое тестирование 288 пациентов в остром периоде ИИ.
30 пациентов дополнительно к основной терапии получали целлекс в дозе 0,1 мг (1 мл) подкожно в течение 10 дней, терапия была начата в острейшем периоде.
Результаты и заключение.
У 87% пациентов в остром периоде ИИ выявлены мультифункциональные ПИКН.
У большинства больных наблюдались нарушения внимания, регуляторных функций, речи и памяти.
Более чем у 1/3 пациентов отмечались мультифункциональные неамнестические познавательные нарушения.
Монофункциональные неамнестические ПИКН встречались в 5,5%.
Изолированный мнестический дефицит наблюдался у 2% пациентов.
У большинства пожилых пациентов выявлялись ПИКН с преобладанием смешанного варианта.
В группе пациентов молодого и среднего возраста превалировали изолированное снижение скорости или регуляции познавательной деятельности, у каждого 4-го больного выявлены смешанные когнитивные нарушения.
Показана тенденция к увеличению возраста пациентов при ПИКН смешанного характера.
При анализе эффективности препарата целлекс в остром периоде ИИ было установлено, что его прием связан с улучшением когнитивного статуса, а также состоянием нейродинамических, регуляторных и зрительно-пространственных функций.
Показано, что нейротрофический препарат целлекс является эффективным при коррекции ПИКН в остром периоде ИИ.
Цель исследования - оценка непосредственных и отдаленных результатов лечения адренокортикального рака с инвазией в магистральные венозные сосуды.
Материал и методы.
Проанализированы результаты обследования и лечения 3 пациентов с адренокортикальным раком, прорастающим в почечные вены и нижнюю полую вену.
Результаты.
Во всех наблюдениях удалось успешно выполнить радикальную операцию с удалением опухолевых тромбов из магистральных сосудов.
Осложнений и летальных исходов в раннем послеоперационном периоде не было.
Продолжительность жизни после операции составила 6, 13 и более 58 мес.
Заключение.
В настоящее время хирургическое вмешательство при адренокортикальном раке с инвазией в магистральные венозные сосуды - единственный метод лечения, позволяющий продлить жизнь пациентов.
Суммированы данные литературы и собственных исследований по методологии экспериментального инсульта.
Детально рассмотрены достоинства и недостатки большинства моделей фокальной ишемии, активно используемых в лабораторной практике.
Обоснованы преимущества модели филаментной окклюзии средней мозговой артерии у крыс как наиболее адекватной патогенезу инсульта у человека.
Предложена модификация этого варианта в виде дополнительной коагуляции крылонебной артерии, позволяющей исключить ретроградный и коллатеральный кровоток во внутренней сонной артерии после перевязки общей и наружной сонных артерий.
Цель исследования.
Связанные со стрессом диссоциативные расстройства (ДР) отличаются высокой распространенностью в психиатрии и общей медицине, однако психопатологическая дифференциация ДР и вклад расстройств личности в их формирование остаются малоизученными.
Цель исследования - клинический анализ провоцированных стрессом стойких диссоциативных расстройств, а также конституциональных аномалий, составляющих 'почву' для их формирования.
Материал и методы.
Обследовали 20 пациентов с обусловленными стрессом онкологического заболевания (нозогенные) диссоциативными расстройствами, по 10 в группах детачмент-диссоциации (ДД) (отрицание болезни и/или связанной с ней угрозы жизни, некомплаентность) и компартмент-диссоциации (полное/частичное отчуждение компонентов реакции на стресс - эмоциональные, когнитивные, адекватная комплаентность).  Группы сопоставимы по демографическим и онкологическим показателям.
Использовали клинический и психологический методы.
Результаты и заключение.
Диссоциативные расстройства представляют собой вторичные психопатологические феномены.
ДД формируется в рамках шизофренических нозогенных реакций на основе сверхценных идей соматического благополучия (либо полная излечимость злокачественного новообразования) и обнаруживает сродство с шизотипическим расстройством личности.
Компартмент-диссоциация манифестирует в пределах невротических нозогенных реакций на базе психогенных комплексов бинарной структуры - патология воображения (синдром 'прекрасного равнодушия') в сочетании с тревогой о реально существующем заболевании и обнаруживает сродство с расстройствами личности истерического круга.
Использование эндоскопической техники во многом улучшает результаты лечения больных с многоуровневой гидроцефалией, однако зачастую возникают сложности в планировании и интраоперационной идентификации измененных структур в условиях нарушенной анатомии и отсутствия привычных ориентиров.
Применение безрамной навигации при эндоскопических вмешательствах позволяет существенно облегчить задачи хирурга и повысить эффективность операции.
Во время операции в нейронавигационной системе выполняется регистрация ригидного эндоскопа, которым осуществляется соединение между собой разобщенных желудочков и кист.
Операция может быть завершена проведением стента через рабочий канал эндоскопа с имплантацией шунтирующей системы.
Материал и методы.
В нашей клинике за 2013-2014 гг. у 10 детей выполнено 11 эндоскопических вмешательств с использованием интраоперационной безрамной навигации.
Количество компартментов, соединенных между собой в результате операции, составило от 3 до 5.
В 8 из 11 вмешательств одномоментно выполнена установка шунтирующей системы.
Результаты.
У всех детей вследствие проведенной операции достигнуто клиническое улучшение.
Повторные операции потребовались двум пациентам: через 5 мес и через 1 год после эндоскопического вмешательства.
Заключение.
