# Set working directory to the data folder.
setwd("MODIFY THIS")

library(tidyverse)
library(ggpubr)
library(rstatix)

mydata = read.csv("prepared_data.csv")
mydata$id <- seq.int(nrow(mydata))

transformed = mydata %>% 
  gather(key="error", value="score", 
         male2female,female2male) %>%
  convert_as_factor(id, score)

transformed$score = as.numeric(transformed$score)

res.aov <- anova_test(data = transformed, dv = score, wid = id, within = error)
get_anova_table(res.aov)

pwc <- transformed %>%
  pairwise_t_test(
    score ~ error, paired = TRUE
  )
