from typing import Iterable, Tuple

from dataclasses import dataclass

from coli.basic_tools.dataclass_argparse import OptionsBase
from coli.hrgguru.hrg import CFGRule


class CountBasedHRGScorer(object):
    @dataclass
    class Options(OptionsBase):
        pass

    def __init__(self, *args, **kwargs):
        pass

    @classmethod
    def add_parser_arguments(cls, arg_parser):
        pass

    def get_best_rule(self,
                      span_feature,
                      rules_and_counts,  # type: Iterable[Tuple[CFGRule, int]]
                      gold=None
                      ):
        yield []
        best_rule = sorted(((count, rule) for rule, count in rules_and_counts),
                           key=lambda x: x[0],
                           reverse=True)[0][1]
        yield best_rule, None, best_rule

    def restore_components(self, restored_params):
        pass

    def cuda(self):
        pass

    def parameters(self):
        return []

    def eval(self):
        pass

    def calculate_results(self):
        pass

    def refresh(self):
        pass
