# -*- coding: utf-8 -*-


class UnionNode:
    __slots__ = ('value', '_parent', '_rank')

    def __init__(self, value):
        self.value = value
        self._parent = self
        self._rank = 1

    def find(x):
        parent = x._parent
        if parent != x:
            parent = x._parent = parent.find()
        return parent

    def union(x, y):
        rx = x.find()
        ry = y.find()
        if rx is ry:  # x and y are already in the same set
            return
        # x and y are not in same set, so we merge them
        if rx._rank < ry._rank:
            rx, ry = ry, rx

        ry._parent = rx
        if rx._rank == ry._rank:
            rx._rank += 1
