# -*- coding: utf-8 -*-


class Hypothesis:
    def __init__(self, word_ids, log_probs, decoder_state):
        self.word_ids = word_ids
        self.log_probs = log_probs
        self.decoder_state = decoder_state
        self._average_log_prob = sum(log_probs) / len(word_ids)

    def __lt__(self, v):
        return self._average_log_prob < v._average_log_prob

    @property
    def average_log_prob(self):
        return self._average_log_prob

    @property
    def latest_word_id(self):
        return self.word_ids[-1]

    def extend(self, word_id, log_prob, decoder_state):
        return Hypothesis(self.word_ids + [word_id],
                          self.log_probs + [log_prob],
                          decoder_state)
