/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.tag;

import com.aliasi.corpus.ObjectHandler;
import com.aliasi.corpus.StringParser;
import com.aliasi.tag.Tagging;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineTaggingParser
extends StringParser<ObjectHandler<Tagging<String>>> {
    private final Pattern mTokenTagPattern;
    private final Pattern mIgnoreLinePattern;
    private final Pattern mEosPattern;
    private final int mTokenGroup;
    private final int mTagGroup;

    public LineTaggingParser(String matchRegex, int tokenGroup, int tagGroup, String ignoreRegex, String eosRegex) {
        super(null);
        this.mTokenTagPattern = Pattern.compile(matchRegex);
        this.mTokenGroup = tokenGroup;
        this.mTagGroup = tagGroup;
        this.mIgnoreLinePattern = Pattern.compile(ignoreRegex);
        this.mEosPattern = Pattern.compile(eosRegex);
    }

    @Override
    public void parseString(char[] cs, int start, int end) {
        String in = new String(cs, start, end - start);
        String[] lines = in.split("\n");
        ArrayList<String> tokenList = new ArrayList<String>();
        ArrayList<String> tagList = new ArrayList<String>();
        for (int i = 0; i < lines.length; ++i) {
            Matcher lineIgnorer = this.mIgnoreLinePattern.matcher(lines[i]);
            if (lineIgnorer.matches()) continue;
            Matcher eosMatcher = this.mEosPattern.matcher(lines[i]);
            if (eosMatcher.matches()) {
                this.handle(tokenList, tagList);
                continue;
            }
            Matcher matcher = this.mTokenTagPattern.matcher(lines[i]);
            if (!matcher.matches()) {
                String msg = "Illegal line=" + lines[i];
                throw new IllegalArgumentException(msg);
            }
            String token = matcher.group(this.mTokenGroup);
            String tag = matcher.group(this.mTagGroup);
            tokenList.add(token);
            tagList.add(tag);
        }
        this.handle(tokenList, tagList);
    }

    void handle(List<String> tokenList, List<String> tagList) {
        Tagging<String> tagging = new Tagging<String>(tokenList, tagList);
        ((ObjectHandler)this.getHandler()).handle(tagging);
        tokenList.clear();
        tagList.clear();
    }
}

