/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.classify;

import com.aliasi.classify.RankedClassification;
import com.aliasi.util.ScoredObject;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScoredClassification
extends RankedClassification {
    private final double[] mScores;

    public ScoredClassification(String[] categories, double[] scores) {
        super(categories);
        if (categories.length != scores.length) {
            String msg = "Categories and scores must be of same length. Categories length=" + categories.length + " Scores length=" + scores.length;
            throw new IllegalArgumentException(msg);
        }
        for (int i = 1; i < scores.length; ++i) {
            if (!(scores[i - 1] < scores[i])) continue;
            String msg = "Array of scores must be in order. scores[" + (i - 1) + "]=" + scores[i - 1] + " < scores[" + i + "]=" + scores[i];
            throw new IllegalArgumentException(msg);
        }
        this.mScores = scores;
    }

    public static ScoredClassification create(ScoredObject<String>[] categoryScores) {
        Arrays.sort(categoryScores, ScoredObject.reverseComparator());
        String[] categories = new String[categoryScores.length];
        double[] scores = new double[categoryScores.length];
        for (int i = 0; i < categoryScores.length; ++i) {
            categories[i] = categoryScores[i].getObject();
            scores[i] = categoryScores[i].score();
        }
        return new ScoredClassification(categories, scores);
    }

    public double score(int rank) {
        this.checkRange(rank);
        return this.mScores[rank];
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Rank  Category  Score\n");
        for (int i = 0; i < this.size(); ++i) {
            sb.append(i + "=" + this.category(i) + " " + this.score(i) + '\n');
        }
        return sb.toString();
    }
}

