
/*MA****************************************************************/
/*                                                                 */
/*     File: symbol-set.h                                          */
/*   Author: Helmut Schmid                                         */
/*  Purpose:                                                       */
/*  Created: Thu Jan  2 14:55:10 2003                              */
/* Modified: Thu Jan 15 09:33:19 2009 (schmid)                     */
/*                                                                 */
/*ME****************************************************************/

#include <string.h>

#include <ext/hash_set>
using __gnu_cxx::hash_set;
using __gnu_cxx::hash;


/*****************  class StringSet  *****************************/

class StringSet {

  // problem: allocated memory is not freed by the destructor

private:

  struct eqstr {
    bool operator()(const char* s1, const char* s2) const {
      return strcmp(s1, s2) == 0;
    }
  };

  typedef hash_set<const char*, hash<const char*>, eqstr> SM;

  SM sm;

public:

  typedef SM::iterator iterator;

  iterator find( char *s ) { return sm.find(s); }
  iterator begin() { return sm.begin(); }
  iterator end()   { return sm.end(); }
  size_t   size()  { return sm.size(); }

  const char *operator()( const char *s ) {
    iterator it=sm.find(s);
    if (it != sm.end())
      return *it;
    s = strdup(s);
    sm.insert(s);
    return s;
  }

  const char *lookup( const char *s ) {
    iterator it=sm.find(s);
    if (it == sm.end())
      return NULL;
    return *it;
  }
};
