/*
 * Decompiled with CFR 0.152.
 */
package wordModel;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;

public class AffixSuffixManual {
    public static String[] affixes5 = new String[]{"inter", "trans", "under"};
    public static String[] affixes4 = new String[]{"over"};
    public static String[] affixes3 = new String[]{"com", "con", "dis", "pre", "pro"};
    public static String[] affixes2 = new String[]{"co", "de", "in", "re", "un"};
    public static String[] suffixes5 = new String[]{"ments"};
    public static String[] suffixes4 = new String[]{"ance", "dent", "ence", "ists", "line", "ment", "ship", "time"};
    public static String[] suffixes3 = new String[]{"ans", "ant", "are", "ate", "ble", "cal", "ess", "est", "ful", "ian", "ics", "ing", "ion", "ist", "ive", "man", "ons", "ory", "ous", "son", "tor", "ure"};
    public static String[] suffixes2 = new String[]{"al", "ce", "ck", "cy", "de", "ds", "ed", "er", "es", "et", "ey", "gs", "gy", "ic", "is", "ks", "ld", "le", "ls", "ly", "ne", "rd", "rs", "se", "sh", "sm", "th", "ts", "ty", "ze"};
    public static String[][][] affixesSuffixes = new String[][][]{{affixes5, affixes4, affixes3, affixes2}, {suffixes5, suffixes4, suffixes3, suffixes2}};
    public static final String noFixTag = "NOFIX";
    public static int[][] defaultPriority;

    static {
        int[][] nArrayArray = new int[8][];
        int[] nArray = new int[2];
        nArray[0] = 1;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[2];
        nArrayArray[2] = new int[]{1, 1};
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        nArrayArray[3] = nArray2;
        nArrayArray[4] = new int[]{1, 2};
        nArrayArray[5] = new int[]{1, 3};
        int[] nArray3 = new int[2];
        nArray3[1] = 3;
        nArrayArray[6] = nArray3;
        int[] nArray4 = new int[2];
        nArray4[1] = 3;
        nArrayArray[7] = nArray4;
        defaultPriority = nArrayArray;
    }

    public static void checkOrder() {
        String[][][] stringArray = affixesSuffixes;
        int n = affixesSuffixes.length;
        int n2 = 0;
        while (n2 < n) {
            String[][] block;
            String[][] stringArray2 = block = stringArray[n2];
            int n3 = block.length;
            int n4 = 0;
            while (n4 < n3) {
                Object[] list = stringArray2[n4];
                Object[] copy = Arrays.copyOf(list, list.length);
                Arrays.sort(copy);
                if (!Arrays.equals(list, copy)) {
                    System.err.println("NON SORTED: " + Arrays.toString(list));
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static String tagWord(String word) {
        int[][] nArray = defaultPriority;
        int n = defaultPriority.length;
        int n2 = 0;
        while (n2 < n) {
            int fix_length;
            int[] level = nArray[n2];
            Object[] searchArray = affixesSuffixes[level[0]][level[1]];
            boolean affix = level[0] == 0;
            int word_length = word.length();
            if (word_length > (fix_length = searchArray[0].length())) {
                String fix;
                String string = fix = affix ? word.substring(0, fix_length) : word.substring(word_length - fix_length);
                if (Arrays.binarySearch(searchArray, fix) >= 0) {
                    return String.valueOf(affix ? "A_" : "S_") + fix;
                }
            }
            ++n2;
        }
        return noFixTag;
    }

    public static void main(String[] args) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        String str = "";
        while (str != null) {
            System.out.print("<prompt> ");
            str = in.readLine();
            System.out.println(String.valueOf(str) + ": " + AffixSuffixManual.tagWord(str));
        }
    }
}

