/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.FileNotFoundException;
import java.util.Arrays;

public class BruijnSequence {
    public static int[][] combinations(int[] list) {
        int combinations = BruijnSequence.product(list);
        int[][] result = new int[combinations][list.length];
        if (list.length == 1) {
            int row = 0;
            int i = 0;
            while (i < list[0]) {
                result[row][0] = i++;
                ++row;
            }
            return result;
        }
        if (list.length == 2) {
            int row = 0;
            int i = 0;
            while (i < list[0]) {
                int j = 0;
                while (j < list[1]) {
                    result[row][0] = i;
                    result[row][1] = j++;
                    ++row;
                }
                ++i;
            }
            return result;
        }
        int[] newList = new int[list.length - 1];
        int i = 0;
        while (i < list.length - 1) {
            newList[i] = list[i];
            ++i;
        }
        int[][] partialResult = BruijnSequence.combinations(newList);
        int row = 0;
        int i2 = 0;
        while (i2 < partialResult.length) {
            int k = 0;
            while (k < list[list.length - 1]) {
                int j = 0;
                while (j < list.length - 1) {
                    result[row][j] = partialResult[i2][j];
                    ++j;
                }
                result[row][list.length - 1] = k++;
                ++row;
            }
            ++i2;
        }
        return result;
    }

    public static int product(int[] array) {
        int result = array[0];
        int i = 1;
        while (i < array.length) {
            result *= array[i];
            ++i;
        }
        return result;
    }

    public static void bruinSequences(int k, int n) {
        int[] list = new int[n];
        Arrays.fill(list, k);
        int[][] sequences = BruijnSequence.combinations(list);
        int length = sequences.length;
        boolean[] taken = new boolean[length];
        int[] result = new int[length + n - 1];
        int[] seq = sequences[0];
        int i = 0;
        while (i < n) {
            result[i] = seq[i];
            ++i;
        }
        taken[0] = true;
        int resIndex = n;
        int[] lastDigits = Arrays.copyOfRange(seq, 1, n);
        while (resIndex < result.length) {
            boolean found = false;
            int i2 = length - 1;
            while (i2 >= 0) {
                int[] firstDigits;
                if (!taken[i2] && Arrays.equals(lastDigits, firstDigits = Arrays.copyOfRange(seq = sequences[i2], 0, n - 1))) {
                    taken[i2] = true;
                    found = true;
                    lastDigits = Arrays.copyOfRange(seq, 1, n);
                    result[resIndex++] = seq[n - 1];
                    break;
                }
                --i2;
            }
            if (found) continue;
            System.err.println("Sequence not found!");
            return;
        }
        System.out.println(Arrays.toString(result));
    }

    public static void main(String[] args) throws FileNotFoundException {
        int kmax = 6;
        int nmax = 6;
        int k = 2;
        while (k <= kmax) {
            int n = 2;
            while (n <= nmax) {
                System.out.println("k=" + k + " n=" + n);
                BruijnSequence.bruinSequences(k, n);
                System.out.println();
                ++n;
            }
            ++k;
        }
    }
}

