/*
 * Decompiled with CFR 0.152.
 */
package tsg.parsingExp;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.Vector;
import settings.Parameters;
import tsg.TSNodeLabel;
import tsg.TSNodeLabelIndex;
import tsg.TSNodeLabelStructure;
import util.ArgumentReader;
import util.FileUtil;
import util.PrintProgress;
import util.Utility;

public class RetrieveNonEmbeddingCounts
extends Thread {
    public static int numberOfTreesPerThreads = 10;
    static boolean debug = false;
    File fragmentsFile;
    File outputFile;
    int threads = 1;
    long fragmentReadCounter;
    long fragmentWrittenCounter;
    long currentIndex;
    PrintProgress progress;
    ArrayList<TSNodeLabelIndex> treebank;
    ArrayList<TSNodeLabel> fragmentList;
    Hashtable<TSNodeLabel, int[]> finalFragmentsCount;
    Iterator<TSNodeLabelIndex> treeIterator;

    public RetrieveNonEmbeddingCounts(ArrayList<TSNodeLabelIndex> treebank, File fragmentsFile, File outputFile, int threads) {
        this.treebank = treebank;
        this.fragmentsFile = fragmentsFile;
        this.outputFile = outputFile;
        this.threads = threads;
        this.treeIterator = treebank.iterator();
    }

    public RetrieveNonEmbeddingCounts(ArrayList<TSNodeLabelIndex> treebank, ArrayList<TSNodeLabel> fragments) {
        this.treebank = treebank;
        this.fragmentList = fragments;
        this.treeIterator = treebank.iterator();
    }

    @Override
    public void run() {
        try {
            this.getFragmentList();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.retriveShortDerCounts();
        this.writeFragmentsToFile();
    }

    private void getFragmentList() throws Exception {
        Parameters.reportLine("Extracting fragments from file: " + this.fragmentsFile);
        this.progress = new PrintProgress("Progress:", 10000, 0);
        Scanner fragmentsScanner = FileUtil.getScanner(this.fragmentsFile);
        this.fragmentList = new ArrayList();
        while (fragmentsScanner.hasNextLine()) {
            this.progress.next();
            String line = fragmentsScanner.nextLine();
            if (line.equals("")) continue;
            String[] lineSplit = line.split("\t");
            TSNodeLabel fragment = new TSNodeLabel(lineSplit[0], false);
            this.fragmentList.add(fragment);
        }
        this.progress.end();
        Parameters.reportLine("Extracted fragments: " + this.fragmentList.size());
    }

    public void retriveShortDerCounts() {
        this.finalFragmentsCount = new Hashtable();
        Parameters.reportLineFlush("Retrieving Shortest Derivation Counts");
        this.progress = new PrintProgress("Extracting from tree:", 100, 0);
        try {
            if (this.threads == 1) {
                this.updateTableWithFragmCounts(this.finalFragmentsCount, this.treebank);
            } else {
                this.startMultiThreads();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.progress.end();
    }

    /*
     * Could not resolve type clashes
     */
    private void updateTableWithFragmCounts(Hashtable<TSNodeLabel, int[]> tableToUpdate, ArrayList<TSNodeLabelIndex> trees) {
        int treeindex = 0;
        for (TSNodeLabelIndex tree : trees) {
            ++treeindex;
            TSNodeLabelStructure treeStructure = new TSNodeLabelStructure(tree);
            int length = treeStructure.length();
            Vector nodeStartingFragments = new Vector(length);
            int i = 0;
            while (i < length) {
                nodeStartingFragments.add(new ArrayList());
                ++i;
            }
            for (TSNodeLabel fragment : this.fragmentList) {
                ArrayList<Integer> rootsIndexes = this.getRootIndexes(treeStructure, fragment);
                for (int root : rootsIndexes) {
                    ArrayList rootFrag = (ArrayList)nodeStartingFragments.get(root);
                    boolean addNew = true;
                    ListIterator rootFragIter = rootFrag.listIterator();
                    while (rootFragIter.hasNext()) {
                        TSNodeLabel f = (TSNodeLabel)rootFragIter.next();
                        if (f.containsNonRecursiveFragment(fragment)) {
                            addNew = false;
                            break;
                        }
                        if (!fragment.containsNonRecursiveFragment(f)) continue;
                        rootFragIter.remove();
                    }
                    if (!addNew) continue;
                    rootFrag.add(fragment);
                }
            }
            for (ArrayList rootFrag : nodeStartingFragments) {
                for (TSNodeLabel frag : rootFrag) {
                    Utility.increaseInTableInt(tableToUpdate, frag);
                }
            }
        }
    }

    private ArrayList<Integer> getRootIndexes(TSNodeLabelStructure treeStructure, TSNodeLabel fragment) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        TSNodeLabelIndex[] tSNodeLabelIndexArray = treeStructure.structure;
        int n = treeStructure.structure.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabelIndex treeIndex = tSNodeLabelIndexArray[n2];
            if (treeIndex.containsNonRecursiveFragment(fragment)) {
                result.add(treeIndex.index);
            }
            ++n2;
        }
        return result;
    }

    private void startMultiThreads() throws Exception {
        CountFragmentsThread[] threadsArray = new CountFragmentsThread[this.threads];
        int lastThreadIndex = this.threads - 1;
        int t = 0;
        while (t < this.threads) {
            CountFragmentsThread newCounterThread;
            threadsArray[t] = newCounterThread = new CountFragmentsThread();
            if (t == lastThreadIndex) {
                newCounterThread.run();
            } else {
                newCounterThread.start();
            }
            ++t;
        }
        int i = 0;
        while (i < lastThreadIndex) {
            try {
                threadsArray[i].join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private void writeFragmentsToFile() {
        Parameters.reportLine("Printing fragments with new counts to file: " + this.outputFile);
        PrintWriter pw = FileUtil.getPrintWriter(this.outputFile);
        for (Map.Entry<TSNodeLabel, int[]> e : this.finalFragmentsCount.entrySet()) {
            TSNodeLabel fragment = e.getKey();
            int count = e.getValue()[0] + 1;
            pw.println(String.valueOf(fragment.toString(false, true)) + "\t" + count);
        }
        int added = 0;
        Set<TSNodeLabel> fragSet = this.finalFragmentsCount.keySet();
        for (TSNodeLabel f : this.fragmentList) {
            if (fragSet.contains(f)) continue;
            pw.println(String.valueOf(f.toString(false, true)) + "\t" + 1);
            ++added;
        }
        pw.close();
        System.out.println("Count zero fragmnet (set to 1): " + added);
    }

    private synchronized ArrayList<TSNodeLabelIndex> getNextTreeLoad() {
        if (!this.treeIterator.hasNext()) {
            return null;
        }
        ArrayList<TSNodeLabelIndex> treesForThread = new ArrayList<TSNodeLabelIndex>(numberOfTreesPerThreads);
        int i = 0;
        while (this.treeIterator.hasNext()) {
            if (i == numberOfTreesPerThreads) break;
            treesForThread.add(this.treeIterator.next());
            ++i;
        }
        this.progress.next(i);
        return treesForThread;
    }

    private synchronized void addFragmentsToFinalTable(Hashtable<TSNodeLabel, int[]> threadFragmentCount) {
        for (Map.Entry<TSNodeLabel, int[]> e : threadFragmentCount.entrySet()) {
            TSNodeLabel fragment = e.getKey();
            Utility.increaseInTableInt(this.finalFragmentsCount, fragment, e.getValue()[0]);
        }
    }

    public static void main2(String[] args) throws Exception {
        debug = true;
        TSNodeLabelIndex tree = new TSNodeLabelIndex("(A ( B (D h i) (E l m)) (C (F n o) (G p q)))");
        ArrayList<TSNodeLabelIndex> treebank = new ArrayList<TSNodeLabelIndex>();
        treebank.add(tree);
        ArrayList<TSNodeLabel> fragmentsList = new ArrayList<TSNodeLabel>(Arrays.asList(new TSNodeLabel("(A B C)", false), new TSNodeLabel("(B D E)", false), new TSNodeLabel("(C F G)", false), new TSNodeLabel("(D \"h\" \"i\")", false), new TSNodeLabel("(E \"l\" \"m\")", false), new TSNodeLabel("(F \"n\" \"o\")", false), new TSNodeLabel("(G \"p\" \"q\")", false), new TSNodeLabel("(A B (C F G))", false), new TSNodeLabel("(B (D \"h\" \"i\") (E \"l\" \"m\"))", false)));
        RetrieveNonEmbeddingCounts RCF = new RetrieveNonEmbeddingCounts(treebank, fragmentsList);
        RCF.retriveShortDerCounts();
    }

    public static void main1(String[] args) throws Exception {
        RetrieveNonEmbeddingCounts.main1(new String[]{"tmp/Bonnema/trainingTreebank_UK_first100.mrg", "tmp/Bonnema/fragmentsAndCfgRules.txt", "tmp/Bonnema/fragmentsAndCfgRules_bonnema.txt"});
    }

    public static void main(String[] args) throws Exception {
        long time = System.currentTimeMillis();
        String usage = "USAGE: java RetrieveGoodamnCounts [-threads:1] treebankFile fragmentsFile outputFile";
        String threadsOption = "-threads:";
        int threads = 1;
        int length = args.length;
        if (length < 3 || length > 4) {
            System.err.println("Incorrect number of arguments");
            System.err.println(usage);
            return;
        }
        File treebankFile = null;
        File inputFile = null;
        File outputFile = null;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            if (option.startsWith(threadsOption)) {
                threads = ArgumentReader.readIntOption(option);
            } else if (treebankFile == null) {
                treebankFile = new File(option);
            } else if (inputFile == null) {
                inputFile = new File(option);
            } else {
                outputFile = new File(option);
            }
            ++n2;
        }
        if (!treebankFile.exists()) {
            System.err.println("Treebank File does not exist");
            System.err.println(usage);
            return;
        }
        if (!inputFile.exists()) {
            System.err.println("Input File does not exist");
            System.err.println(usage);
            return;
        }
        ArrayList<TSNodeLabel> treebank = TSNodeLabel.getTreebank(treebankFile);
        ArrayList<TSNodeLabelIndex> treebankIndex = new ArrayList<TSNodeLabelIndex>();
        for (TSNodeLabel t : treebank) {
            treebankIndex.add(new TSNodeLabelIndex(t));
        }
        RetrieveNonEmbeddingCounts RCF = new RetrieveNonEmbeddingCounts(treebankIndex, inputFile, outputFile, threads);
        RCF.run();
        System.out.println("Took: " + (System.currentTimeMillis() - time) / 1000L + "seconds.");
    }

    private class CountFragmentsThread
    extends Thread {
        private CountFragmentsThread() {
        }

        @Override
        public void run() {
            ArrayList treeLoad = null;
            while ((treeLoad = RetrieveNonEmbeddingCounts.this.getNextTreeLoad()) != null) {
                Hashtable threadFragmentCount = new Hashtable();
                RetrieveNonEmbeddingCounts.this.updateTableWithFragmCounts(threadFragmentCount, treeLoad);
                RetrieveNonEmbeddingCounts.this.addFragmentsToFinalTable(threadFragmentCount);
            }
        }
    }
}

