/*
 * Decompiled with CFR 0.152.
 */
package tsg.metrics;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import tsg.ConstituencyWords;
import tsg.Label;
import tsg.TSNodeLabel;
import tsg.metrics.ParseMetricOptimizer;
import util.Duet;
import util.Utility;

public class MRuleProduct
extends ParseMetricOptimizer {
    static Label noConstLabel = Label.getLabel("");
    static String dotBinarizationMarker = "<dot>";
    Hashtable<CfgFrame, double[]>[][] constsProbTable;
    double sentenceProb;
    ViterbiCell[][] cells;
    static double minusInf = -1.7976931348623157E308;

    public MRuleProduct() {
        this.identifier = "MRuleProduct";
    }

    @Override
    protected void initSentence() {
        this.sentenceProb = 0.0;
        this.constsProbTable = new Hashtable[this.sentenceLength][this.sentenceLength];
        this.cells = new ViterbiCell[this.sentenceLength][this.sentenceLength];
        int i = 0;
        while (i < this.sentenceLength) {
            int j = i;
            while (j < this.sentenceLength) {
                this.constsProbTable[i][j] = new Hashtable();
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void addNewDerivationChecked(TSNodeLabel tree, double prob) {
        this.sentenceProb += prob;
        tree.binarizeEarly(dotBinarizationMarker);
        ArrayList<ConstituencyWords> consts = ConstituencyWords.collectConsituencies(tree, true, new String[0], true);
        for (ConstituencyWords c : consts) {
            TSNodeLabel node = c.getNode();
            Label label = node.label;
            Label leftDaughterLabel = null;
            Label rightDaughterLabel = null;
            if (!node.isPreLexical()) {
                leftDaughterLabel = node.daughters[0].label;
                if (node.prole() > 1) {
                    rightDaughterLabel = node.daughters[1].label;
                }
            }
            CfgFrame mce = new CfgFrame(label, leftDaughterLabel, rightDaughterLabel);
            double ruleProb = label.toString().contains(dotBinarizationMarker) ? 0.0 : prob;
            int startIndex = c.getInitialIndex();
            int endIndex = c.getFinalIndex();
            Hashtable<CfgFrame, double[]> cellTable = this.constsProbTable[startIndex][endIndex];
            Utility.increaseInTableDoubleArray(cellTable, mce, ruleProb);
        }
    }

    @Override
    public TSNodeLabel getBestTree() {
        this.convertCellTableToLog();
        int span = 0;
        while (span < this.sentenceLength) {
            int s = 0;
            while (s < this.sentenceLength - span) {
                boolean updated;
                int e = s + span;
                ViterbiCell currentViterbiCell = new ViterbiCell(s, e);
                Hashtable<CfgFrame, double[]> cellTable = this.constsProbTable[s][e];
                if (span > 0) {
                    for (Map.Entry<CfgFrame, double[]> frameProb : cellTable.entrySet()) {
                        CfgFrame gFrame = frameProb.getKey();
                        if (gFrame.rightNodeLabel == null) continue;
                        double gScore = frameProb.getValue()[0];
                        double maxCombScore = minusInf;
                        ViterbiCell.FrameProbSplit leftSplit = null;
                        ViterbiCell.FrameProbSplit rightSplit = null;
                        int split = s;
                        while (split < e) {
                            double sumScore;
                            ViterbiCell.FrameProbSplit fpsR;
                            ViterbiCell cellR;
                            ViterbiCell.FrameProbSplit fpsL;
                            ViterbiCell cellL = this.cells[s][split];
                            if (cellL != null && (fpsL = cellL.getMaxFrameProbSplit(gFrame.leftNodeLabel)) != null && (cellR = this.cells[split + 1][e]) != null && (fpsR = cellR.getMaxFrameProbSplit(gFrame.rightNodeLabel)) != null && (sumScore = fpsL.prob + fpsR.prob) > maxCombScore) {
                                maxCombScore = sumScore;
                                leftSplit = fpsL;
                                rightSplit = fpsR;
                            }
                            ++split;
                        }
                        currentViterbiCell.addFrameProbSplit(gFrame, maxCombScore += gScore, leftSplit, rightSplit);
                    }
                }
                ArrayList<Duet<CfgFrame, Double>> unaryRulesProb = this.getUnaryRulesProb(cellTable);
                do {
                    updated = false;
                    for (Duet<CfgFrame, Double> frameProb : unaryRulesProb) {
                        CfgFrame gFrame = frameProb.getFirst();
                        double inScore = frameProb.getSecond();
                        ViterbiCell.FrameProbSplit fpsL = null;
                        if (gFrame.leftNodeLabel != null) {
                            fpsL = currentViterbiCell.getMaxFrameProbSplit(gFrame.leftNodeLabel);
                            inScore = fpsL == null ? minusInf : (inScore += fpsL.prob);
                        }
                        if (!currentViterbiCell.updateFrameProbSplit(gFrame, inScore, fpsL, null)) continue;
                        updated = true;
                    }
                } while (updated);
                this.cells[s][e] = currentViterbiCell;
                ++s;
            }
            ++span;
        }
        ViterbiCell topCell = this.cells[0][this.sentenceLength - 1];
        ViterbiCell.FrameProbSplit topSplit = topCell.getMaxFrameProbSplit(topLabel);
        TSNodeLabel result = this.getTree(topSplit);
        result.unbinarizeEarly(dotBinarizationMarker);
        ArrayList<TSNodeLabel> terms = result.collectTerminalItems();
        int i = 0;
        for (TSNodeLabel t : terms) {
            TSNodeLabel lexNode = new TSNodeLabel(this.lexicalItems[i], true);
            t.daughters = new TSNodeLabel[]{lexNode};
            lexNode.parent = t;
            ++i;
        }
        return result;
    }

    private ArrayList<Duet<CfgFrame, Double>> getUnaryRulesProb(Hashtable<CfgFrame, double[]> cellTable) {
        ArrayList<Duet<CfgFrame, Double>> result = new ArrayList<Duet<CfgFrame, Double>>();
        for (Map.Entry<CfgFrame, double[]> frameProb : cellTable.entrySet()) {
            CfgFrame gFrame = frameProb.getKey();
            if (gFrame.rightNodeLabel != null) continue;
            Double gScore = frameProb.getValue()[0];
            result.add(new Duet<CfgFrame, Double>(gFrame, gScore));
        }
        return result;
    }

    private void convertCellTableToLog() {
        int i = 0;
        while (i < this.sentenceLength) {
            int j = i;
            while (j < this.sentenceLength) {
                for (Map.Entry<CfgFrame, double[]> e : this.constsProbTable[i][j].entrySet()) {
                    double[] val = e.getValue();
                    double logProb = val[0];
                    double d = val[0] = logProb == 0.0 ? 0.0 : Math.log(logProb);
                }
                ++j;
            }
            ++i;
        }
    }

    public void printBestCellLabels() {
        int i = 0;
        while (i < this.sentenceLength) {
            int j = 0;
            while (j < this.sentenceLength) {
                if (j < i) {
                    System.out.print("\t");
                } else {
                    System.out.print(String.valueOf(this.cells[i][j] == null ? "null" : this.cells[i][j].toString()) + "\t");
                }
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    private TSNodeLabel getTree(ViterbiCell.FrameProbSplit topSplit) {
        Label parentLabel = topSplit.frame.parentNodeLabel;
        TSNodeLabel result = new TSNodeLabel(parentLabel, false);
        if (topSplit.cellsSplit[0] == null) {
            return result;
        }
        int prole = topSplit.cellsSplit[1] == null ? 1 : 2;
        TSNodeLabel[] daughtersArray = new TSNodeLabel[prole];
        result.daughters = daughtersArray;
        int i = 0;
        ViterbiCell.FrameProbSplit[] frameProbSplitArray = topSplit.cellsSplit;
        int n = topSplit.cellsSplit.length;
        int n2 = 0;
        while (n2 < n) {
            ViterbiCell.FrameProbSplit c = frameProbSplitArray[n2];
            if (c != null) {
                TSNodeLabel d = this.getTree(c);
                d.parent = result;
                daughtersArray[i] = d;
                ++i;
            }
            ++n2;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        TSNodeLabel parse1 = new TSNodeLabel("(S (NP (DT The) (NN cat)) (VP (VBP saw) (NP (DT the) (JJ yellow) (NN dog))))");
        System.out.println(parse1);
        System.out.println(parse1.toStringQtree());
        String[] words = parse1.collectTerminalStrings().toArray(new String[0]);
        MRuleProduct mrp = new MRuleProduct();
        mrp.prepareNextSentence(words);
        mrp.addNewDerivation(parse1, 0.00154321);
        TSNodeLabel bestTree = mrp.getBestTree();
        System.out.println(bestTree);
        System.out.println(bestTree.toStringQtree());
    }

    public static class CfgFrame {
        Label parentNodeLabel;
        Label leftNodeLabel;
        Label rightNodeLabel;
        int hashCode;

        public CfgFrame(Label p, Label l, Label r) {
            this.parentNodeLabel = p;
            this.leftNodeLabel = l;
            this.rightNodeLabel = r;
        }

        public int hashCode() {
            return new String(this.parentNodeLabel + " " + this.leftNodeLabel + " " + this.rightNodeLabel).hashCode();
        }

        public String toString() {
            return "[" + this.parentNodeLabel + " " + this.leftNodeLabel + " " + this.rightNodeLabel + "]";
        }

        public boolean equals(Object o) {
            if (o instanceof CfgFrame) {
                CfgFrame otherElement = (CfgFrame)o;
                return otherElement.parentNodeLabel == this.parentNodeLabel && otherElement.leftNodeLabel == this.leftNodeLabel && otherElement.rightNodeLabel == this.rightNodeLabel;
            }
            return false;
        }
    }

    public class ViterbiCell {
        protected ArrayList<FrameProbSplit> frameProbSplitArray;
        public int startIndex;
        public int endIndex;

        public ViterbiCell(int s, int e) {
            this.startIndex = s;
            this.endIndex = e;
            this.frameProbSplitArray = new ArrayList();
        }

        public FrameProbSplit getMaxFrameProbSplit() {
            if (this.frameProbSplitArray.isEmpty()) {
                return null;
            }
            double maxProb = minusInf;
            FrameProbSplit result = null;
            for (FrameProbSplit fps : this.frameProbSplitArray) {
                double prob = fps.prob;
                if (!(prob > maxProb)) continue;
                maxProb = prob;
                result = fps;
            }
            return result;
        }

        public FrameProbSplit getMaxFrameProbSplit(Label parentLabel) {
            if (this.frameProbSplitArray.isEmpty()) {
                return null;
            }
            double maxProb = minusInf;
            FrameProbSplit result = null;
            for (FrameProbSplit fps : this.frameProbSplitArray) {
                double prob;
                if (fps.frame.parentNodeLabel != parentLabel || !((prob = fps.prob) > maxProb)) continue;
                maxProb = prob;
                result = fps;
            }
            return result;
        }

        public void addFrameProbSplit(CfgFrame f, double s, FrameProbSplit ls, FrameProbSplit rs) {
            FrameProbSplit fps = new FrameProbSplit(f, s, new FrameProbSplit[]{ls, rs});
            this.frameProbSplitArray.add(fps);
        }

        public boolean updateFrameProbSplit(CfgFrame f, double s, FrameProbSplit ls, FrameProbSplit rs) {
            boolean found = false;
            for (FrameProbSplit fps : this.frameProbSplitArray) {
                if (!fps.frame.equals(f)) continue;
                found = true;
                if (fps.prob >= s) {
                    return false;
                }
                fps.prob = s;
                fps.cellsSplit[0] = ls;
                fps.cellsSplit[1] = rs;
                return true;
            }
            if (!found) {
                this.addFrameProbSplit(f, s, ls, rs);
            }
            return true;
        }

        public String toString() {
            return "(" + this.startIndex + "," + this.endIndex + "," + this.frameProbSplitArray + ")";
        }

        public class FrameProbSplit {
            CfgFrame frame;
            double prob;
            FrameProbSplit[] cellsSplit;

            public FrameProbSplit(CfgFrame frame, double prob, FrameProbSplit[] cellsSplit) {
                this.frame = frame;
                this.prob = prob;
                this.cellsSplit = cellsSplit;
            }

            public int startIndex() {
                return ViterbiCell.this.startIndex;
            }

            public int endIndex() {
                return ViterbiCell.this.endIndex;
            }

            public String toString() {
                FrameProbSplit ls = this.cellsSplit[0];
                String leftId = ls == null ? "null" : "(" + ls.startIndex() + ls.endIndex() + ")";
                FrameProbSplit rs = this.cellsSplit[1];
                String rightId = rs == null ? "null" : "(" + rs.startIndex() + rs.endIndex() + ")";
                return "{" + this.frame + "," + this.prob + "," + leftId + "," + rightId + "}";
            }
        }
    }
}

