/*
 * Decompiled with CFR 0.152.
 */
package tsg.kernels;

import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Random;
import kernels.NodeSetCollector;
import kernels.NodeSetCollectorMUB;
import kernels.NodeSetCollectorSimple;
import kernels.NodeSetCollectorUnion;
import tsg.TSNodeLabel;
import tsg.TSNodeLabelIndex;
import tsg.TSNodeLabelStructure;
import tsg.kernels.CommonStructures;

public abstract class CommonSubtrees
extends CommonStructures {
    public CommonSubtrees(ArrayList<TSNodeLabelStructure> treebank, int threads, int startIndex) {
        super(treebank, threads, startIndex);
    }

    protected static NodeSetCollectorUnion[][] getCST(TSNodeLabelStructure t1, TSNodeLabelStructure t2) {
        NodeSetCollectorUnion[][] CST = new NodeSetCollectorUnion[t1.length()][t2.length()];
        int currentLength = t1.length();
        TSNodeLabelIndex[] tSNodeLabelIndexArray = t1.structure();
        int n = tSNodeLabelIndexArray.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabelIndex nodeA = tSNodeLabelIndexArray[n2];
            TSNodeLabelIndex[] tSNodeLabelIndexArray2 = t2.structure();
            int n3 = tSNodeLabelIndexArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TSNodeLabelIndex nodeB = tSNodeLabelIndexArray2[n4];
                CommonSubtrees.getCST(nodeA, nodeB, CST, currentLength);
                ++n4;
            }
            ++n2;
        }
        return CST;
    }

    private static NodeSetCollectorUnion getCST(TSNodeLabelIndex nodeA, TSNodeLabelIndex nodeB, NodeSetCollectorUnion[][] CST, int currentLength) {
        NodeSetCollectorUnion stored = CST[nodeA.index][nodeB.index];
        if (stored != null) {
            return stored;
        }
        NodeSetCollectorUnion nodeCollector = new NodeSetCollectorUnion();
        nodeCollector.setMaxLength(currentLength);
        if (nodeA.sameLabel(nodeB)) {
            nodeCollector.addDefaultBitSet(nodeA.index);
            if (!nodeA.isLexical && nodeA.sameDaughtersLabel(nodeB)) {
                TSNodeLabel[] daughtersA = nodeA.daughters;
                TSNodeLabel[] daughtersB = nodeB.daughters;
                int prole = nodeA.daughters.length;
                NodeSetCollector[] nodeCollDaughters = new NodeSetCollectorUnion[prole];
                int[] nodeSetDaughtersLength = new int[prole];
                int i = 0;
                while (i < prole) {
                    TSNodeLabelIndex nodeADaughter = (TSNodeLabelIndex)daughtersA[i];
                    TSNodeLabelIndex nodeBDaughter = (TSNodeLabelIndex)daughtersB[i];
                    NodeSetCollectorUnion collD = CommonSubtrees.getCST(nodeADaughter, nodeBDaughter, CST, currentLength);
                    nodeCollDaughters[i] = collD;
                    nodeSetDaughtersLength[i] = collD.size();
                    ++i;
                }
                nodeCollector.addAllCombinations(nodeCollDaughters, nodeSetDaughtersLength, nodeA.index);
                NodeSetCollector[] nodeSetCollectorArray = nodeCollDaughters;
                int n = nodeCollDaughters.length;
                int n2 = 0;
                while (n2 < n) {
                    NodeSetCollector collD = nodeSetCollectorArray[n2];
                    ((NodeSetCollectorUnion)collD).makeEmpty();
                    ++n2;
                }
            }
        }
        NodeSetCollectorUnion nodeSetCollectorUnion = nodeCollector;
        CST[nodeA.index][nodeB.index] = nodeSetCollectorUnion;
        return nodeSetCollectorUnion;
    }

    protected static void extractSubTreesIntermediate(NodeSetCollectorUnion[][] CPG, NodeSetCollectorSimple intermediateCollector) {
        NodeSetCollectorMUB finalNodeSet = new NodeSetCollectorMUB();
        NodeSetCollectorUnion[][] nodeSetCollectorUnionArray = CPG;
        int n = CPG.length;
        int n2 = 0;
        while (n2 < n) {
            NodeSetCollectorUnion[] wordCollectors;
            NodeSetCollectorUnion[] nodeSetCollectorUnionArray2 = wordCollectors = nodeSetCollectorUnionArray[n2];
            int n3 = wordCollectors.length;
            int n4 = 0;
            while (n4 < n3) {
                NodeSetCollectorUnion coll = nodeSetCollectorUnionArray2[n4];
                BitSet singleBS = coll.singleBS();
                if (singleBS != null) {
                    finalNodeSet.add(singleBS);
                }
                ++n4;
            }
            ++n2;
        }
        for (BitSet bs : finalNodeSet.bitSetSet) {
            if (bs.cardinality() == 1) continue;
            intermediateCollector.add(bs);
        }
    }

    public static TSNodeLabel[] extractSubTrees(NodeSetCollectorSimple intermediateCollector, TSNodeLabelStructure s) {
        TSNodeLabel[] result = new TSNodeLabel[intermediateCollector.size()];
        int index = 0;
        for (BitSet bs : intermediateCollector.bitSetSet) {
            TSNodeLabelIndex rootNode = s.structure[bs.nextSetBit(0)];
            TSNodeLabel fragment = rootNode.getSubTree(bs);
            result[index++] = fragment;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        File inputFile = new File("tmp/treesWo.mrg");
        ArrayList<TSNodeLabelStructure> treebank = TSNodeLabelStructure.readTreebank(inputFile);
        int size = treebank.size();
        Random random = new Random();
        TSNodeLabel toFind = new TSNodeLabel("(MD \"wo\")", false);
        boolean found = false;
        block0: while (!found) {
            TSNodeLabel[] recurringFragments;
            int index1 = random.nextInt(size);
            int index2 = random.nextInt(size);
            TSNodeLabelStructure t1 = treebank.get(index1);
            TSNodeLabelStructure t2 = treebank.get(index2);
            NodeSetCollectorUnion[][] CST = CommonSubtrees.getCST(t1, t2);
            NodeSetCollectorSimple intermediateCollector = new NodeSetCollectorSimple();
            CommonSubtrees.extractSubTreesIntermediate(CST, intermediateCollector);
            TSNodeLabel[] tSNodeLabelArray = recurringFragments = CommonSubtrees.extractSubTrees(intermediateCollector, t1);
            int n = recurringFragments.length;
            int n2 = 0;
            while (n2 < n) {
                TSNodeLabel rf = tSNodeLabelArray[n2];
                if (rf.equals(toFind)) {
                    System.out.println(index1);
                    System.out.println(index2);
                    String t1String = t1.structure[0].toStringQtree();
                    String t2String = t2.structure[0].toStringQtree();
                    System.out.println(t1String);
                    System.out.println(t2String);
                    System.out.println(t1String.length());
                    System.out.println(t2String.length());
                    TSNodeLabel[] tSNodeLabelArray2 = recurringFragments;
                    int n3 = recurringFragments.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TSNodeLabel rf1 = tSNodeLabelArray2[n4];
                        System.out.println(rf1);
                        ++n4;
                    }
                    found = true;
                    continue block0;
                }
                ++n2;
            }
        }
    }
}

