/*
 * Decompiled with CFR 0.152.
 */
package kernels;

import java.util.BitSet;
import java.util.HashSet;
import kernels.NodeSetCollector;

public class NodeSetCollectorSimple
extends NodeSetCollector {
    public HashSet<BitSet> bitSetSet = new HashSet();

    @Override
    public Object clone() {
        NodeSetCollectorSimple clone = new NodeSetCollectorSimple();
        clone.bitSetSet = (HashSet)this.bitSetSet.clone();
        return clone;
    }

    @Override
    public void makeEmpty() {
        this.bitSetSet.clear();
    }

    @Override
    public boolean add(BitSet newBs) {
        return this.bitSetSet.add(newBs);
    }

    @Override
    public boolean addAll(NodeSetCollector collector) {
        boolean result = false;
        NodeSetCollectorSimple coll = (NodeSetCollectorSimple)collector;
        for (BitSet bs : coll.bitSetSet) {
            boolean bl = result = this.add(bs) || result;
        }
        return result;
    }

    @Override
    public boolean addAllCombinations(NodeSetCollector[] collectors, int[] collectorsSizes, int defaultBitSet) {
        System.err.println("Not implemented for this node set collector... use standard instead");
        return false;
    }

    @Override
    public boolean removeSingleton(int index) {
        for (BitSet bs : this.bitSetSet) {
            if (bs.cardinality() != 1 || !bs.get(index)) continue;
            this.bitSetSet.remove(bs);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeUniqueSingleton() {
        for (BitSet bs : this.bitSetSet) {
            if (bs.cardinality() != 1) continue;
            this.bitSetSet.remove(bs);
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.bitSetSet.size();
    }

    @Override
    public BitSet uniteSubGraphs() {
        BitSet unionBS = new BitSet();
        for (BitSet bs : this.bitSetSet) {
            unionBS.or(bs);
        }
        return unionBS;
    }

    @Override
    public BitSet[] getBitSetsAsArray() {
        int size = this.size();
        if (size == 0) {
            return null;
        }
        return this.bitSetSet.toArray(new BitSet[size]);
    }

    @Override
    public int maxCardinality() {
        if (this.isEmpty()) {
            return 0;
        }
        int maxCardinality = -1;
        for (BitSet bs : this.bitSetSet) {
            int bsCard = bs.cardinality();
            if (bsCard <= maxCardinality) continue;
            maxCardinality = bsCard;
        }
        return maxCardinality;
    }

    @Override
    public String toString() {
        String result = "";
        for (BitSet bs : this.bitSetSet) {
            result = String.valueOf(result) + bs.toString() + "\n";
        }
        return result.trim();
    }
}

