/*
 * Decompiled with CFR 0.152.
 */
package kernels;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.ListIterator;
import kernels.NodeSetCollector;
import util.Utility;

public class NodeSetCollectorMUB
extends NodeSetCollector {
    public ArrayList<BitSet> bitSetSet = new ArrayList();

    @Override
    public Object clone() {
        NodeSetCollectorMUB clone = new NodeSetCollectorMUB();
        clone.bitSetSet = (ArrayList)this.bitSetSet.clone();
        return clone;
    }

    @Override
    public void makeEmpty() {
        this.bitSetSet.clear();
    }

    @Override
    public boolean add(BitSet newBs) {
        int newBsCard = newBs.cardinality();
        Iterator<BitSet> iter = this.bitSetSet.iterator();
        while (iter.hasNext()) {
            BitSet bs = iter.next();
            int bsCard = bs.cardinality();
            BitSet intersection = (BitSet)bs.clone();
            intersection.and(newBs);
            int intersectionCard = intersection.cardinality();
            if (intersectionCard == newBsCard) {
                return false;
            }
            if (intersectionCard != bsCard) continue;
            iter.remove();
            this.insertInOrder(newBs, newBsCard);
            return true;
        }
        this.insertInOrder(newBs, newBsCard);
        return true;
    }

    public boolean addDefaultBitSet(BitSet bs) {
        return this.add(bs);
    }

    private void insertInOrder(BitSet newBs, int newBsCard) {
        ListIterator<BitSet> iter = this.bitSetSet.listIterator();
        while (iter.hasNext()) {
            BitSet bs = iter.next();
            int bsCard = bs.cardinality();
            if (newBsCard < bsCard) continue;
            iter.previous();
            iter.add(newBs);
            while (iter.hasNext()) {
                bs = iter.next();
                bsCard = bs.cardinality();
                BitSet intersection = (BitSet)bs.clone();
                intersection.and(newBs);
                int intersectionCard = intersection.cardinality();
                if (intersectionCard != bsCard) continue;
                iter.remove();
            }
            return;
        }
        iter.add(newBs);
    }

    @Override
    public boolean addAll(NodeSetCollector collector) {
        if (collector.isEmpty()) {
            return false;
        }
        boolean result = false;
        NodeSetCollectorMUB coll = (NodeSetCollectorMUB)collector;
        for (BitSet bs : coll.bitSetSet) {
            boolean bl = result = this.add(bs) || result;
        }
        return result;
    }

    @Override
    public boolean addAllCombinations(NodeSetCollector[] collectors, int[] collectorsSizes, int defaultBitSet) {
        int[][] combinations;
        boolean result = false;
        int[][] nArray = combinations = Utility.combinations(collectorsSizes);
        int n = combinations.length;
        int n2 = 0;
        while (n2 < n) {
            int[] comb = nArray[n2];
            BitSet ks = this.getDefaultBitSet(defaultBitSet);
            int i = 0;
            while (i < collectors.length) {
                int comb_i = comb[i];
                BitSet choosenBitSet = ((NodeSetCollectorMUB)collectors[i]).bitSetSet.get(comb_i);
                ks.or(choosenBitSet);
                ++i;
            }
            result = this.add(ks) || result;
            ++n2;
        }
        return result;
    }

    @Override
    public boolean removeSingleton(int index) {
        if (this.bitSetSet.isEmpty()) {
            return false;
        }
        Iterator<BitSet> iter = this.bitSetSet.iterator();
        while (iter.hasNext()) {
            BitSet bs = iter.next();
            if (bs.cardinality() != 1 || !bs.get(index)) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeUniqueSingleton() {
        if (this.bitSetSet.isEmpty()) {
            return false;
        }
        Iterator<BitSet> iter = this.bitSetSet.iterator();
        while (iter.hasNext()) {
            BitSet bs = iter.next();
            if (bs.cardinality() != 1) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    public boolean removeSet(BitSet bs) {
        return this.bitSetSet.remove(bs);
    }

    @Override
    public int maxCardinality() {
        if (this.isEmpty()) {
            return 0;
        }
        int maxCardinality = -1;
        for (BitSet bs : this.bitSetSet) {
            int bsCard = bs.cardinality();
            if (bsCard <= maxCardinality) continue;
            maxCardinality = bsCard;
        }
        return maxCardinality;
    }

    @Override
    public int size() {
        return this.bitSetSet.size();
    }

    @Override
    public BitSet uniteSubGraphs() {
        BitSet unionBS = new BitSet();
        for (BitSet bs : this.bitSetSet) {
            unionBS.or(bs);
        }
        return unionBS;
    }

    @Override
    public BitSet[] getBitSetsAsArray() {
        int size = this.size();
        if (size == 0) {
            return null;
        }
        return this.bitSetSet.toArray(new BitSet[size]);
    }

    @Override
    public String toString() {
        String result = "";
        int size = this.size();
        ListIterator<BitSet> i = this.bitSetSet.listIterator();
        while (i.hasNext()) {
            BitSet bs = i.next();
            result = String.valueOf(result) + bs.toString();
            if (i.previousIndex() == size - 1) continue;
            result = String.valueOf(result) + "-";
        }
        return result.trim();
    }

    public BitSet getUniqueBitSetContainingElement(int element) {
        BitSet result = null;
        for (BitSet bs : this.bitSetSet) {
            if (!bs.get(element)) continue;
            if (result != null) {
                return null;
            }
            result = bs;
        }
        return result;
    }

    public BitSet getSetWithMaxUncoveredElements(BitSet currentCover) {
        int maxUncovered = -1;
        BitSet result = null;
        for (BitSet bs : this.bitSetSet) {
            BitSet uncovered = (BitSet)bs.clone();
            uncovered.andNot(currentCover);
            int card = uncovered.cardinality();
            if (card <= maxUncovered) continue;
            maxUncovered = card;
            result = bs;
        }
        return result;
    }
}

