/*
 * Decompiled with CFR 0.152.
 */
package tsg.mb;

import java.util.ArrayList;
import tsg.Label;
import tsg.TSNodeLabel;
import tsg.mb.TreeMarkoBinarization;
import util.BoundedLinkedList;

public class TreeMarkoBinarizationLeft_New
extends TreeMarkoBinarization {
    @Override
    public TSNodeLabel performMarkovBinarization(TSNodeLabel t) {
        TSNodeLabel result = TreeMarkoBinarizationLeft_New.performParentAnnotation(t);
        return this.performMarkoBinarizationLeft(result);
    }

    @Override
    public TSNodeLabel undoMarkovBinarization(TSNodeLabel t) {
        TSNodeLabel result = this.undoMarkoBinarizationLeft(t);
        return TreeMarkoBinarizationLeft_New.undoParentAnnotation(result);
    }

    private TSNodeLabel performMarkoBinarizationLeft(TSNodeLabel t) {
        int prole = t.prole();
        TSNodeLabel binaryCopy = new TSNodeLabel(t.label, t.isLexical);
        if (prole == 0) {
            return binaryCopy;
        }
        if (prole == 1) {
            TSNodeLabel onlyDaughter = this.performMarkoBinarizationLeft(t.firstDaughter());
            binaryCopy.daughters = new TSNodeLabel[]{onlyDaughter};
            onlyDaughter.parent = binaryCopy;
            return binaryCopy;
        }
        BoundedLinkedList<String> lastSiblings = new BoundedLinkedList<String>(markH);
        String parentLabelString = t.label();
        TSNodeLabel previousDaughter = this.performMarkoBinarizationLeft(t.daughters[prole - 1]);
        String previousDaughterLabelString = previousDaughter.label();
        lastSiblings.add(previousDaughterLabelString);
        Label previousLevelLabelString = TreeMarkoBinarizationLeft_New.buildArtificialLabel(parentLabelString, lastSiblings);
        TSNodeLabel previousLevel = new TSNodeLabel(previousLevelLabelString, false);
        binaryCopy.assignUniqueDaughter(previousLevel);
        int i = prole - 2;
        while (i > 0) {
            TSNodeLabel currentDaughter = this.performMarkoBinarizationLeft(t.daughters[i]);
            TSNodeLabel right = previousDaughter;
            lastSiblings.add(currentDaughter.label());
            Label newLevelLabel = TreeMarkoBinarizationLeft_New.buildArtificialLabel(parentLabelString, lastSiblings);
            TSNodeLabel newLevel = new TSNodeLabel(newLevelLabel, t.isLexical);
            previousLevel.assignDaughters(new TSNodeLabel[]{newLevel, right});
            previousLevel = newLevel;
            previousDaughter = currentDaughter;
            --i;
        }
        TSNodeLabel firstDaughter = this.performMarkoBinarizationLeft(t.daughters[0]);
        previousLevel.assignDaughters(new TSNodeLabel[]{firstDaughter, previousDaughter});
        return binaryCopy;
    }

    private TSNodeLabel undoMarkoBinarizationLeft(TSNodeLabel t) {
        int prole = t.prole();
        TSNodeLabel unbinaryCopy = new TSNodeLabel(t.label, t.isLexical);
        if (prole == 0) {
            return unbinaryCopy;
        }
        if (prole == 1) {
            TSNodeLabel onlyDaughter = this.undoMarkoBinarizationLeft(t.firstDaughter());
            if (TreeMarkoBinarizationLeft_New.isArtificialNode(onlyDaughter)) {
                unbinaryCopy.assignDaughters(onlyDaughter.daughters);
                return unbinaryCopy;
            }
            unbinaryCopy.assignUniqueDaughter(onlyDaughter);
            return unbinaryCopy;
        }
        ArrayList<TSNodeLabel> newDaughters = new ArrayList<TSNodeLabel>();
        TSNodeLabel currentLevel = t;
        do {
            newDaughters.add(this.undoMarkoBinarizationLeft(currentLevel.lastDaughter()));
        } while (TreeMarkoBinarizationLeft_New.isArtificialNode(currentLevel = currentLevel.daughters[0]));
        newDaughters.add(this.undoMarkoBinarizationLeft(currentLevel));
        int newProle = newDaughters.size();
        unbinaryCopy.daughters = new TSNodeLabel[newProle];
        int i = newProle - 1;
        for (TSNodeLabel d : newDaughters) {
            unbinaryCopy.daughters[i--] = d;
            d.parent = unbinaryCopy;
        }
        return unbinaryCopy;
    }

    @Override
    public String getDescription() {
        return "TreeMarkoBinarizationLeft_New";
    }

    public static void main(String[] args) throws Exception {
        markH = 0;
        markV = 1;
        TSNodeLabel t = new TSNodeLabel("(A (B b) (C (F f) (G g) (H h)) (D (I i)) (E (J (K k) (L l))))");
        TSNodeLabel[] tSNodeLabelArray = t.daughters;
        int n = t.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            d.isLexical = false;
            ++n2;
        }
        System.out.println(t.toStringQtree());
        TreeMarkoBinarizationLeft_New tmb = new TreeMarkoBinarizationLeft_New();
        TSNodeLabel markoBinarizedTree = tmb.performMarkovBinarization(t);
        System.out.println(markoBinarizedTree.toStringQtree());
        System.out.println(markoBinarizedTree.checkParentDaughtersConsistency());
        System.out.println(markoBinarizedTree.checkOnlyAndAllTerminalsAreLexical());
        System.out.println(markoBinarizedTree.maxBranching());
        TSNodeLabel original = tmb.undoMarkovBinarization(markoBinarizedTree);
        System.out.println(original.toStringQtree());
        System.out.println(original.equals(t));
        System.out.println(original.checkParentDaughtersConsistency());
        System.out.println(original.checkOnlyAndAllTerminalsAreLexical());
    }
}

