/*
 * Decompiled with CFR 0.152.
 */
package tsg.kernels;

import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Random;
import kernels.NodeSetCollector;
import kernels.NodeSetCollectorMUB;
import kernels.NodeSetCollectorSimple;
import settings.Parameters;
import tsg.TSNodeLabel;
import tsg.TSNodeLabelIndex;
import tsg.TSNodeLabelStructure;
import tsg.kernels.AllOrderedNodeSubSet;
import tsg.kernels.CommonStructures;
import util.Pair;

public abstract class CommonSubBranch
extends CommonStructures {
    public CommonSubBranch(ArrayList<TSNodeLabelStructure> treebank, int threads, int startIndex) {
        super(treebank, threads, startIndex);
    }

    protected static NodeSetCollectorMUB[][] getCST(TSNodeLabelStructure t1, TSNodeLabelStructure t2) {
        NodeSetCollectorMUB[][] CST = new NodeSetCollectorMUB[t1.length()][t2.length()];
        int currentLength = t1.length();
        TSNodeLabelIndex[] tSNodeLabelIndexArray = t1.structure;
        int n = t1.structure.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabelIndex nodeA = tSNodeLabelIndexArray[n2];
            TSNodeLabelIndex[] tSNodeLabelIndexArray2 = t2.structure;
            int n3 = t2.structure.length;
            int n4 = 0;
            while (n4 < n3) {
                TSNodeLabelIndex nodeB = tSNodeLabelIndexArray2[n4];
                CommonSubBranch.getCST(nodeA, nodeB, CST, currentLength);
                ++n4;
            }
            ++n2;
        }
        return CST;
    }

    private static NodeSetCollectorMUB getCST(TSNodeLabelIndex nodeA, TSNodeLabelIndex nodeB, NodeSetCollectorMUB[][] CST, int currentLength) {
        NodeSetCollectorMUB stored = CST[nodeA.index][nodeB.index];
        if (stored != null) {
            return stored;
        }
        NodeSetCollectorMUB nodeCollector = new NodeSetCollectorMUB();
        nodeCollector.setMaxLength(currentLength);
        if (nodeA.sameLabel(nodeB)) {
            ArrayList<ArrayList<Pair<TSNodeLabel>>> allDaughtersMatch;
            nodeCollector.addDefaultBitSet(nodeA.index);
            if (!nodeA.isLexical && (allDaughtersMatch = AllOrderedNodeSubSet.allDaughtersMatchBackupOnSimple(nodeA, nodeB)) != null) {
                int p = 0;
                for (ArrayList<Pair<TSNodeLabel>> pairList : allDaughtersMatch) {
                    int prole = pairList.size();
                    NodeSetCollectorMUB[] nodeCollDaughters = new NodeSetCollectorMUB[prole];
                    int[] nodeSetDaughtersLength = new int[prole];
                    int i = 0;
                    long totalComb = 1L;
                    for (Pair<TSNodeLabel> pair : pairList) {
                        int size;
                        NodeSetCollectorMUB collD;
                        TSNodeLabelIndex nodeADaughter = (TSNodeLabelIndex)pair.getFirst();
                        TSNodeLabelIndex nodeBDaughter = (TSNodeLabelIndex)pair.getSecond();
                        nodeCollDaughters[i] = collD = CommonSubBranch.getCST(nodeADaughter, nodeBDaughter, CST, currentLength);
                        nodeSetDaughtersLength[i] = size = collD.size();
                        totalComb *= (long)size;
                        ++i;
                    }
                    if (totalComb > (long)maxCombDaughters) {
                        Parameters.appendReturnInLogFile("Skipping comparison: total number of combinaitons to high: " + totalComb + "\n\t" + nodeA + "\n\t" + nodeB);
                        continue;
                    }
                    nodeCollector.addAllCombinations((NodeSetCollector[])nodeCollDaughters, nodeSetDaughtersLength, nodeA.index);
                    ++p;
                    NodeSetCollectorMUB[] nodeSetCollectorMUBArray = nodeCollDaughters;
                    int n = nodeCollDaughters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        NodeSetCollectorMUB collD = nodeSetCollectorMUBArray[n2];
                        collD.makeEmpty();
                        ++n2;
                    }
                }
            }
        }
        NodeSetCollectorMUB nodeSetCollectorMUB = nodeCollector;
        CST[nodeA.index][nodeB.index] = nodeSetCollectorMUB;
        return nodeSetCollectorMUB;
    }

    public static void extractSubTreesIntermediate(NodeSetCollectorMUB[][] CPG, NodeSetCollectorSimple intermediateCollector) {
        int nodeIndex = -1;
        NodeSetCollectorMUB finalNodeSet = new NodeSetCollectorMUB();
        NodeSetCollectorMUB[][] nodeSetCollectorMUBArray = CPG;
        int n = CPG.length;
        int n2 = 0;
        while (n2 < n) {
            NodeSetCollectorMUB[] wordCollectors = nodeSetCollectorMUBArray[n2];
            ++nodeIndex;
            NodeSetCollectorMUB[] nodeSetCollectorMUBArray2 = wordCollectors;
            int n3 = wordCollectors.length;
            int n4 = 0;
            while (n4 < n3) {
                NodeSetCollectorMUB coll = nodeSetCollectorMUBArray2[n4];
                finalNodeSet.addAll((NodeSetCollector)coll);
                ++n4;
            }
            ++n2;
        }
        for (BitSet bs : finalNodeSet.bitSetSet) {
            if (bs.cardinality() == 1) continue;
            intermediateCollector.add(bs);
        }
    }

    public static TSNodeLabel[] extractSubBranches(NodeSetCollectorSimple intermediateCollector, TSNodeLabelStructure s) {
        TSNodeLabel[] result = new TSNodeLabel[intermediateCollector.size()];
        int index = 0;
        for (BitSet bs : intermediateCollector.bitSetSet) {
            TSNodeLabelIndex rootNode = s.structure[bs.nextSetBit(0)];
            TSNodeLabel fragment = rootNode.getSubBranch(bs);
            result[index++] = fragment;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        File inputFile = new File("tmp/treesWo.mrg");
        ArrayList<TSNodeLabelStructure> treebank = TSNodeLabelStructure.readTreebank(inputFile);
        int size = treebank.size();
        Random random = new Random();
        TSNodeLabel toFind = new TSNodeLabel("(MD \"wo\")", false);
        boolean found = false;
        block0: while (!found) {
            TSNodeLabel[] recurringFragments;
            int index1 = random.nextInt(size);
            int index2 = random.nextInt(size);
            if (index1 == 172 || index2 == 172) continue;
            TSNodeLabelStructure t1 = treebank.get(index1);
            TSNodeLabelStructure t2 = treebank.get(index2);
            NodeSetCollectorMUB[][] CST = CommonSubBranch.getCST(t1, t2);
            NodeSetCollectorSimple intermediateCollector = new NodeSetCollectorSimple();
            CommonSubBranch.extractSubTreesIntermediate(CST, intermediateCollector);
            TSNodeLabel[] tSNodeLabelArray = recurringFragments = CommonSubBranch.extractSubBranches(intermediateCollector, t1);
            int n = recurringFragments.length;
            int n2 = 0;
            while (n2 < n) {
                TSNodeLabel rf = tSNodeLabelArray[n2];
                if (rf.equals(toFind)) {
                    System.out.println(index1);
                    System.out.println(index2);
                    String t1String = t1.structure[0].toStringQtree();
                    String t2String = t2.structure[0].toStringQtree();
                    System.out.println(t1String);
                    System.out.println(t2String);
                    System.out.println(t1String.length());
                    System.out.println(t2String.length());
                    TSNodeLabel[] tSNodeLabelArray2 = recurringFragments;
                    int n3 = recurringFragments.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TSNodeLabel rf1 = tSNodeLabelArray2[n4];
                        System.out.println(rf1);
                        ++n4;
                    }
                    found = true;
                    continue block0;
                }
                ++n2;
            }
        }
    }
}

