/*
 * Decompiled with CFR 0.152.
 */
package tsg.fragStats;

import java.io.File;
import java.util.Scanner;
import tsg.TSNodeLabel;
import util.FileUtil;

public class FragmentFilterIdioms {
    static boolean read2bytes = true;
    static int printProgressEvery = 100000;
    int minNumberWords = 8;
    int minFreq = 5;
    int minFronteerNonTerminal = 2;
    File fragmentFile;

    public FragmentFilterIdioms(File fragmentFile, int minNumberWords, int minFreq, int minFronteerNonTerminal) throws Exception {
        this.fragmentFile = fragmentFile;
        this.minNumberWords = minNumberWords;
        this.minFreq = minFreq;
        this.minFronteerNonTerminal = minFronteerNonTerminal;
        this.filterFragemntFile();
    }

    private void analyzeNextLine(String line) throws Exception {
        String[] lineSplit = line.split("\t");
        int freq = Integer.parseInt(lineSplit[1]);
        if (freq >= this.minFreq) {
            int fronteerNonTerminal;
            String fragString = lineSplit[0];
            if (fragString.matches(".*[\\$,%].*")) {
                return;
            }
            TSNodeLabel frag = new TSNodeLabel(fragString, false);
            int words = frag.countLexicalNodes();
            if (words >= this.minNumberWords && (fronteerNonTerminal = frag.countTerminalNodes() - words) >= this.minFronteerNonTerminal) {
                System.out.println(String.valueOf(freq) + "\t" + frag.toStringQtree());
            }
        }
    }

    private void filterFragemntFile() throws Exception {
        Scanner scan = FileUtil.getScanner(this.fragmentFile);
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            this.analyzeNextLine(line);
        }
        scan.close();
    }

    public static void main(String[] args) throws Exception {
        File fragmentFile = new File(args[0]);
        int minNumberWords = Integer.parseInt(args[1]);
        int minFreq = Integer.parseInt(args[2]);
        int minFronteerNonTerminal = Integer.parseInt(args[3]);
        new FragmentFilterIdioms(fragmentFile, minNumberWords, minFreq, minFronteerNonTerminal);
    }
}

