/*
 * Decompiled with CFR 0.152.
 */
package tsg;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Scanner;
import tsg.Label;
import tsg.TSNodeLabel;
import util.FileUtil;
import util.PrintProgressStatic;

public class HeadLabeler {
    public static Label jollylabel = Label.getLabel("*");
    public static final Label[] punctuation = new Label[]{Label.getLabel("''"), Label.getLabel(","), Label.getLabel("-LRB-"), Label.getLabel("-RRB-"), Label.getLabel("."), Label.getLabel(":"), Label.getLabel("``")};
    Hashtable<Label, ArrayList<PriorityList>> catPriorityListTable = new Hashtable();

    public HeadLabeler(InputStream is) {
        Scanner scan = new Scanner(is);
        this.scanHeads(scan);
        scan.close();
    }

    public HeadLabeler(File inputFile) {
        Scanner scan = FileUtil.getScanner(inputFile);
        this.scanHeads(scan);
        scan.close();
    }

    private void scanHeads(Scanner scan) {
        Label currentCat = null;
        while (scan.hasNextLine()) {
            String line = scan.nextLine().trim();
            if (line.length() == 0) continue;
            if (line.startsWith("->") || line.startsWith("=>")) {
                PriorityList pl = new PriorityList(line);
                this.addInCatPriorityListTable(currentCat, pl);
                continue;
            }
            currentCat = Label.getLabel(line);
        }
    }

    private void addInCatPriorityListTable(Label cat, PriorityList pl) {
        ArrayList<PriorityList> plCat = this.catPriorityListTable.get(cat);
        if (plCat == null) {
            plCat = new ArrayList();
            this.catPriorityListTable.put(cat, plCat);
        }
        plCat.add(pl);
    }

    public void markHead(TSNodeLabel t) {
        if (t.isPreLexical()) {
            return;
        }
        int prole = t.prole();
        if (prole == 1) {
            t.daughters[0].headMarked = true;
        } else {
            Label catFun = t.label;
            Label cat = t.label.getLabelWithoutSemTags();
            ArrayList<PriorityList> plCat = this.catPriorityListTable.get(catFun);
            if (plCat == null) {
                plCat = this.catPriorityListTable.get(cat);
            }
            if (plCat == null) {
                System.err.println("Found unknown cat: '" + cat + "'");
                System.exit(-1);
            }
            Label[] daughterLabels = new Label[prole];
            int i = 0;
            while (i < prole) {
                daughterLabels[i] = t.daughters[i].label.getLabelWithoutSemTags();
                ++i;
            }
            for (PriorityList pl : plCat) {
                if (HeadLabeler.annotateHead(pl, prole, daughterLabels, t.daughters)) break;
            }
        }
        TSNodeLabel[] tSNodeLabelArray = t.daughters;
        int n = t.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            this.markHead(d);
            ++n2;
        }
    }

    private static boolean equalsJollyButNotPunctuation(Label toMatch, Label daughter) {
        if (!toMatch.equals(jollylabel)) {
            return false;
        }
        Label[] labelArray = punctuation;
        int n = punctuation.length;
        int n2 = 0;
        while (n2 < n) {
            Label p = labelArray[n2];
            if (p.equals(daughter)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean annotateHead(PriorityList pl, int prole, Label[] daughterLabels, TSNodeLabel[] daughters) {
        if (pl.absoluteFirst) {
            if (pl.fromLeft) {
                int i = 0;
                while (i < prole) {
                    Label[] labelArray = pl.priorityList;
                    int n = pl.priorityList.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Label toMatch = labelArray[n2];
                        Label d = daughterLabels[i];
                        if (HeadLabeler.equalsJollyButNotPunctuation(toMatch, d) || d.equals(toMatch)) {
                            daughters[i].headMarked = true;
                            return true;
                        }
                        ++n2;
                    }
                    ++i;
                }
            } else {
                int i = prole - 1;
                while (i >= 0) {
                    Label[] labelArray = pl.priorityList;
                    int n = pl.priorityList.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Label toMatch = labelArray[n3];
                        Label d = daughterLabels[i];
                        if (HeadLabeler.equalsJollyButNotPunctuation(toMatch, d) || d.equals(toMatch)) {
                            daughters[i].headMarked = true;
                            return true;
                        }
                        ++n3;
                    }
                    --i;
                }
            }
        } else if (pl.fromLeft) {
            Label[] labelArray = pl.priorityList;
            int n = pl.priorityList.length;
            int n4 = 0;
            while (n4 < n) {
                Label toMatch = labelArray[n4];
                int i = 0;
                while (i < prole) {
                    Label d = daughterLabels[i];
                    if (HeadLabeler.equalsJollyButNotPunctuation(toMatch, d) || d.equals(toMatch)) {
                        daughters[i].headMarked = true;
                        return true;
                    }
                    ++i;
                }
                ++n4;
            }
        } else {
            Label[] labelArray = pl.priorityList;
            int n = pl.priorityList.length;
            int n5 = 0;
            while (n5 < n) {
                Label toMatch = labelArray[n5];
                int i = prole - 1;
                while (i >= 0) {
                    Label d = daughterLabels[i];
                    if (HeadLabeler.equalsJollyButNotPunctuation(toMatch, d) || d.equals(toMatch)) {
                        daughters[i].headMarked = true;
                        return true;
                    }
                    --i;
                }
                ++n5;
            }
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        File fedeRuleFile = new File("/Users/fsangati/Desktop/Viewers/fede.rules_12_11_09");
        File corpusFile = new File("/Users/fsangati/Desktop/Viewers/wsj-00_NP_fedeheads_31_10_09.mrg");
        ArrayList<TSNodeLabel> treebank = TSNodeLabel.getTreebank(corpusFile);
        HeadLabeler fedeLabeler = new HeadLabeler(fedeRuleFile);
        PrintProgressStatic.start("");
        for (TSNodeLabel t : treebank) {
            PrintProgressStatic.next();
            TSNodeLabel tCopy = t.clone();
            tCopy.removeHeadLabels();
            fedeLabeler.markHead(tCopy);
            if (!t.checkHeadCorrespondance(tCopy)) break;
        }
        PrintProgressStatic.end();
    }

    protected class PriorityList {
        boolean absoluteFirst;
        boolean fromLeft;
        Label[] priorityList;

        protected PriorityList(String line) {
            String[] fields = line.split("\\s+");
            this.absoluteFirst = fields[0].charAt(0) == '=';
            this.fromLeft = fields[1].toLowerCase().equals("left");
            this.priorityList = new Label[fields.length - 2];
            int i = 0;
            while (i < this.priorityList.length) {
                this.priorityList[i] = Label.getLabel(fields[i + 2]);
                ++i;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.absoluteFirst ? "=>" : "->");
            sb.append(" " + (this.fromLeft ? "left" : "right"));
            Label[] labelArray = this.priorityList;
            int n = this.priorityList.length;
            int n2 = 0;
            while (n2 < n) {
                Label l = labelArray[n2];
                sb.append(" " + l);
                ++n2;
            }
            return sb.toString();
        }
    }
}

