/*
 * Decompiled with CFR 0.152.
 */
package symbols;

import java.util.Hashtable;
import java.util.Vector;
import symbols.Symbol;

public class SymbolString
extends Symbol {
    private static final long serialVersionUID = 1L;
    protected static Hashtable<String, Integer> IDtableSymbol = new Hashtable();
    protected static Vector<String> IDtableReverseSymbol = new Vector();
    protected static Vector<SymbolString> SymbolVector = new Vector();
    protected static int SymbolCounter;

    public static int getSymbolCounter() {
        return SymbolCounter;
    }

    public SymbolString(String symbol) {
        Integer storedId = IDtableSymbol.get(symbol);
        if (storedId == null) {
            storedId = SymbolCounter++;
            IDtableSymbol.put(symbol, storedId);
            IDtableReverseSymbol.add(symbol);
            SymbolVector.add(this);
        }
        this.id = storedId;
    }

    public String getOriginalString() {
        return IDtableReverseSymbol.get(this.id);
    }

    @Override
    public Object getOriginalObject() {
        return this.getOriginalString();
    }

    public void relabel(String newSymbol) {
        IDtableSymbol.remove(this.getOriginalString());
        Integer storedId = IDtableSymbol.get(newSymbol);
        if (storedId == null) {
            IDtableSymbol.put(newSymbol, this.id);
            IDtableReverseSymbol.set(this.id, newSymbol);
            SymbolVector.set(this.id, this);
        } else {
            this.id = storedId;
        }
    }

    @Override
    public String toString() {
        return this.getOriginalString().toString();
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof SymbolString) {
            SymbolString anotherSymbol = (SymbolString)anObject;
            return this.id == anotherSymbol.id;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(SymbolString anotherSymbol) {
        return this.id == anotherSymbol.id;
    }
}

