[ROLE]
You are novice yet a very particular coder, and want to generate a specific user query exactly based on following guidelines. 
---
[INPUT]
You will be given `query`, `info`, and `info_updated`. This `query` is a command for generating a python code function. The `info` consists of extracted information from the `query` in JSON format. The `info_updated` consists of additional information over the current `info` what the exact specifications for format of input and output type to be used and returned in desired function.
---
[TASK]
You need to generate `query_updated` with all information from the `info_updated` ONLY. For completing the task follow these METHOD step-by-step:-
[METHOD]
1. Understand how connection of `info` is set with the `query`. Learn the technique of how to phrase using the extracted `info` into a natural language human like `query`.
2. Translate this knowledge and generate `query_updated` just by using `info_updated`. While doing this keep the following in mind:-
- `query_updated` should contain all the information or phrase within the `info_updated`
- Add a slight deviation from `query` by explicitly mentioning about the input and output response format
- DO NOT add any new information apart from `info_updated` in `query_updated`
- ALWAYS make sure for the information in `info_updated` uses the same phrasing as in `query` for the `query_updated` for information that is same as in `info`

---

`query`: Write a python function to give product number in words all in lowercase, of an integer with first k items of two given lists using lambda function.
`info`: {"task": "product", "method": ["lambda function"], "input_type": ["integer","two lists"], "input_property": ["first k"], "output_type": ["in words"], "output_property": ["lowercase"], "edge_cases": {}}
`info_updated`: {"task": "product", "method": ["lambda function"], "input_type": ["integer","two lists"], "input_property": ["first k"], "output_type": ["in words"], "output_property": ["lowercase"], "edge_cases": {"any empty": "'-'"}}
`query_updated`: Write a python function to give product number in words all in lowercase, of an integer with first k items of two given lists using lambda function. If any list is empty, return '-'.

---

`query`: Write a function to return ascending sort on descending sorted list.
`info`: {"task": "sort", "method": [], "input_type": ["list"], "input_property": ["descending", "sorted"], "output_type": [], "output_property": ["ascending"], "edge_cases": {}}
`info_updated`: {"task": "sort", "method": [], "input_type": ["list"], "input_property": ["descending", "sorted"], "output_type": ["list"], "output_property": ["ascending"], "edge_cases": {}}
`query_updated`: Write a function to return ascending sorted list from a descending sorted list.

---

`query`: Check if input is even.
`info`: {"task": "check", "method": [], "input_type": [], "input_property": [], "output_type": [], "output_property": ["even"], "edge_cases": {}}
`info_updated`: {"task": "check", "method": [], "input_type": ["number"], "input_property": [], "output_type": ["specific string"], "output_property": ["even"], "edge_cases": {"if True": "Even", "if False": "Not Even"}}
`query_updated`: Check if input number is even. If True return specific string of "Even", else return "Not Even".

---

`query`: Return strings with words longer.
`info`: {"task": "filter", "method": [], "input_type": [], "input_property": [], "output_type": ["strings"], "output_property": ["longer"], "edge_cases": {}}
`info_updated`: {"task": "filter", "method": [], "input_type": ["list of strings"], "input_property": [], "output_type": ["list of strings"], "output_property": ["longer than 2"], "edge_cases": {}}
`query_updated`: Return list of strings that have words longer than 2 from input of list of strings.

---

`query`: Find the maximum length of string.
`info`: {"task": "return", "method": [], "input_type": [], "input_property": [], "output_type": [], "output_property": ["maximum length"], "edge_cases": {}}
`info_updated`: {"task": "return", "method": [], "input_type": ["list of strings"], "input_property": [], "output_type": ["number"], "output_property": ["maximum length"], "edge_cases": {"if empty list": "-1"}}
`query_updated`: Find the maximum length of string from input of list of strings. If input list is empty return -1 number.

---

`query`: {{originalNL}}
`info`: {{info}}
`info_updated`: {{info_updated}}
`query_updated`: 