from Scripts.config_experiment.components.completeness_checker import *
from Scripts.config_experiment.components.display_csv import *
from Scripts.config_experiment.components.gen_mask import *
from Scripts.config_experiment.components.init_folder import *
from Scripts.config_experiment.components.make_dataset import *
from Scripts.Utils import *


def main(raw_args=None):
    args = get_args(raw_args)
    for i in range(args.max_iter + 1):
        print(f"--- Iteration {i} ---")
        if i == 0:
            print("Starting the experiment")
            initialize(raw_args)
            # initialize all folders and subset of dataset folder

        print("Checking the completeness of the code")
        generator(raw_args, iter=i)
        checker(raw_args, iter=i)
        # check the completeness of the code in completeness_checking folder
        print("Displaying the results in csv format")
        display(raw_args, iter=i)
        # display the results in csv format in completeness_checking/display_csv folder
        if i == args.max_iter:
            break
        print("Masking the complete dataset")
        mask(raw_args, iteration=i)
        # mask the dataset in min_spec_candidates folder
        print("Updating in the dataset")
        size_added = make_dataset(raw_args, iter=i)
        # make the dataset in dataset folder

        print(f"--- Iteration {i} completed ---\n")
        if not size_added:
            print("Experiment completed after iteration: ", i)
            break


if __name__ == "__main__":
    # try:
    main(raw_args=None)
# except Exception as e:
#     import pdb
#     pdb.post_mortem()
