#!/bin/bash
set -e

CUDA_VISIBLE_DEVICES=0 python run.py \
    --data_dir ./data/FB15k-237/ \
    --device cuda \
    --AMP_enabled True \
    --task train \
    --epochs 3 \
    --warmup 400 \
    --batch_size 256 \
    --actual_batch_size 64 \
    --test_batch_size 256 \
    --finetune_t True \
    --tau 0.05 \
    --margin 0.02 \
    --lr 5e-5 \
    --weight_decay 1e-4 \
    --neighborhood_sample_K 128 \
    --r_prompt_len 4 \
    --extra_negative_sample_size 1024 \
    --m_decay 0.999 \
    --add_neighbor_name True \
    --queue_size 14541 \
    --e_max_length 128 \
    --hr_max_length 128 \
    --entity_embedding_method MLP \
    --hr_neighborhood True \
    --e_neighborhood True \
    --plm_name bert-base-uncased 