theory question_81_3
imports Main

begin

typedecl entity
typedecl event

consts
  Soil :: "entity ⇒ bool"
  Nonliving :: "entity ⇒ bool"
  PartOf :: "entity ⇒ entity ⇒ bool"
  Environment :: "entity ⇒ bool"
  Forest :: "entity ⇒ bool"

(* Explanation 1: Soil is a kind of nonliving thing that can be part of a forest environment. *)
axiomatization where
  explanation_1: "∀x. Soil x ⟶ (∃y. Nonliving y ∧ PartOf x y ∧ Forest y)"

(* Explanation 2: Nonliving things, including soil, can be part of a forest environment. *)
axiomatization where
  explanation_2: "∀x. Nonliving x ⟶ (∃y. PartOf x y ∧ Forest y)"

theorem hypothesis:
  assumes asm: "Soil x"
  (* Hypothesis: Soil is a nonliving part of a forest. *)
  shows "Nonliving x ∧ PartOf x Forest"
proof -
  from asm have "Soil x" by simp
  then have "Nonliving x" using explanation_1 by blast
  then have "∃y. PartOf x y ∧ Forest y" using explanation_2 by blast
  then have "PartOf x Forest" using this by simp
  then show "Nonliving x ∧ PartOf x Forest" by auto
qed

end
