theory question_17_0

imports Main

begin

typedecl entity
typedecl event

consts
  Producer :: "entity ⇒ bool"
  Consumer :: "entity ⇒ bool"
  Omnivore :: "entity ⇒ bool"

(* Explanation 1: Plants are producers. *)
axiomatization where
  explanation_1: "∀x. Plant(x) ⟶ Producer x"

(* Explanation 2: Plants are consumers. *)
axiomatization where
  explanation_2: "∀x. Plant(x) ⟶ Consumer x"

(* Explanation 3: Plants are omnivores. *)
axiomatization where
  explanation_3: "∀x. Plant(x) ⟶ Omnivore x"

theorem hypothesis:
  assumes asm: "Omnivores x  ∧ TrophicLevel y  ∧ Feed e  ∧ Agent e  x  ∧ Patient e  y "
  (* Hypothesis: Omnivores can feed at more than one trophic level. *)
  shows "∃x y e. Omnivores x  ∧ TrophicLevel y  ∧ Feed e  ∧ Agent e  x  ∧ Patient e  y "
proof -
  from asm have "Omnivores x" by simp
  then obtain e1 where e1: "Feed e1 ∧ Agent e1 x ∧ Patient e1 y" using explanation_1 by blast
  then have "Consumer y" using explanation_2 by blast
  have conclusion: "Feed e1 ∧ Agent e1 x ∧ Patient e1 y" using e1 by simp
  show ?thesis using asm conclusion `Consumer y` by blast
qed

end
