theory question_20_3

imports Main

begin

typedecl entity
typedecl event

consts
  Mammals :: "entity ⇒ bool"
  Fur :: "entity ⇒ bool"
  Hair :: "entity ⇒ bool"
  UniqueCharacteristic :: "entity ⇒ bool"

(* Explanation 1: All mammals have fur or hair. *)
axiomatization where
  explanation_1: "∀x y. Mammals x ⟶ Fur y ∨ Hair y"

(* Explanation 2: Fur is a unique characteristic exclusive to mammals. *)
axiomatization where
  explanation_2: "∀x. Fur x ⟶ (∃y. Mammals y ∧ UniqueCharacteristic x)"  

theorem hypothesis:
  assumes asm: "Mammals x"
  (* Hypothesis: Fur is unique to mammals. *)
  shows "∃y. Fur y ∧ UniqueCharacteristic y ∧ Mammals x"
proof -
  from asm have "Mammals x" by simp
  then obtain y where "Fur y ∨ Hair y" using explanation_1 by blast
  then consider z where "Fur y" using explanation_2 by blast
  then have "UniqueCharacteristic z" using explanation_2 by blast
  then show ?thesis using `Fur y` `UniqueCharacteristic z` `Mammals x` by blast
qed

end
