theory question_85_1
imports Main

begin
typedecl entity
typedecl event

consts
  Vendors :: "entity ⇒ bool"
  Flowers :: "entity ⇒ bool"
  Sell :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  FlowerSeller :: "entity ⇒ bool"
  Sidewalk :: "entity ⇒ bool"
  FlowerCart :: "entity ⇒ bool"
  Vendor :: "entity ⇒ bool"
  Location :: "entity ⇒ entity ⇒ bool"
  
(* Explanation 1: Vendors who sell flowers are considered flower sellers. *)
axiomatization where
  explanation_1: "∀x. Vendors x ∧ (∃y. Flowers y ∧ Sell e ∧ Agent e x ∧ Patient e y) ⟶ FlowerSeller x"

theorem hypothesis:
  (* Premise: Sidewalk flower cart vendor. *)
  assumes asm: "Sidewalk x ∧ FlowerCart y ∧ Vendor x ∧ Location x y"
  (* Hypothesis: Flower seller on sidewalk. *)
  shows "∃x y e. FlowerSeller x ∧ Sidewalk y ∧ Sell e ∧ Agent e x ∧ Location e y"
proof -
  from asm have "Vendor x ∧ (∃y. Flowers y ∧ Sell e ∧ Agent e x ∧ Patient e y)" by blast
  then have "FlowerSeller x" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
