theory question_57_0

imports Main

begin
typedecl entity
typedecl event

consts
  MaintenancePerson :: "entity ⇒ bool"
  Statue :: "entity ⇒ bool"
  Walking :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Worker :: "entity ⇒ bool"

(* Explanation 1: A maintenance person walking past a statue. *)
axiomatization where
  explanation_1: "∃x y e. MaintenancePerson x ∧ Statue y ∧ Walking e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
  (* Premise: A maintenance worker walking past a statue. *)
  assumes asm: "MaintenancePerson x ∧ Statue y ∧ Walking e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: A worker walking by a statue. *)
  shows "∃x y e. Worker x ∧ Statue y ∧ Walking e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "MaintenancePerson x ∧ Statue y ∧ Walking e ∧ Agent e x ∧ Patient e y" by blast
  then show ?thesis using explanation_1 by blast
qed

end
