include "base.thrift"

namespace py MetaTranslationThrift
/* language codes
*  see https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes
* 'af', 'sq', 'am', 'ar', 'hy', 'az', 'eu', 'be', 'bn', 'bs', 'bg', 'ca',  'ny', 'zh', 'co', 'hr',
* 'cs', 'da', 'nl', 'en', 'eo', 'et', 'tl', 'fi', 'fr', 'fy', 'gl', 'ka', 'de', 'el', 'gu', 'ht', 'ha', 'iw',
* 'hi', 'hu', 'is', 'ig', 'id', 'ga', 'it', 'ja', 'jw', 'kn', 'kk', 'km', 'ko', 'ku', 'ky', 'lo', 'la', 'lv',
* 'lt', 'lb', 'mk', 'mg', 'ms', 'ml', 'mt', 'mi', 'mr', 'mn', 'my', 'ne', 'no', 'ps', 'fa', 'pl', 'pt', 'pa', 'ro',
* 'ru', 'sm', 'gd', 'sr', 'st', 'sn', 'sd', 'si', 'sk', 'sl', 'so', 'es', 'su', 'sw', 'sv', 'tg', 'ta', 'te', 'th',
* 'tr', 'uk', 'ur', 'uz', 'vi', 'cy', 'xh', 'yi', 'yo', 'zu'
*/

typedef list<string> StringList

struct Extra {
    1: optional string ref_id = "",
    2: optional string ref_type = "",
    3: optional string ref_string = "",
}

// translation result for each text in text_list of request
struct TranslationResponsePerText{
    1: string translated_text;           // translated string list
    2: string text;                      // original text
    3: string provider;                  // translation provider, lab, cache, google or microsoft
    4: string src_lang;                  // detected src language
    5: double score;                     // the score evaluated
    6: string msg;                       // some msg
    7: i32 code;                         // success (0) or failed (not 0),
}

typedef list<TranslationResponsePerText> TranslationResponsePerTextList

// the string in one request should be the same language, compatible with bytedance idl
struct RegularTranslationRequest{
    1: required StringList text_list;   // should be string list
    2: required string trg_lang;        // must provide
    3: required string id;              // must provide, e.g. p.s.m
    4: required string key;             // must provide
    16: optional string src_lang;       // better to provide
    17: optional StringList api_list;   // no need to provide, for test
    18: optional Extra extra;
    255: optional base.Base Base;
}

// compatible with bytedance idl
struct RegularTranslationResponse{
    1: TranslationResponsePerTextList translation_resp_list;  // translated string list
    255: base.BaseResp BaseResp;
}

service MetaTranslation{
    RegularTranslationResponse regular_translation(1:RegularTranslationRequest req),
    StringList available_api(1:string src_lang, 2:string trg_lang),
}