#!/bin/bash

logger_name=${1:-"logging_experiment_multiply.txt"}
mkdir -p results

DATE=$(date +%H%M%S-%d%m)

for predict_action in "predict_action" "no_predict_action"; do
    for predict_concept in "predict_concept" "no_predict_concept"; do
        for metric_learning in "metric_learning" "no_metric_learning"; do
            echo ${predict_action} ${predict_concept} ${metric_learning}
            PYTHONPATH=. python scripts/train_baseline_multiply.py \
                --model-name-or-path ../roberta-base/ \
                --tokenizer-path ../roberta-base/ \
                --data-folder data/split_0/ \
                --data-meta data/meta/ \
                --batch-size 300 \
                --number-of-epochs 10 \
                --${predict_action} \
                --${predict_concept} \
                --${metric_learning} \
                --save-path checkpoint.pt \
                --save-test-metrics-file results/${predict_action}__${predict_concept}__${metric_learning}.json #>> ${logger_name}
        done
    done
done

