 | Idx | Table      | Column | Primary Key | Foreign Key | 
 | ----------- | ----------- | ----------- | ----------- | ----------- | 
  | 0 |  | * |   |   | 
 | 1 | **Ref_Template_Types** | Template_Type_Code | + |   | 
 | 2 |   | Template_Type_Description |   |   | 
 | 3 | **Templates** | Template_ID | + |   | 
 | 4 |   | Version_Number |   |   | 
 | 5 |   | Template_Type_Code |   | --> 1 | 
 | 6 |   | Date_Effective_From |   |   | 
 | 7 |   | Date_Effective_To |   |   | 
 | 8 |   | Template_Details |   |   | 
 | 9 | **Documents** | Document_ID | + |   | 
 | 10 |   | Template_ID |   | --> 3 | 
 | 11 |   | Document_Name |   |   | 
 | 12 |   | Document_Description |   |   | 
 | 13 |   | Other_Details |   |   | 
 | 14 | **Paragraphs** | Paragraph_ID | + |   | 
 | 15 |   | Document_ID |   | --> 9 | 
 | 16 |   | Paragraph_Text |   |   | 
 | 17 |   | Other_Details |   |   | 
 
  | Index | Question  | SQL | gold QDMR | pred QDMR | Exec | SQL hardness |
  | ----------- | ----------- | ----------- |  ----------- | ----------- | ----------- | ----------- | 
 | SPIDER_dev_297 | How many documents do we have? | SELECT count(*) FROM Documents | 1. SELECT[tbl:​Documents] <br>2. AGGREGATE[count, #1] <br> | 1. SELECT[tbl:​Documents] <br>2. AGGREGATE[count, #1] <br> | + | easy | 
  | SPIDER_dev_299 | List document IDs, document names, and document descriptions for all documents. | SELECT document_id ,  document_name ,  document_description FROM Documents | 1. SELECT[tbl:​Documents] <br>2. PROJECT[col:​Documents:​Document_ID, #1] <br>3. PROJECT[col:​Documents:​Document_Name, #1] <br>4. PROJECT[col:​Documents:​Document_Description, #1] <br>5. UNION[#2, #3, #4] <br> | 1. SELECT[tbl:​Documents] <br>2. PROJECT[col:​Documents:​Document_ID, #1] <br>3. PROJECT[col:​Documents:​Document_Name, #1] <br>4. PROJECT[col:​Documents:​Document_Description, #1] <br>5. UNION[#2, #3, #4] <br> | + | medium | 
  | SPIDER_dev_300 | What are the ids, names, and descriptions for all documents? | SELECT document_id ,  document_name ,  document_description FROM Documents | 1. SELECT[tbl:​Documents] <br>2. PROJECT[col:​Documents:​Document_ID, #1] <br>3. PROJECT[col:​Documents:​Document_Name, #1] <br>4. PROJECT[col:​Documents:​Document_Description, #1] <br>5. UNION[#2, #3, #4] <br> | 1. SELECT[tbl:​Documents] <br>2. PROJECT[col:​Documents:​Document_ID, #1] <br>3. PROJECT[col:​Documents:​Document_Name, #1] <br>4. PROJECT[col:​Documents:​Document_Description, #1] <br>5. UNION[#2, #3, #4] <br> | + | medium | 
  | SPIDER_dev_301 | What is the document name and template id for document with description with the letter 'w' in it? | SELECT document_name ,  template_id FROM Documents WHERE Document_Description LIKE "%w%" | 1. SELECT[tbl:​Documents] <br>2. PROJECT[col:​Documents:​Document_Description, #1] <br>3. COMPARATIVE[#1, #2, comparative:​like:​%w%:​col:​Documents:​Document_Description] <br>4. PROJECT[col:​Documents:​Document_Name, #3] <br>5. PROJECT[col:​Documents:​Template_ID, #3] <br>6. UNION[#4, #5] <br> | 1. SELECT[tbl:​Documents] <br>2. PROJECT[col:​Documents:​Document_Description, #1] <br>3. COMPARATIVE[#1, #2, comparative:​like:​w:​col:​Documents:​Document_Description] <br>4. PROJECT[col:​Documents:​Document_Name, #3] <br>5. PROJECT[col:​Documents:​Template_ID, #3] <br>6. UNION[#4, #5] <br> | + | medium | 
  | SPIDER_dev_302 | Return the names and template ids for documents that contain the letter w in their description. | SELECT document_name ,  template_id FROM Documents WHERE Document_Description LIKE "%w%" | 1. SELECT[tbl:​Documents] <br>2. PROJECT[col:​Documents:​Document_Description, #1] <br>3. COMPARATIVE[#1, #2, comparative:​like:​%w%:​col:​Documents:​Document_Description] <br>4. PROJECT[col:​Documents:​Document_Name, #3] <br>5. PROJECT[col:​Documents:​Template_ID, #3] <br>6. PROJECT[col:​Documents:​Template_ID, #5] <br>7. UNION[#4, #6] <br> | 1. SELECT[tbl:​Documents] <br>2. PROJECT[col:​Documents:​Document_Description, #1] <br>3. COMPARATIVE[#1, #2, comparative:​like:​w:​col:​Documents:​Document_Description] <br>4. PROJECT[col:​Documents:​Document_Name, #3] <br>5. PROJECT[col:​Documents:​Template_ID, #3] <br>6. UNION[#4, #5] <br> | + | medium | 
  | SPIDER_dev_303 | What is the document id, template id and description for document named "Robbin CV"? | SELECT document_id ,  template_id ,  Document_Description FROM Documents WHERE document_name  =  "Robbin CV" | 1. SELECT[tbl:​Documents] <br>2. FILTER[#1, comparative:​=:​Robbin CV:​col:​Documents:​Document_Name] <br>3. PROJECT[col:​Documents:​Document_ID, #2] <br>4. PROJECT[col:​Documents:​Template_ID, #2] <br>5. PROJECT[col:​Documents:​Document_Description, #2] <br>6. UNION[#3, #4, #5] <br> | 1. SELECT[tbl:​Documents] <br>2. COMPARATIVE[#1, #1, comparative:​=:​Robbin CV:​col:​Documents:​Document_Name] <br>3. PROJECT[col:​Documents:​Document_ID, #2] <br>4. PROJECT[col:​Documents:​Template_ID, #2] <br>5. PROJECT[col:​Documents:​Document_Description, #2] <br>6. UNION[#3, #4, #5] <br> | + | medium | 
  | SPIDER_dev_304 | Return the document id, template id, and description for the document with the name Robbin CV. | SELECT document_id ,  template_id ,  Document_Description FROM Documents WHERE document_name  =  "Robbin CV" | 1. SELECT[tbl:​Documents] <br>2. FILTER[#1, comparative:​=:​Robbin CV:​col:​Documents:​Document_Name] <br>3. PROJECT[col:​Documents:​Document_ID, #2] <br>4. PROJECT[col:​Documents:​Template_ID, #2] <br>5. PROJECT[col:​Documents:​Document_Description, #2] <br>6. UNION[#3, #4, #5] <br> | 1. SELECT[tbl:​Documents] <br>2. PROJECT[col:​Documents:​Document_Name, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Robbin CV:​col:​Documents:​Document_Name] <br>4. PROJECT[col:​Documents:​Document_ID, #3] <br>5. PROJECT[col:​Documents:​Template_ID, #3] <br>6. PROJECT[col:​Documents:​Document_Description, #3] <br>7. UNION[#4, #5, #6] <br> | + | medium | 
  | SPIDER_dev_305 | How many different templates do all document use? | SELECT count(DISTINCT template_id) FROM Documents | 1. SELECT[tbl:​Documents] <br>2.*(distinct)* PROJECT[col:​Documents:​Template_ID, #1] <br>3. AGGREGATE[count, #2] <br> | 1. SELECT[tbl:​Documents] <br>2. PROJECT[col:​Documents:​Template_ID, #1] <br>3.*(distinct)* PROJECT[None, #2] <br>4. AGGREGATE[count, #3] <br> | + | easy | 
  | SPIDER_dev_306 | Count the number of different templates used for documents. | SELECT count(DISTINCT template_id) FROM Documents | 1. SELECT[tbl:​Documents] <br>2.*(distinct)* PROJECT[col:​Documents:​Template_ID, #1] <br>3. AGGREGATE[count, #2] <br> | 1. SELECT[tbl:​Documents] <br>2. PROJECT[tbl:​Templates, #1] <br>3.*(distinct)* PROJECT[None, #2] <br>4. AGGREGATE[count, #3] <br> | + | easy | 
  | SPIDER_dev_307 | How many documents are using the template with type code 'PPT'? | SELECT count(*) FROM Documents AS T1 JOIN Templates AS T2 ON T1.Template_ID  =  T2.Template_ID WHERE T2.Template_Type_Code  =  'PPT' | 1. SELECT[tbl:​Documents] <br>2. PROJECT[tbl:​Templates, #1] <br>3. PROJECT[col:​Templates:​Template_Type_Code, #2] <br>4. COMPARATIVE[#1, #3, comparative:​=:​PPT:​col:​Templates:​Template_Type_Code] <br>5. AGGREGATE[count, #4] <br> | 1. SELECT[tbl:​Documents] <br>2. PROJECT[tbl:​Templates, #1] <br>3. PROJECT[col:​Templates:​Template_Type_Code, #2] <br>4. COMPARATIVE[#1, #3, comparative:​=:​PPT:​col:​Templates:​Template_Type_Code] <br>5. AGGREGATE[count, #4] <br> | + | medium | 
  | SPIDER_dev_308 | Count the number of documents that use the PPT template type. | SELECT count(*) FROM Documents AS T1 JOIN Templates AS T2 ON T1.Template_ID  =  T2.Template_ID WHERE T2.Template_Type_Code  =  'PPT' | 1. SELECT[tbl:​Documents] <br>2. PROJECT[tbl:​Templates, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​PPT:​col:​Templates:​Template_Type_Code] <br>4. AGGREGATE[count, #3] <br> | 1. SELECT[tbl:​Documents] <br>2. PROJECT[tbl:​Templates, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​PPT:​col:​Templates:​Template_Type_Code] <br>4. AGGREGATE[count, #3] <br> | + | medium | 
  | SPIDER_dev_309 | Show all template ids and number of documents using each template. | SELECT template_id ,  count(*) FROM Documents GROUP BY template_id | 1. SELECT[col:​Documents:​Template_ID] <br>2. PROJECT[tbl:​Documents, #1] <br>3. GROUP[count, #2, #1] <br>4. PROJECT[col:​Documents:​Template_ID, #1] <br>5. UNION[#4, #3] <br> | 1. SELECT[col:​Documents:​Template_ID] <br>2. PROJECT[col:​Documents:​Template_ID, #1] <br>3. PROJECT[tbl:​Documents, #1] <br>4. GROUP[count, #3, #1] <br>5. UNION[#2, #4] <br> | + | medium | 
  | SPIDER_dev_310 | What are all different template ids used for documents, and how many times were each of them used? | SELECT template_id ,  count(*) FROM Documents GROUP BY template_id | 1. SELECT[tbl:​Documents] <br>2. PROJECT[col:​Documents:​Template_ID, #1] <br>3.*(distinct)* PROJECT[the different #REF, #2] <br>4. GROUP[count, #1, #3] <br>5. UNION[#3, #4] <br> | 1. SELECT[tbl:​Documents] <br>2. PROJECT[col:​Documents:​Template_ID, #1] <br>3. GROUP[count, #1, #2] <br>4. UNION[#2, #3] <br> | + | medium | 
  | SPIDER_dev_311 | What is the id and type code for the template used by the most documents? | SELECT T1.template_id ,  T2.Template_Type_Code FROM Documents AS T1 JOIN Templates AS T2 ON T1.template_id  =  T2.template_id GROUP BY T1.template_id ORDER BY count(*) DESC LIMIT 1 | 1. SELECT[tbl:​Templates] <br>2. PROJECT[tbl:​Documents, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br>5. PROJECT[col:​Documents:​Template_ID, #4] <br>6. PROJECT[col:​Templates:​Template_Type_Code, #5] <br>7. UNION[#5, #6] <br> | 1. SELECT[tbl:​Templates] <br>2. PROJECT[tbl:​Documents, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br>5. PROJECT[col:​Templates:​Template_ID, #4] <br>6. PROJECT[col:​Templates:​Template_Type_Code, #4] <br>7. UNION[#5, #6] <br> | + | extra | 
  | SPIDER_dev_312 | Return the id and type code of the template that is used for the greatest number of documents. | SELECT T1.template_id ,  T2.Template_Type_Code FROM Documents AS T1 JOIN Templates AS T2 ON T1.template_id  =  T2.template_id GROUP BY T1.template_id ORDER BY count(*) DESC LIMIT 1 | 1. SELECT[tbl:​Templates] <br>2. PROJECT[tbl:​Documents, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​max:​None] <br>5. PROJECT[col:​Documents:​Template_ID, #4] <br>6. PROJECT[col:​Templates:​Template_Type_Code, #4] <br>7. UNION[#5, #6] <br> | 1. SELECT[tbl:​Templates] <br>2. PROJECT[tbl:​Documents, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br>5. PROJECT[col:​Templates:​Template_ID, #4] <br>6. PROJECT[col:​Templates:​Template_Type_Code, #4] <br>7. UNION[#5, #6] <br> | + | extra | 
  | SPIDER_dev_313 | Show ids for all templates that are used by more than one document. | SELECT template_id FROM Documents GROUP BY template_id HAVING count(*)  >  1 | 1. SELECT[col:​Documents:​Template_ID] <br>2. PROJECT[tbl:​Documents, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​>:​1] <br>5. PROJECT[col:​Documents:​Template_ID, #4] <br> | 1. SELECT[tbl:​Templates] <br>2. PROJECT[tbl:​Documents, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​>:​1] <br>5. PROJECT[col:​Templates:​Template_ID, #4] <br> | + | easy | 
  | SPIDER_dev_314 | What are the template ids of any templates used in more than a single document? | SELECT template_id FROM Documents GROUP BY template_id HAVING count(*)  >  1 | 1. SELECT[col:​Documents:​Template_ID] <br>2. PROJECT[tbl:​Documents, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​>:​1] <br>5. PROJECT[col:​Documents:​Template_ID, #4] <br> | 1. SELECT[col:​Documents:​Template_ID] <br>2. PROJECT[tbl:​Documents, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #1, None] <br>5. PROJECT[col:​Documents:​Template_ID, #4] <br> | - | easy | 
  | SPIDER_dev_316 | What are the ids for templates that are not used in any documents? | SELECT template_id FROM Templates EXCEPT SELECT template_id FROM Documents | 1. SELECT[tbl:​Templates] <br>2. FILTER[#1, tbl:​Documents] <br>3. DISCARD[#1, #2] <br>4. PROJECT[col:​Templates:​Template_ID, #3] <br> | 1. SELECT[tbl:​Templates] <br>2. PROJECT[col:​Templates:​Template_ID, #1] <br>3. SELECT[tbl:​Templates] <br>4. DISCARD[#3, #2] <br>5. PROJECT[col:​Templates:​Template_ID, #4] <br> | - | hard | 
  | SPIDER_dev_317 | How many templates do we have? | SELECT count(*) FROM Templates | 1. SELECT[tbl:​Templates] <br>2. AGGREGATE[count, #1] <br> | 1. SELECT[tbl:​Templates] <br>2. AGGREGATE[count, #1] <br> | + | easy | 
  | SPIDER_dev_318 | Count the number of templates. | SELECT count(*) FROM Templates | 1. SELECT[tbl:​Templates] <br>2. AGGREGATE[count, #1] <br> | 1. SELECT[tbl:​Templates] <br>2. AGGREGATE[count, #1] <br> | + | easy | 
  | SPIDER_dev_319 | Show template ids, version numbers, and template type codes for all templates. | SELECT template_id ,  version_number ,  template_type_code FROM Templates | 1. SELECT[tbl:​Templates] <br>2. PROJECT[col:​Templates:​Template_ID, #1] <br>3. PROJECT[col:​Templates:​Version_Number, #1] <br>4. PROJECT[col:​Templates:​Template_Type_Code, #1] <br>5. UNION[#2, #3, #4] <br> | 1. SELECT[tbl:​Templates] <br>2. PROJECT[col:​Templates:​Template_ID, #1] <br>3. PROJECT[col:​Templates:​Version_Number, #1] <br>4. PROJECT[col:​Templates:​Template_Type_Code, #1] <br>5. UNION[#2, #3, #4] <br> | + | medium | 
  | SPIDER_dev_320 | What are the ids, version numbers, and type codes for each template? | SELECT template_id ,  version_number ,  template_type_code FROM Templates | 1. SELECT[tbl:​Templates] <br>2. PROJECT[col:​Templates:​Template_ID, #1] <br>3. PROJECT[col:​Templates:​Version_Number, #1] <br>4. PROJECT[col:​Templates:​Template_Type_Code, #1] <br>5. UNION[#2, #3, #4] <br> | 1. SELECT[tbl:​Templates] <br>2. PROJECT[col:​Templates:​Template_ID, #1] <br>3. PROJECT[col:​Templates:​Version_Number, #1] <br>4. PROJECT[col:​Templates:​Template_Type_Code, #1] <br>5. UNION[#2, #3, #4] <br> | + | medium | 
  | SPIDER_dev_321 | Show all distinct template type codes for all templates. | SELECT DISTINCT template_type_code FROM Templates | 1. SELECT[tbl:​Templates] <br>2. PROJECT[tbl:​Templates, #1] <br>3.*(distinct)* PROJECT[col:​Templates:​Template_Type_Code, #2] <br> | 1. SELECT[tbl:​Templates] <br>2. PROJECT[col:​Templates:​Template_Type_Code, #1] <br>3.*(distinct)* PROJECT[None, #2] <br> | + | easy | 
  | SPIDER_dev_322 | What are the different template type codes? | SELECT DISTINCT template_type_code FROM Templates | 1. SELECT[tbl:​Templates] <br>2.*(distinct)* PROJECT[col:​Templates:​Template_Type_Code, #1] <br> | 1. SELECT[tbl:​Ref_Template_Types] <br>2.*(distinct)* PROJECT[None, #1] <br> | + | easy | 
  | SPIDER_dev_323 | What are the ids of templates with template type code PP or PPT? | SELECT template_id FROM Templates WHERE template_type_code  =  "PP" OR template_type_code  =  "PPT" | 1. SELECT[tbl:​Templates] <br>2. PROJECT[tbl:​Templates, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​PPT:​col:​Templates:​Template_Type_Code] <br>4. COMPARATIVE[#1, #2, comparative:​=:​PP:​col:​Templates:​Template_Type_Code] <br>5. UNION[#3, #4] <br>6. PROJECT[col:​Templates:​Template_ID, #5] <br> | 1. SELECT[tbl:​Templates] <br>2. PROJECT[tbl:​Templates, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​PP:​col:​Templates:​Template_Type_Code] <br>4. COMPARATIVE[#1, #2, comparative:​=:​PPT:​col:​Templates:​Template_Type_Code] <br>5. UNION[#3, #4] <br>6. PROJECT[col:​Templates:​Template_ID, #5] <br> | + | medium | 
  | SPIDER_dev_324 | Return the ids of templates that have the code PP or PPT. | SELECT template_id FROM Templates WHERE template_type_code  =  "PP" OR template_type_code  =  "PPT" | 1. SELECT[tbl:​Templates] <br>2. PROJECT[col:​Templates:​Template_Type_Code, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​PPT:​col:​Templates:​Template_Type_Code] <br>4. COMPARATIVE[#1, #2, comparative:​=:​PP:​col:​Templates:​Template_Type_Code] <br>5. UNION[#3, #4] <br>6. PROJECT[col:​Templates:​Template_ID, #5] <br> | 1. SELECT[tbl:​Templates] <br>2. PROJECT[col:​Templates:​Template_Type_Code, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​PP:​col:​Templates:​Template_Type_Code] <br>4. COMPARATIVE[#1, #2, comparative:​=:​PPT:​col:​Templates:​Template_Type_Code] <br>5. UNION[#3, #4] <br>6. PROJECT[col:​Templates:​Template_ID, #5] <br> | + | medium | 
  | SPIDER_dev_325 | How many templates have template type code CV? | SELECT count(*) FROM Templates WHERE template_type_code  =  "CV" | 1. SELECT[tbl:​Templates] <br>2. PROJECT[tbl:​Templates, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​CV:​col:​Templates:​Template_Type_Code] <br>4. AGGREGATE[count, #3] <br> | 1. SELECT[tbl:​Templates] <br>2. PROJECT[tbl:​Templates, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​CV:​col:​Templates:​Template_Type_Code] <br>4. AGGREGATE[count, #3] <br> | + | easy | 
  | SPIDER_dev_326 | Count the number of templates of the type CV. | SELECT count(*) FROM Templates WHERE template_type_code  =  "CV" | 1. SELECT[tbl:​Templates] <br>2. PROJECT[col:​Templates:​Template_Type_Code, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​CV:​col:​Templates:​Template_Type_Code] <br>4. AGGREGATE[count, #3] <br> | 1. SELECT[tbl:​Templates] <br>2. PROJECT[tbl:​Templates, #1] <br>3. COMPARATIVE[#2, #1, comparative:​=:​CV:​col:​Templates:​Template_Type_Code] <br>4. AGGREGATE[count, #3] <br> | + | easy | 
  | SPIDER_dev_327 | What is the version number and template type code for the template with version number later than 5? | SELECT version_number ,  template_type_code FROM Templates WHERE version_number  >  5 | 1. SELECT[tbl:​Templates] <br>2. PROJECT[col:​Templates:​Version_Number, #1] <br>3. COMPARATIVE[#1, #2, comparative:​>:​5:​col:​Templates:​Version_Number] <br>4. PROJECT[col:​Templates:​Version_Number, #3] <br>5. PROJECT[col:​Templates:​Template_Type_Code, #3] <br>6. UNION[#4, #5] <br> | 1. SELECT[tbl:​Templates] <br>2. PROJECT[col:​Templates:​Version_Number, #1] <br>3. COMPARATIVE[#1, #2, comparative:​>:​5:​col:​Templates:​Version_Number] <br>4. PROJECT[col:​Templates:​Version_Number, #3] <br>5. PROJECT[col:​Templates:​Template_Type_Code, #3] <br>6. UNION[#4, #5] <br> | + | medium | 
  | SPIDER_dev_328 | Return the version numbers and template type codes of templates with a version number greater than 5. | SELECT version_number ,  template_type_code FROM Templates WHERE version_number  >  5 | 1. SELECT[tbl:​Templates] <br>2. PROJECT[col:​Templates:​Version_Number, #1] <br>3. COMPARATIVE[#1, #2, comparative:​>:​5:​col:​Templates:​Version_Number] <br>4. PROJECT[col:​Templates:​Version_Number, #3] <br>5. PROJECT[col:​Templates:​Template_Type_Code, #3] <br>6. UNION[#4, #5] <br> | 1. SELECT[tbl:​Templates] <br>2. PROJECT[col:​Templates:​Version_Number, #1] <br>3. COMPARATIVE[#1, #2, comparative:​>:​5:​col:​Templates:​Version_Number] <br>4. PROJECT[col:​Templates:​Version_Number, #3] <br>5. PROJECT[col:​Templates:​Template_Type_Code, #3] <br>6. UNION[#4, #5] <br> | + | medium | 
  | SPIDER_dev_329 | Show all template type codes and number of templates for each. | SELECT template_type_code ,  count(*) FROM Templates GROUP BY template_type_code | 1. SELECT[col:​Templates:​Template_Type_Code] <br>2. PROJECT[tbl:​Templates, #1] <br>3. GROUP[count, #2, #1] <br>4. UNION[#1, #3] <br> | 1. SELECT[col:​Templates:​Template_Type_Code] <br>2. PROJECT[col:​Templates:​Template_Type_Code, #1] <br>3. PROJECT[tbl:​Templates, #1] <br>4. GROUP[count, #3, #2] <br>5. UNION[#2, #4] <br> | + | medium | 
  | SPIDER_dev_330 | What are the different template type codes, and how many templates correspond to each? | SELECT template_type_code ,  count(*) FROM Templates GROUP BY template_type_code | 1. SELECT[tbl:​Templates] <br>2. PROJECT[col:​Templates:​Template_Type_Code, #1] <br>3.*(distinct)* PROJECT[different #REF, #2] <br>4. GROUP[count, #1, #3] <br>5. UNION[#3, #4] <br> | 1. SELECT[col:​Templates:​Template_Type_Code] <br>2.*(distinct)* PROJECT[col:​Templates:​Template_Type_Code, #1] <br>3. PROJECT[tbl:​Templates, #2] <br>4. GROUP[count, #3, #2] <br>5. UNION[#2, #4] <br> | + | medium | 
  | SPIDER_dev_331 | Which template type code has most number of templates? | SELECT template_type_code FROM Templates GROUP BY template_type_code ORDER BY count(*) DESC LIMIT 1 | 1. SELECT[col:​Templates:​Template_Type_Code] <br>2. PROJECT[tbl:​Templates, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br> | 1. SELECT[col:​Templates:​Template_Type_Code] <br>2. PROJECT[tbl:​Templates, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br> | + | hard | 
  | SPIDER_dev_332 | Return the type code of the template type that the most templates belong to. | SELECT template_type_code FROM Templates GROUP BY template_type_code ORDER BY count(*) DESC LIMIT 1 | 1. SELECT[col:​Templates:​Template_Type_Code] <br>2. PROJECT[tbl:​Templates, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br>5. PROJECT[col:​Templates:​Template_Type_Code, #4] <br> | 1. SELECT[col:​Templates:​Template_Type_Code] <br>2. PROJECT[tbl:​Templates, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br>5. PROJECT[col:​Templates:​Template_Type_Code, #4] <br> | + | hard | 
  | SPIDER_dev_333 | Show all template type codes with less than three templates. | SELECT template_type_code FROM Templates GROUP BY template_type_code HAVING count(*)  <  3 | 1. SELECT[col:​Templates:​Template_Type_Code] <br>2. PROJECT[tbl:​Templates, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​<:​3] <br> | 1. SELECT[col:​Templates:​Template_Type_Code] <br>2. PROJECT[tbl:​Templates, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​<:​3] <br> | + | easy | 
  | SPIDER_dev_334 | What are the codes of template types that have fewer than 3 templates? | SELECT template_type_code FROM Templates GROUP BY template_type_code HAVING count(*)  <  3 | 1. SELECT[col:​Templates:​Template_Type_Code] <br>2. PROJECT[tbl:​Templates, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​<:​3] <br>5. PROJECT[col:​Templates:​Template_Type_Code, #4] <br> | 1. SELECT[col:​Templates:​Template_Type_Code] <br>2. PROJECT[tbl:​Templates, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​<:​3] <br>5. PROJECT[col:​Templates:​Template_Type_Code, #4] <br> | + | easy | 
  | SPIDER_dev_337 | What is the template type code of the template used by document with the name "Data base"? | SELECT T1.template_type_code FROM Templates AS T1 JOIN Documents AS T2 ON T1.template_id  =  T2.template_id WHERE T2.document_name  =  "Data base" | 1. SELECT[tbl:​Documents] <br>2. FILTER[#1, comparative:​=:​Data base:​col:​Documents:​Document_Name] <br>3. PROJECT[tbl:​Templates, #2] <br>4. PROJECT[col:​Templates:​Template_Type_Code, #3] <br> | 1. SELECT[tbl:​Documents] <br>2. PROJECT[col:​Documents:​Document_Name, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Data base:​col:​Documents:​Document_Name] <br>4. PROJECT[tbl:​Templates, #3] <br>5. PROJECT[col:​Templates:​Template_Type_Code, #4] <br> | + | medium | 
  | SPIDER_dev_338 | Return the template type code of the template that is used by a document named Data base. | SELECT T1.template_type_code FROM Templates AS T1 JOIN Documents AS T2 ON T1.template_id  =  T2.template_id WHERE T2.document_name  =  "Data base" | 1. SELECT[tbl:​Templates] <br>2. PROJECT[tbl:​Documents, #1] <br>3. FILTER[#2, comparative:​=:​Data base:​col:​Documents:​Document_Name] <br>4. PROJECT[col:​Templates:​Template_Type_Code, #3] <br> | 1. SELECT[tbl:​Templates] <br>2. PROJECT[tbl:​Documents, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Data base:​col:​Documents:​Document_Name] <br>4. PROJECT[col:​Templates:​Template_Type_Code, #3] <br> | + | medium | 
  | SPIDER_dev_339 | Show all document names using templates with template type code BK. | SELECT T2.document_name FROM Templates AS T1 JOIN Documents AS T2 ON T1.template_id  =  T2.template_id WHERE T1.template_type_code  =  "BK" | 1. SELECT[tbl:​Templates] <br>2. PROJECT[tbl:​Templates, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​BK:​col:​Templates:​Template_Type_Code] <br>4. PROJECT[tbl:​Documents, #3] <br>5. PROJECT[col:​Documents:​Document_Name, #4] <br> | 1. SELECT[tbl:​Documents] <br>2. PROJECT[tbl:​Templates, #1] <br>3. PROJECT[col:​Templates:​Template_Type_Code, #2] <br>4. COMPARATIVE[#1, #3, comparative:​=:​BK:​col:​Templates:​Template_Type_Code] <br>5. PROJECT[col:​Documents:​Document_Name, #4] <br> | + | medium | 
  | SPIDER_dev_340 | What are the names of documents that use templates with the code BK? | SELECT T2.document_name FROM Templates AS T1 JOIN Documents AS T2 ON T1.template_id  =  T2.template_id WHERE T1.template_type_code  =  "BK" | 1. SELECT[tbl:​Documents] <br>2. PROJECT[tbl:​Templates, #1] <br>3. PROJECT[col:​Templates:​Template_Type_Code, #2] <br>4. COMPARATIVE[#1, #3, comparative:​=:​BK:​col:​Templates:​Template_Type_Code] <br>5. PROJECT[col:​Documents:​Document_Name, #4] <br> | 1. SELECT[tbl:​Documents] <br>2. PROJECT[tbl:​Templates, #1] <br>3. PROJECT[col:​Templates:​Template_Type_Code, #2] <br>4. COMPARATIVE[#1, #3, comparative:​=:​BK:​col:​Templates:​Template_Type_Code] <br>5. PROJECT[col:​Documents:​Document_Name, #4] <br> | + | medium | 
  | SPIDER_dev_341 | Show all template type codes and the number of documents using each type. | SELECT T1.template_type_code ,  count(*) FROM Templates AS T1 JOIN Documents AS T2 ON T1.template_id  =  T2.template_id GROUP BY T1.template_type_code | 1. SELECT[col:​Templates:​Template_Type_Code] <br>2. PROJECT[tbl:​Documents, #1] <br>3. GROUP[count, #2, #1] <br>4. UNION[#1, #3] <br> | 1. SELECT[col:​Templates:​Template_Type_Code] <br>2. PROJECT[tbl:​Documents, #1] <br>3. GROUP[count, #2, #1] <br>4. UNION[#1, #3] <br> | + | medium | 
  | SPIDER_dev_342 | What are the different template type codes, and how many documents use each type? | SELECT T1.template_type_code ,  count(*) FROM Templates AS T1 JOIN Documents AS T2 ON T1.template_id  =  T2.template_id GROUP BY T1.template_type_code | 1. SELECT[col:​Templates:​Template_Type_Code] <br>2.*(distinct)* PROJECT[different #REF, #1] <br>3. PROJECT[tbl:​Documents, #2] <br>4. GROUP[count, #3, #2] <br>5. UNION[#2, #4] <br> | 1. SELECT[col:​Templates:​Template_Type_Code] <br>2. PROJECT[col:​Templates:​Template_Type_Code, #1] <br>3. PROJECT[tbl:​Documents, #2] <br>4. GROUP[count, #3, #2] <br>5. UNION[#2, #4] <br> | + | medium | 
  | SPIDER_dev_343 | Which template type code is used by most number of documents? | SELECT T1.template_type_code FROM Templates AS T1 JOIN Documents AS T2 ON T1.template_id  =  T2.template_id GROUP BY T1.template_type_code ORDER BY count(*) DESC LIMIT 1 | 1. SELECT[col:​Templates:​Template_Type_Code] <br>2. PROJECT[tbl:​Documents, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br> | 1. SELECT[col:​Templates:​Template_Type_Code] <br>2. PROJECT[tbl:​Documents, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br> | + | extra | 
  | SPIDER_dev_344 | Return the code of the template type that is most commonly used in documents. | SELECT T1.template_type_code FROM Templates AS T1 JOIN Documents AS T2 ON T1.template_id  =  T2.template_id GROUP BY T1.template_type_code ORDER BY count(*) DESC LIMIT 1 | 1. SELECT[col:​Templates:​Template_Type_Code] <br>2. PROJECT[tbl:​Documents, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br>5. PROJECT[col:​Templates:​Template_Type_Code, #4] <br> | 1. SELECT[tbl:​Templates] <br>2. PROJECT[tbl:​Documents, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br>5. PROJECT[col:​Templates:​Template_Type_Code, #4] <br> | + | extra | 
  | SPIDER_dev_347 | Show all template type codes and descriptions. | SELECT template_type_code ,  template_type_description FROM Ref_template_types | 1. SELECT[tbl:​Ref_Template_Types] <br>2. PROJECT[col:​Ref_Template_Types:​Template_Type_Code, #1] <br>3. PROJECT[col:​Ref_Template_Types:​Template_Type_Description, #1] <br>4. UNION[#2, #3] <br> | 1. SELECT[col:​Ref_Template_Types:​Template_Type_Code] <br>2. PROJECT[col:​Ref_Template_Types:​Template_Type_Description, #1] <br>3. UNION[#1, #2] <br> | + | medium | 
  | SPIDER_dev_348 | What are the type codes and descriptions for all template types? | SELECT template_type_code ,  template_type_description FROM Ref_template_types | 1. SELECT[tbl:​Ref_Template_Types] <br>2. PROJECT[col:​Ref_Template_Types:​Template_Type_Code, #1] <br>3. PROJECT[col:​Ref_Template_Types:​Template_Type_Description, #1] <br>4. UNION[#2, #3] <br> | 1. SELECT[tbl:​Ref_Template_Types] <br>2. PROJECT[col:​Ref_Template_Types:​Template_Type_Code, #1] <br>3. PROJECT[col:​Ref_Template_Types:​Template_Type_Description, #1] <br>4. UNION[#2, #3] <br> | + | medium | 
  | SPIDER_dev_349 | What is the template type descriptions for template type code "AD". | SELECT template_type_description FROM Ref_template_types WHERE template_type_code  =  "AD" | 1. SELECT[tbl:​Ref_Template_Types] <br>2. FILTER[#1, comparative:​=:​AD:​col:​Ref_Template_Types:​Template_Type_Code] <br>3. PROJECT[col:​Ref_Template_Types:​Template_Type_Description, #2] <br> | 1. SELECT[tbl:​Ref_Template_Types] <br>2. PROJECT[col:​Ref_Template_Types:​Template_Type_Code, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​AD:​col:​Ref_Template_Types:​Template_Type_Code] <br>4. PROJECT[col:​Ref_Template_Types:​Template_Type_Description, #3] <br> | + | easy | 
  | SPIDER_dev_350 | Return the template type description of the template type with the code AD. | SELECT template_type_description FROM Ref_template_types WHERE template_type_code  =  "AD" | 1. SELECT[tbl:​Ref_Template_Types] <br>2. PROJECT[col:​Ref_Template_Types:​Template_Type_Code, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​AD:​col:​Ref_Template_Types:​Template_Type_Code] <br>4. PROJECT[col:​Ref_Template_Types:​Template_Type_Description, #3] <br> | 1. SELECT[tbl:​Ref_Template_Types] <br>2. PROJECT[col:​Ref_Template_Types:​Template_Type_Code, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​AD:​col:​Ref_Template_Types:​Template_Type_Code] <br>4. PROJECT[col:​Ref_Template_Types:​Template_Type_Description, #3] <br> | + | easy | 
  | SPIDER_dev_351 | What is the template type code for template type description "Book". | SELECT template_type_code FROM Ref_template_types WHERE template_type_description  =  "Book" | 1. SELECT[tbl:​Ref_Template_Types] <br>2. PROJECT[col:​Ref_Template_Types:​Template_Type_Description, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Book:​col:​Ref_Template_Types:​Template_Type_Description] <br>4. PROJECT[col:​Ref_Template_Types:​Template_Type_Code, #3] <br> | 1. SELECT[tbl:​Ref_Template_Types] <br>2. COMPARATIVE[#1, #1, comparative:​=:​Book:​col:​Ref_Template_Types:​Template_Type_Description] <br>3. PROJECT[col:​Ref_Template_Types:​Template_Type_Code, #2] <br> | + | easy | 
  | SPIDER_dev_352 | Return the type code of the template type with the description "Book". | SELECT template_type_code FROM Ref_template_types WHERE template_type_description  =  "Book" | 1. SELECT[tbl:​Ref_Template_Types] <br>2. PROJECT[col:​Ref_Template_Types:​Template_Type_Description, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Book:​col:​Ref_Template_Types:​Template_Type_Description] <br>4. PROJECT[col:​Ref_Template_Types:​Template_Type_Code, #3] <br> | 1. SELECT[tbl:​Ref_Template_Types] <br>2. PROJECT[col:​Ref_Template_Types:​Template_Type_Description, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Book:​col:​Ref_Template_Types:​Template_Type_Description] <br>4. PROJECT[col:​Ref_Template_Types:​Template_Type_Code, #3] <br> | + | easy | 
  | SPIDER_dev_353 | What are the distinct template type descriptions for the templates ever used by any document? | SELECT DISTINCT T1.template_type_description FROM Ref_template_types AS T1 JOIN Templates AS T2 ON T1.template_type_code  = T2.template_type_code JOIN Documents AS T3 ON T2.Template_ID  =  T3.template_ID | 1. SELECT[tbl:​Templates] <br>2. FILTER[#1, tbl:​Documents] <br>3. PROJECT[col:​Ref_Template_Types:​Template_Type_Description, #2] <br>4.*(distinct)* FILTER[#3, that are distinct] <br> | 1. SELECT[tbl:​Templates] <br>2. COMPARATIVE[#1, #1, tbl:​Documents] <br>3.*(distinct)* PROJECT[col:​Ref_Template_Types:​Template_Type_Description, #2] <br> | + | medium | 
  | SPIDER_dev_354 | Return the different descriptions for templates that have been used in a document. | SELECT DISTINCT T1.template_type_description FROM Ref_template_types AS T1 JOIN Templates AS T2 ON T1.template_type_code  = T2.template_type_code JOIN Documents AS T3 ON T2.Template_ID  =  T3.template_ID | 1. SELECT[tbl:​Templates] <br>2. FILTER[#1, tbl:​Documents] <br>3.*(distinct)* PROJECT[col:​Ref_Template_Types:​Template_Type_Description, #2] <br> | 1. SELECT[col:​Documents:​Template_ID] <br>2. COMPARATIVE[#1, #1, tbl:​Documents] <br>3.*(distinct)* PROJECT[col:​Documents:​Document_Description, #2] <br> | - | medium | 
  | SPIDER_dev_355 | What are the template ids with template type description "Presentation". | SELECT T2.template_id FROM Ref_template_types AS T1 JOIN Templates AS T2 ON T1.template_type_code  = T2.template_type_code WHERE T1.template_type_description  =  "Presentation" | 1. SELECT[col:​Templates:​Template_ID] <br>2. PROJECT[tbl:​Templates, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Presentation:​col:​Ref_Template_Types:​Template_Type_Description] <br> | 1. SELECT[tbl:​Ref_Template_Types] <br>2. PROJECT[col:​Ref_Template_Types:​Template_Type_Description, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Presentation:​col:​Ref_Template_Types:​Template_Type_Description] <br>4. PROJECT[col:​Templates:​Template_ID, #3] <br> | + | medium | 
  | SPIDER_dev_356 | Return the ids corresponding to templates with the description 'Presentation'. | SELECT T2.template_id FROM Ref_template_types AS T1 JOIN Templates AS T2 ON T1.template_type_code  = T2.template_type_code WHERE T1.template_type_description  =  "Presentation" | 1. SELECT[tbl:​Templates] <br>2. FILTER[#1, comparative:​=:​Presentation:​col:​Ref_Template_Types:​Template_Type_Description] <br>3. PROJECT[col:​Templates:​Template_ID, #2] <br> | 1. SELECT[tbl:​Templates] <br>2. PROJECT[col:​Ref_Template_Types:​Template_Type_Description, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Presentation:​col:​Ref_Template_Types:​Template_Type_Description] <br>4. PROJECT[col:​Templates:​Template_ID, #3] <br> | + | medium | 
  | SPIDER_dev_357 | How many paragraphs in total? | SELECT count(*) FROM Paragraphs | 1. SELECT[tbl:​Paragraphs] <br>2. AGGREGATE[count, #1] <br> | 1. SELECT[tbl:​Paragraphs] <br>2. AGGREGATE[count, #1] <br> | + | easy | 
  | SPIDER_dev_358 | Count the number of paragraphs. | SELECT count(*) FROM Paragraphs | 1. SELECT[tbl:​Paragraphs] <br>2. AGGREGATE[count, #1] <br> | 1. SELECT[tbl:​Paragraphs] <br>2. AGGREGATE[count, #1] <br> | + | easy | 
  | SPIDER_dev_359 | How many paragraphs for the document with name 'Summer Show'? | SELECT count(*) FROM Paragraphs AS T1 JOIN Documents AS T2 ON T1.document_ID  =  T2.document_ID WHERE T2.document_name  =  'Summer Show' | 1. SELECT[tbl:​Documents] <br>2. FILTER[#1, comparative:​=:​Summer Show:​col:​Documents:​Document_Name] <br>3. PROJECT[tbl:​Paragraphs, #2] <br>4. AGGREGATE[count, #3] <br> | 1. SELECT[tbl:​Documents] <br>2. PROJECT[col:​Documents:​Document_Name, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Summer Show:​col:​Documents:​Document_Name] <br>4. PROJECT[tbl:​Paragraphs, #3] <br>5. AGGREGATE[count, #4] <br> | + | medium | 
  | SPIDER_dev_360 | Count the number of paragraphs in the document named 'Summer Show'. | SELECT count(*) FROM Paragraphs AS T1 JOIN Documents AS T2 ON T1.document_ID  =  T2.document_ID WHERE T2.document_name  =  'Summer Show' | 1. SELECT[tbl:​Documents] <br>2. FILTER[#1, comparative:​=:​Summer Show:​col:​Documents:​Document_Name] <br>3. PROJECT[tbl:​Paragraphs, #2] <br>4. AGGREGATE[count, #3] <br> | 1. SELECT[tbl:​Documents] <br>2. COMPARATIVE[#1, #1, comparative:​=:​Summer Show:​col:​Documents:​Document_Name] <br>3. PROJECT[tbl:​Paragraphs, #2] <br>4. AGGREGATE[count, #3] <br> | + | medium | 
  | SPIDER_dev_361 | Show paragraph details for paragraph with text 'Korea'. | select other_details from paragraphs where paragraph_text like 'korea' | 1. SELECT[tbl:​Paragraphs] <br>2. PROJECT[col:​Paragraphs:​Paragraph_Text, #1] <br>3. COMPARATIVE[#1, #2, comparative:​like:​korea:​col:​Paragraphs:​Paragraph_Text] <br>4. PROJECT[col:​Paragraphs:​Other_Details, #3] <br> | 1. SELECT[tbl:​Paragraphs] <br>2. PROJECT[col:​Paragraphs:​Paragraph_Text, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Korea:​col:​Paragraphs:​Paragraph_Text] <br>4. PROJECT[col:​Paragraphs:​Other_Details, #3] <br> | + | medium | 
  | SPIDER_dev_362 | What are the details for the paragraph that includes the text 'Korea'? | select other_details from paragraphs where paragraph_text like 'korea' | 1. SELECT[tbl:​Paragraphs] <br>2. FILTER[#1, comparative:​like:​korea:​col:​Paragraphs:​Paragraph_Text] <br>3. PROJECT[col:​Paragraphs:​Other_Details, #2] <br> | 1. SELECT[tbl:​Paragraphs] <br>2. PROJECT[col:​Paragraphs:​Paragraph_Text, #1] <br>3. COMPARATIVE[#1, #2, comparative:​like:​Korea:​col:​Paragraphs:​Paragraph_Text] <br>4. PROJECT[col:​Paragraphs:​Other_Details, #3] <br> | + | medium | 
  | SPIDER_dev_363 | Show all paragraph ids and texts for the document with name 'Welcome to NY'. | SELECT T1.paragraph_id ,   T1.paragraph_text FROM Paragraphs AS T1 JOIN Documents AS T2 ON T1.document_id  =  T2.document_id WHERE T2.Document_Name  =  'Welcome to NY' | 1. SELECT[tbl:​Documents] <br>2. PROJECT[col:​Documents:​Document_Name, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Welcome to NY:​col:​Documents:​Document_Name] <br>4. PROJECT[tbl:​Paragraphs, #3] <br>5. PROJECT[col:​Paragraphs:​Paragraph_ID, #4] <br>6. PROJECT[col:​Paragraphs:​Paragraph_Text, #4] <br>7. UNION[#5, #6] <br> | 1. SELECT[tbl:​Documents] <br>2. PROJECT[col:​Documents:​Document_Name, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Welcome to NY:​col:​Documents:​Document_Name] <br>4. PROJECT[col:​Paragraphs:​Paragraph_ID, #3] <br>5. PROJECT[col:​Paragraphs:​Paragraph_Text, #3] <br>6. UNION[#4, #5] <br> | + | medium | 
  | SPIDER_dev_364 | What are the ids and texts of paragraphs in the document titled 'Welcome to NY'? | SELECT T1.paragraph_id ,   T1.paragraph_text FROM Paragraphs AS T1 JOIN Documents AS T2 ON T1.document_id  =  T2.document_id WHERE T2.Document_Name  =  'Welcome to NY' | 1. SELECT[tbl:​Documents] <br>2. FILTER[#1, comparative:​=:​Welcome to NY:​col:​Documents:​Document_Name] <br>3. PROJECT[tbl:​Paragraphs, #2] <br>4. PROJECT[col:​Paragraphs:​Paragraph_ID, #3] <br>5. PROJECT[col:​Paragraphs:​Paragraph_Text, #3] <br>6. UNION[#4, #5] <br> | 1. SELECT[tbl:​Documents] <br>2. COMPARATIVE[#1, #1, comparative:​=:​Welcome to NY:​col:​Documents:​Document_Name] <br>3. PROJECT[tbl:​Paragraphs, #2] <br>4. PROJECT[col:​Paragraphs:​Paragraph_ID, #3] <br>5. PROJECT[col:​Paragraphs:​Paragraph_Text, #3] <br>6. UNION[#4, #5] <br> | + | medium | 
  | SPIDER_dev_365 | Show all paragraph texts for the document "Customer reviews". | SELECT T1.paragraph_text FROM Paragraphs AS T1 JOIN Documents AS T2 ON T1.document_id  =  T2.document_id WHERE T2.document_name  =  "Customer reviews" | 1. SELECT[tbl:​Documents] <br>2. FILTER[#1, comparative:​=:​Customer reviews:​col:​Documents:​Document_Name] <br>3. PROJECT[col:​Paragraphs:​Paragraph_Text, #2] <br> | 1. SELECT[tbl:​Documents] <br>2. PROJECT[col:​Paragraphs:​Paragraph_Text, #1] <br>3. COMPARATIVE[#2, #1, comparative:​=:​Customer reviews:​col:​Documents:​Document_Name] <br> | + | medium | 
  | SPIDER_dev_366 | What are the paragraph texts for the document with the name 'Customer reviews'? | SELECT T1.paragraph_text FROM Paragraphs AS T1 JOIN Documents AS T2 ON T1.document_id  =  T2.document_id WHERE T2.document_name  =  "Customer reviews" | 1. SELECT[tbl:​Documents] <br>2. FILTER[#1, comparative:​=:​Customer reviews:​col:​Documents:​Document_Name] <br>3. PROJECT[col:​Paragraphs:​Paragraph_Text, #2] <br> | 1. SELECT[tbl:​Documents] <br>2. PROJECT[col:​Documents:​Document_Name, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Customer reviews:​col:​Documents:​Document_Name] <br>4. PROJECT[col:​Paragraphs:​Paragraph_Text, #3] <br> | + | medium | 
  | SPIDER_dev_367 | Show all document ids and the number of paragraphs in each document. Order by document id. | SELECT document_id ,  count(*) FROM Paragraphs GROUP BY document_id ORDER BY document_id | 1. SELECT[col:​Paragraphs:​Document_ID] <br>2. PROJECT[col:​Paragraphs:​Document_ID, #1] <br>3. PROJECT[tbl:​Paragraphs, #1] <br>4. GROUP[count, #3, #1] <br>5. UNION[#2, #4] <br>6. SORT[#5, #2] <br> | 1. SELECT[col:​Paragraphs:​Document_ID] <br>2. PROJECT[col:​Paragraphs:​Document_ID, #1] <br>3. PROJECT[tbl:​Paragraphs, #1] <br>4. GROUP[count, #3, #1] <br>5. UNION[#2, #4] <br>6. SORT[#5, #4, sortdir:​ascending] <br> | - | medium | 
  | SPIDER_dev_368 | Return the different document ids along with the number of paragraphs corresponding to each, ordered by id. | SELECT document_id ,  count(*) FROM Paragraphs GROUP BY document_id ORDER BY document_id | 1. SELECT[col:​Paragraphs:​Document_ID] <br>2.*(distinct)* PROJECT[the different #REF, #1] <br>3. PROJECT[tbl:​Paragraphs, #2] <br>4. GROUP[count, #3, #2] <br>5. UNION[#2, #4] <br>6. SORT[#5, #2] <br> | 1.*(distinct)* SELECT[col:​Paragraphs:​Document_ID] <br>2. PROJECT[col:​Paragraphs:​Document_ID, #1] <br>3. PROJECT[tbl:​Paragraphs, #1] <br>4. GROUP[count, #3, #1] <br>5. UNION[#2, #4] <br>6. SORT[#5, #4, sortdir:​ascending] <br> | - | medium | 
  | SPIDER_dev_369 | Show all document ids, names and the number of paragraphs in each document. | SELECT T1.document_id ,  T2.document_name ,  count(*) FROM Paragraphs AS T1 JOIN Documents AS T2 ON T1.document_id  =  T2.document_id GROUP BY T1.document_id | 1. SELECT[col:​Paragraphs:​Document_ID] <br>2. PROJECT[col:​Paragraphs:​Document_ID, #1] <br>3. PROJECT[col:​Documents:​Document_Name, #1] <br>4. PROJECT[tbl:​Paragraphs, #1] <br>5. GROUP[count, #4, #1] <br>6. UNION[#2, #3, #5] <br> | 1. SELECT[col:​Paragraphs:​Document_ID] <br>2. PROJECT[col:​Paragraphs:​Document_ID, #1] <br>3. PROJECT[col:​Documents:​Document_Name, #1] <br>4. PROJECT[tbl:​Paragraphs, #1] <br>5. GROUP[count, #4, #1] <br>6. UNION[#2, #3, #5] <br> | + | medium | 
  | SPIDER_dev_370 | What are the ids and names of each document, as well as the number of paragraphs in each? | SELECT T1.document_id ,  T2.document_name ,  count(*) FROM Paragraphs AS T1 JOIN Documents AS T2 ON T1.document_id  =  T2.document_id GROUP BY T1.document_id | 1. SELECT[col:​Paragraphs:​Document_ID] <br>2. PROJECT[col:​Paragraphs:​Document_ID, #1] <br>3. PROJECT[col:​Documents:​Document_Name, #1] <br>4. PROJECT[tbl:​Paragraphs, #1] <br>5. GROUP[count, #4, #1] <br>6. UNION[#2, #3, #5] <br> | 1. SELECT[col:​Paragraphs:​Document_ID] <br>2. PROJECT[col:​Documents:​Document_ID, #1] <br>3. PROJECT[col:​Documents:​Document_Name, #1] <br>4. PROJECT[tbl:​Paragraphs, #1] <br>5. GROUP[count, #4, #1] <br>6. UNION[#2, #3, #5] <br> | + | medium | 
  | SPIDER_dev_371 | List all document ids with at least two paragraphs. | SELECT document_id FROM Paragraphs GROUP BY document_id HAVING count(*)  >=  2 | 1. SELECT[col:​Paragraphs:​Document_ID] <br>2. PROJECT[tbl:​Paragraphs, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​>=:​2] <br>5. PROJECT[col:​Paragraphs:​Document_ID, #4] <br> | 1. SELECT[col:​Paragraphs:​Document_ID] <br>2. PROJECT[tbl:​Paragraphs, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​>=:​2] <br>5. PROJECT[col:​Paragraphs:​Document_ID, #4] <br> | + | easy | 
  | SPIDER_dev_372 | What are the ids of documents that have 2 or more paragraphs? | SELECT document_id FROM Paragraphs GROUP BY document_id HAVING count(*)  >=  2 | 1. SELECT[col:​Paragraphs:​Document_ID] <br>2. PROJECT[tbl:​Paragraphs, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​>=:​2] <br>5. PROJECT[col:​Paragraphs:​Document_ID, #4] <br> | 1. SELECT[col:​Paragraphs:​Document_ID] <br>2. PROJECT[tbl:​Paragraphs, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​>=:​2] <br>5. PROJECT[col:​Paragraphs:​Document_ID, #4] <br> | + | easy | 
  | SPIDER_dev_373 | What is the document id and name with greatest number of paragraphs? | SELECT T1.document_id ,  T2.document_name FROM Paragraphs AS T1 JOIN Documents AS T2 ON T1.document_id  =  T2.document_id GROUP BY T1.document_id ORDER BY count(*) DESC LIMIT 1 | 1. SELECT[tbl:​Documents] <br>2. PROJECT[tbl:​Paragraphs, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​max:​None] <br>5. PROJECT[col:​Paragraphs:​Document_ID, #4] <br>6. PROJECT[col:​Documents:​Document_Name, #4] <br>7. UNION[#5, #6] <br> | 1. SELECT[tbl:​Documents] <br>2. PROJECT[tbl:​Paragraphs, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br>5. PROJECT[col:​Documents:​Document_ID, #4] <br>6. PROJECT[col:​Documents:​Document_Name, #4] <br>7. UNION[#5, #6] <br> | + | extra | 
  | SPIDER_dev_374 | Return the id and name of the document with the most paragraphs. | SELECT T1.document_id ,  T2.document_name FROM Paragraphs AS T1 JOIN Documents AS T2 ON T1.document_id  =  T2.document_id GROUP BY T1.document_id ORDER BY count(*) DESC LIMIT 1 | 1. SELECT[tbl:​Documents] <br>2. PROJECT[tbl:​Paragraphs, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br>5. PROJECT[col:​Paragraphs:​Document_ID, #4] <br>6. PROJECT[col:​Documents:​Document_Name, #4] <br>7. UNION[#5, #6] <br> | 1. SELECT[tbl:​Documents] <br>2. PROJECT[tbl:​Paragraphs, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br>5. PROJECT[col:​Documents:​Document_ID, #4] <br>6. PROJECT[col:​Documents:​Document_Name, #4] <br>7. UNION[#5, #6] <br> | + | extra | 
  | SPIDER_dev_375 | What is the document id with least number of paragraphs? | SELECT document_id FROM Paragraphs GROUP BY document_id ORDER BY count(*) ASC LIMIT 1 | 1. SELECT[col:​Paragraphs:​Document_ID] <br>2. PROJECT[tbl:​Paragraphs, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​min:​None] <br> | 1. SELECT[col:​Paragraphs:​Document_ID] <br>2. PROJECT[tbl:​Paragraphs, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​min:​None, #1, #3] <br> | + | hard | 
  | SPIDER_dev_376 | Return the id of the document with the fewest paragraphs. | SELECT document_id FROM Paragraphs GROUP BY document_id ORDER BY count(*) ASC LIMIT 1 | 1. SELECT[col:​Paragraphs:​Document_ID] <br>2. PROJECT[tbl:​Paragraphs, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​min:​None, #1, #3] <br>5. PROJECT[col:​Paragraphs:​Document_ID, #4] <br> | 1. SELECT[col:​Paragraphs:​Document_ID] <br>2. PROJECT[tbl:​Paragraphs, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​min:​None, #1, #3] <br>5. PROJECT[col:​Paragraphs:​Document_ID, #4] <br> | + | hard | 
  | SPIDER_dev_377 | What is the document id with 1 to 2 paragraphs? | SELECT document_id FROM Paragraphs GROUP BY document_id HAVING count(*) BETWEEN 1 AND 2 | 1. SELECT[col:​Paragraphs:​Document_ID] <br>2. PROJECT[tbl:​Paragraphs, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​>=:​1] <br>5. COMPARATIVE[#1, #3, comparative:​<=:​2] <br>6. PROJECT[col:​Paragraphs:​Document_ID, #1] <br>7. INTERSECTION[#6, #4, #5] <br> | 1. SELECT[col:​Paragraphs:​Document_ID] <br>2. PROJECT[tbl:​Paragraphs, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​>=:​1] <br>5. PROJECT[col:​Paragraphs:​Document_ID, #4] <br> | - | easy | 
  | SPIDER_dev_378 | Give the ids of documents that have between one and two paragraphs. | SELECT document_id FROM Paragraphs GROUP BY document_id HAVING count(*) BETWEEN 1 AND 2 | 1. SELECT[col:​Paragraphs:​Document_ID] <br>2. PROJECT[tbl:​Paragraphs, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​<=:​2] <br>5. COMPARATIVE[#1, #3, comparative:​>=:​1] <br>6. INTERSECTION[#1, #4, #5] <br>7. PROJECT[col:​Paragraphs:​Document_ID, #6] <br> | 1. SELECT[tbl:​Documents] <br>2. PROJECT[tbl:​Paragraphs, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​>=:​3] <br>5. COMPARATIVE[#1, #3, comparative:​<=:​2] <br>6. PROJECT[col:​Paragraphs:​Document_ID, #5] <br> | + | easy | 
  | SPIDER_dev_379 | Show the document id with paragraph text 'Brazil' and 'Ireland'. | SELECT document_id FROM Paragraphs WHERE paragraph_text  =  'Brazil' INTERSECT SELECT document_id FROM Paragraphs WHERE paragraph_text  =  'Ireland' | 1. SELECT[col:​Paragraphs:​Document_ID] <br>2. PROJECT[tbl:​Paragraphs, #1] <br>3. PROJECT[col:​Paragraphs:​Paragraph_Text, #2] <br>4. COMPARATIVE[#1, #3, comparative:​=:​Brazil:​col:​Paragraphs:​Paragraph_Text] <br>5. COMPARATIVE[#1, #3, comparative:​=:​Ireland:​col:​Paragraphs:​Paragraph_Text] <br>6. INTERSECTION[#1, #4, #5] <br> | 1. SELECT[col:​Paragraphs:​Document_ID] <br>2. PROJECT[tbl:​Paragraphs, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Brazil:​col:​Paragraphs:​Paragraph_Text] <br>4. COMPARATIVE[#1, #2, comparative:​=:​Ireland:​col:​Paragraphs:​Paragraph_Text] <br>5. INTERSECTION[#1, #3, #4] <br>6. PROJECT[col:​Paragraphs:​Document_ID, #5] <br> | + | hard | 
  | SPIDER_dev_380 | What are the ids of documents that contain the paragraph text 'Brazil' and 'Ireland'? | SELECT document_id FROM Paragraphs WHERE paragraph_text  =  'Brazil' INTERSECT SELECT document_id FROM Paragraphs WHERE paragraph_text  =  'Ireland' | 1. SELECT[col:​Paragraphs:​Document_ID] <br>2. FILTER[#1, comparative:​=:​Brazil:​col:​Paragraphs:​Paragraph_Text] <br>3. FILTER[#1, comparative:​=:​Ireland:​col:​Paragraphs:​Paragraph_Text] <br>4. INTERSECTION[#1, #2, #3] <br>5. PROJECT[col:​Paragraphs:​Document_ID, #4] <br> | 1. SELECT[tbl:​Documents] <br>2. PROJECT[tbl:​Paragraphs, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Brazil:​col:​Paragraphs:​Paragraph_Text] <br>4. COMPARATIVE[#1, #2, comparative:​=:​Ireland:​col:​Paragraphs:​Paragraph_Text] <br>5. INTERSECTION[#1, #3, #4] <br>6. PROJECT[col:​Documents:​Document_ID, #5] <br> | + | hard | 
 ***
 Exec acc: **0.9231**
