import numpy as np
import spacy
from nltk.corpus import wordnet as wn
nlp = spacy.load("en_core_web_sm")

def ambiguity(sentence):
    doc = nlp(sentence)
    tokens = [token.text.lower() for token in doc]
    log_list = [np.log(len(wn.synsets(token))) for token in tokens if len(wn.synsets(token)) > 0]
    if len(log_list) == 0:
        return 0.0
    else:
        return np.sum(log_list)