class Features;

#ifndef FEATURES_H
#define FEATURES_H

enum {F_BIAS, F_TOPIC,
	  F_SYN, F_SENT, F_WDIST, F_PRO_POS, F_PRO_TYPE, F_ANTE_TYPE,
	  F_DEPTH, F_GOV, F_ANC, F_SAMECLAUSE, 
	  F_REFDIST, F_PROPERDIST,
	  F_LEX_ANIM, F_LEX_FREQ,
	  F_MOD, F_DET, F_FREQ,
	  F_LAST};
const string F_NAMES[F_LAST] = {"bias", "topic",
								  "syn", "sent", "wdist",
								  "propos", "protype", "antetype",
								  "depth",
								  "gov",
								  "anc", "sameclause",
								  "refdist", "properdist",
								  "anim", "lexfreq",
								  "mod", "det", "freq"};
const int F_LIMITS[F_LAST] = {1, 10, 
							  4, 36, 6,
							  4, 6, 4,
							  3,
							  5,
							  2, 2,
							  6, 3,
							  6, 6,
							  8, 8, 6};
//note: the line below is autogenerated by running the 'printBeginList'
//function... possibly this is cleverer than it ought to be
const int F_BEGIN[F_LAST + 1] = {0, 2, 22, 30, 102, 114, 122, 134, 142, 148, 158, 162, 166, 178, 184, 196, 208, 224, 240, 252};

//#define TRIPLE_FEATS

class Features
{
public:
	static void printBeginList()
	{
		cout<<"const int F_BEGIN[F_LAST + 1] = {";

		int cumulative = 0;
		for(int ii = 0; ii <= F_LAST; ++ii)
		{
			if(ii > 0)
			{
				cout<<", ";
			}
			cout<<cumulative;
			cumulative += 2 * F_LIMITS[ii];
		}
		cout<<"};\n";
	}

	static int num(int ftype, int fval)
	{
		assert(ftype < F_LAST);
		if(fval >= F_LIMITS[ftype])
		{
			cerr<<"Bad value for "<<F_NAMES[ftype]<<": "<<fval<<"\n";
		}
		assert(fval < F_LIMITS[ftype]);
		return F_BEGIN[ftype] + fval;
	}

	static int noncoref(int fnum)
	{
		int tier2 = F_BEGIN[F_LAST];
		if(fnum >= tier2)
		{
			int bpart = fnum / tier2;
			return pair(noncoref(bpart), noncoref(fnum - bpart * tier2));
		}

		int bin = findBin(fnum);
		int val = fnum - F_BEGIN[bin];
		return F_BEGIN[bin] + F_LIMITS[bin] + val;
	}

	static bool isNoncoref(int fnum)
	{
		int tier2 = F_BEGIN[F_LAST];
		if(fnum >= tier2)
		{
			int bpart = fnum / tier2;
			return isNoncoref(bpart) || isNoncoref(fnum - bpart * tier2);
		}

		int bin = findBin(fnum);
		int val = fnum - F_BEGIN[bin];
		return val >= F_LIMITS[bin];
	}

	static bool isValid(int fnum)
	{
		int tier2 = F_BEGIN[F_LAST];
		if(fnum >= tier2)
		{
			int bpart = fnum / tier2;
			int secondPart = fnum - bpart * tier2;
			return bpart > secondPart;
		}
		return true;
	}

	static void fvalue(int fnum, int& ftype, int& fval)
	{
		ftype = findBin(fnum);
		fval = fnum - F_BEGIN[ftype];
		if(fval >= F_LIMITS[ftype])
		{
			fval -= F_LIMITS[ftype];
		}
	}

	static void unpair(int fnum, int& p1, int& p2)
	{
		p1 = -1;

		int tier2 = F_BEGIN[F_LAST];
		if(fnum >= tier2)
		{
			p1 = fnum / tier2;
			p2 = fnum - p1 * tier2;
		}
		else
		{
			p2 = fnum;
		}
	}

	static int pair(int fnum1, int fnum2)
	{
		if(fnum1 > fnum2)
		{
			return pair(fnum2, fnum1);
		}
		return fnum1 + F_BEGIN[F_LAST] * fnum2;
	} 

	static int triple(int fnum1, int fnum2, int fnum3)
	{
		if(fnum1 > fnum3)
		{
			return triple(fnum3, fnum2, fnum1);
		}
		else if(fnum2 > fnum3)
		{
			return triple(fnum1, fnum3, fnum2);
		}		

		return pair(fnum1, fnum2) +
			F_BEGIN[F_LAST] * F_BEGIN[F_LAST] * fnum3;
	}

#ifdef TRIPLE_FEATS
	static int maxFeat()
	{
		return F_BEGIN[F_LAST] * F_BEGIN[F_LAST] * F_BEGIN[F_LAST];
	}
#else
	static int maxFeat()
	{
		return F_BEGIN[F_LAST] * F_BEGIN[F_LAST];
	}
#endif

	static string inv(int fnum)
	{
		int tier3 = F_BEGIN[F_LAST] * F_BEGIN[F_LAST];
		if(fnum >= tier3)
		{
			int bpart = fnum / tier3;
			return realInv(bpart) + "-" + inv(fnum - bpart * tier3);
		}
		int tier2 = F_BEGIN[F_LAST];
		if(fnum >= tier2)
		{
			int bpart = fnum / tier2;
			return realInv(bpart) + "-" + inv(fnum - bpart * tier2);
		}
		return realInv(fnum);
	}

	static int findBin(int fnum)
	{
		int bin;
		for(bin = 0; bin <= F_LAST; ++bin)
		{
			if(fnum < F_BEGIN[bin])
			{
				return bin - 1;
			}
		}
		cerr<<"ERROR: feature "<<fnum<<" does not belong to any bin.\n";
		assert(0);
	}

	static string realInv(int fnum)
	{
		int bin = findBin(fnum);

		int val = fnum - F_BEGIN[bin];
		if(val >= F_LIMITS[bin])
		{
			return "noncoref-" + 
				F_NAMES[bin] + intToString(val - F_LIMITS[bin]);
		}
		return F_NAMES[bin] + intToString(val);
	}
};

#endif
