###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################

#!/usr/bin/ruby

#
# A simple little ruby script with some handy stats functions
#
# 'sets' can be passed to all functions as arrays (each array item is 
# a value) or hashes in a 'key' => 'count' format.
#

require 'scripts/statistics2.rb'

# calculate student's t-test for sets with equal variance
def ttest_equal(set1, set2)
	mean1 = arithmetic_mean(set1)
	mean2 = arithmetic_mean(set2)
	std1 = samplestddev(set1, mean1)
	std2 = samplestddev(set2, mean2)
#	puts "in ttest: #{mean1} #{mean2} #{std1} #{std2}"
	n1 = 0
	n2 = 0
	if set1.class == Hash then
		set1.each_value { |v| n1 += v }
	elsif set1.class == Array then
		n1 = set1.length
	end
	if set2.class == Hash then
		set2.each_value { |v| n2 += v }
	elsif set2.class == Array then
		n2 = set2.length
	end
	cmnstd = Math.sqrt( ((n1 - 1) * std1 * std1 + (n2 - 1) * std2 * std2) / 
									(n1 + n2 - 2))
	#puts "common stddev: #{cmnstd}"
	#puts "den: #{Math.sqrt(1/set1.length.to_f + 1/set2.length.to_f)}"
	tval = ((mean1 - mean2) / 
				(cmnstd * Math.sqrt(1.0/n1 + 1.0/n2)))
	n = (n1 + n2 - 2).to_i
	puts "t-value: #{tval}"
	pval = Statistics2.tdist(n, tval)
	puts "Probability of null hypothesis: #{pval}"
	return pval
end

def ttest_unequal(set1, set2)

end

# returns the number if items in the set
def count_set(set)
	if(set.class == Hash) then
		count = 0
		set.each_value { |v| count += v }
		return count
	elsif(set.class == Array) then
		return set.length
	end
end

# calculate standard deviation of set input
# pass in mean to save time on big sets
# if input is a hash, assumes key, count
def stddev(input, mean=nil)
	if( mean == nil) then
		mean = arithmetic_mean(input)
	end
	sum = 0.0
	n = 0
	if (input.class == Hash) then
		set.each { |k,v| sum += v*k*k; n+=v }
	elsif (input.class == Array) then
		set.each { |item| sum += item*item }
		n = set.length
	end
	return Math.sqrt(sum / n - mean * mean)
end

# calculate sample standard deviation of input.
# if input is a hash, assumes key, count
# pass in mean to save time on big sets
def samplestddev(input, mean=nil)
	if( mean == nil) then
		mean = arithmetic_mean(input)
	end
	sum = 0.0
	n = 0
	if (input.class == Hash) then
		input.each { |k, v| sum += v * (k - mean) * (k - mean); n+=v }
	elsif (input.class == Array) then
		input.each { |item| sum += (item - mean) * (item - mean) }
		n = input.length
	end
	return Math.sqrt(sum / (n - 1))
end

# arithmetic mean. if input is hash, assumes, val => count
def arithmetic_mean(input)
	sum = 0.0
	n = 0
	if (input.class == Hash) then
		input.each {|k,v| sum += k*v; n+=v }
	elsif (input.class == Array) then
		input.each { |item| sum += item }
		n = input.length
	end
	return sum / n
end
