import os
import torch
import numpy as np
import scipy.special
import logging

from torchfly.flylogger import FlyLogger
from torchfly.flyconfig import FlyConfig
from torchfly.training import Trainer
import torchfly.distributed as distributed
from torchfly.utilities import set_random_seed
from omegaconf import OmegaConf

from dataloader import DataLoaderHelper


logger = logging.getLogger(__name__)


def main():
    config = FlyConfig.load("configs/arxiv_ai_config/bart_large_1024.yaml")
    set_random_seed(config.training.random_seed)

    if "bart" in config.task.method:
        from models.bart_generation import BartGenerationFlyModel
        model = BartGenerationFlyModel(config)
    elif "led" in config.task.method:
        from models.led_generation import LEDGenerationFlyModel
        model = LEDGenerationFlyModel(config)

    print("Loading Data")
    data_helper = DataLoaderHelper(config)
    train_dataloader = data_helper.train_loader_fn()
    valid_dataloader = data_helper.valid_loader_fn()

    print("Loading Model")
    
    model.configure_metrics()

    trainer = Trainer(config.training, model)


    with FlyLogger(config.flylogger) as flylogger:
        # save_config
        with open("config.yaml", "w") as f:
            OmegaConf.save(config, f)

        logger.info(config)

        trainer.train(config.training, train_dataloader, valid_dataloader)


if __name__ == "__main__":
    main()
