/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.spanish.process;

import edu.stanford.nlp.util.Pair;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AnCoraPronounDisambiguator {
    private static final Set<String> ambiguousPersonalPronouns = new HashSet<String>(Arrays.asList("me", "te", "se", "nos", "os"));
    private static final Set<String> alwaysReflexiveVerbs = new HashSet<String>(Arrays.asList("acercar", "acostumbrar", "afeitar", "ahincar", "Anticipar", "aplicar", "aprovechar", "Atreve", "callar", "casar", "colocar", "comportar", "comprar", "deber", "desplazar", "detectar", "divirtiendo", "echar", "encontrar", "enfrentar", "entender", "enterar", "equivocar", "esconder", "esforzando", "felicitar", "fija", "ganar", "Habituar", "hacer", "imaginar", "iniciar", "ir", "jugar", "Levantar", "Manifestar", "mantener", "marchar", "Negar", "obsesionar", "Olvidar", "olvidar", "oponer", "Para", "pasar", "plantear", "poner", "quedar", "querer", "reciclar", "reconoce", "reconstruir", "recuperar", "referir", "rendir", "reservar", "reunir", "sentar", "sentir", "someter", "tirando", "tomar", "unir", "Ve", "vestir"));
    private static final Set<String> neverReflexiveVerbs = new HashSet<String>(Arrays.asList("aguar", "anunciar", "arrebatando", "arruinar", "clasificar", "concretar", "contar", "crea", "Cuente", "Decir", "devolver", "devuelve", "dirigiendo", "distraer", "exigiendo", "exigir", "haz", "ignorar", "impedir", "llevar", "mirar", "multar", "negar", "ocultando", "pidiendo", "prevenir", "quitar", "resultar", "saludar", "servir", "situar", "tutear", "utilizar", "vender", "ver", "visitar"));
    private static final Map<Pair<String, String>, PersonalPronounType> bruteForceDecisions = new HashMap<Pair<String, String>, PersonalPronounType>();

    public static boolean isAmbiguous(String pronoun) {
        return ambiguousPersonalPronouns.contains(pronoun);
    }

    public static PersonalPronounType disambiguatePersonalPronoun(Pair<String, List<String>> splitVerb, int pronounIdx, String clauseYield) {
        List<String> pronouns = splitVerb.second();
        String pronoun = pronouns.get(pronounIdx).toLowerCase();
        if (!ambiguousPersonalPronouns.contains(pronoun)) {
            throw new IllegalArgumentException("We don't support disambiguating pronoun '" + pronoun + "'");
        }
        if (pronouns.size() == 1 && pronoun.equalsIgnoreCase("se")) {
            return PersonalPronounType.REFLEXIVE;
        }
        String verb = splitVerb.first();
        if (alwaysReflexiveVerbs.contains(verb)) {
            return PersonalPronounType.REFLEXIVE;
        }
        if (neverReflexiveVerbs.contains(verb)) {
            return PersonalPronounType.OBJECT;
        }
        Pair<String, String> bruteForceKey = new Pair<String, String>(verb, clauseYield);
        if (bruteForceDecisions.containsKey(bruteForceKey)) {
            return bruteForceDecisions.get(bruteForceKey);
        }
        System.err.println("DISAMB " + splitVerb.first() + "\nDISAMB\t" + clauseYield);
        return PersonalPronounType.UNKNOWN;
    }

    static {
        bruteForceDecisions.put(new Pair<String, String>("contar", "No contarte mi vida nunca m\u00e1s"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("Creer", "Creerselo todo"), PersonalPronounType.REFLEXIVE);
        bruteForceDecisions.put(new Pair<String, String>("creer", "cre\u00e9rselo todo ..."), PersonalPronounType.REFLEXIVE);
        bruteForceDecisions.put(new Pair<String, String>("dar", "darme la enhorabuena"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("dar", "darnos cuenta"), PersonalPronounType.REFLEXIVE);
        bruteForceDecisions.put(new Pair<String, String>("dar", "podr\u00eda darnos"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("dar", "puede darnos"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("decir", "suele decirnos"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("decir", "suelo dec\u00edrmelo"), PersonalPronounType.REFLEXIVE);
        bruteForceDecisions.put(new Pair<String, String>("dejar", "deber\u00eda dejarnos faenar"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("dejar", "dejarme un intermitente encendido"), PersonalPronounType.REFLEXIVE);
        bruteForceDecisions.put(new Pair<String, String>("dejar", ": dejarnos un pa\u00eds tan limpio en su gobierno como el cielo claro despu\u00e9s de las tormentas mediterr\u00e1neas , que inundan nuestras obras p\u00fablicas sin encontrar nunca ni un solo responsable pol\u00edtico de tanta mala gesti\u00f3n , ya sea la plaza de Cerd\u00e0 socialista o los incendios forestales de la Generalitat"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("dejar", "podemos dejarnos adormecer"), PersonalPronounType.REFLEXIVE);
        bruteForceDecisions.put(new Pair<String, String>("enga\u00f1ar", "enga\u00f1arnos"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("explicar", "deber\u00e1 explicarnos"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("liar", "liarme a tiros"), PersonalPronounType.REFLEXIVE);
        bruteForceDecisions.put(new Pair<String, String>("llevar", "llevarnos a una trampa en esta elecci\u00f3n"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("manifestar", "manifestarme su solidaridad"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("manifestar", "manifestarnos sobre las circunstancias que mantienen en vilo la vida y obra de los colombianos"), PersonalPronounType.REFLEXIVE);
        bruteForceDecisions.put(new Pair<String, String>("mirando", "est\u00e1bamos mir\u00e1ndonos"), PersonalPronounType.REFLEXIVE);
        bruteForceDecisions.put(new Pair<String, String>("poner", "ponerme en ascuas"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("servir", "servirme de gu\u00eda"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("volver", "debe volvernos"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("volver", "deja de volverme"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("volver", "volvernos"), PersonalPronounType.REFLEXIVE);
    }

    public static enum PersonalPronounType {
        OBJECT,
        REFLEXIVE,
        UNKNOWN;

    }
}

