theory question_47_9

imports Main

begin

typedecl entity
typedecl event

consts
  Genes :: "entity ⇒ bool"
  SameChromosome :: "entity ⇒ entity ⇒ bool"
  InheritedTogether :: "event ⇒ bool"
  LinkedGenes :: "entity ⇒ entity ⇒ bool"

theorem hypothesis:
  assumes asm: "Genes x ∧ Genes y ∧ SameChromosome x y"
  (* Hypothesis: Genes are inherited together if they are located on the same chromosome. *)
  shows "∃e. InheritedTogether e ∧ Agent e x ∧ Agent e y"
proof -
  have "LinkedGenes x y" using asm(1,2) by (simp add: LinkedGenes_def)
  then obtain e where e: "InheritedTogether e ∧ Agent e x ∧ Agent e y" using asm(3) by blast
  then show ?thesis using e by simp
qed

end
