theory question_29_7

imports Main

begin

typedecl entity
typedecl event

consts
  Wearing :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  RedMakeup :: "entity ⇒ bool"
  MakeupOnFace :: "entity ⇒ bool"
  Men :: "entity ⇒ bool"
  Face :: "entity ⇒ bool"
  Dressed :: "event ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Makeup :: "entity ⇒ bool"
  Costume :: "entity ⇒ bool"
  OlderMan :: "entity ⇒ bool"
  Cream :: "entity ⇒ bool"
  FaceInFrontOf :: "entity ⇒ entity ⇒ bool"
  Festival :: "entity ⇒ bool"
  Displays :: "event ⇒ bool"

(* Explanation 1: ∀x e1. Wearing(e1) ∧ Agent(e1, x) ∧ RedMakeup(Patient(e1)) ⟶ MakeupOnFace(x) *)
axiomatization where
  explanation_1: "∀x e1. Wearing e1 ∧ Agent e1 x ∧ RedMakeup (Patient e1) ⟶ MakeupOnFace x"

(* Explanation 2: ∃x e1. Men(x) ∧ Wearing(e1) ∧ Agent(e1, x) ∧ RedMakeup(Patient(e1)) ∧ Face(Patient(e1)) *)
axiomatization where
  explanation_2: "∃x e1. Men x ∧ Wearing e1 ∧ Agent e1 x ∧ RedMakeup (Patient e1) ∧ Face (Patient e1)"

(* Explanation 3: ∀x. MakeupOnFace(x) ⟶ WearingMakeup(x) *)
axiomatization where
  explanation_3: "∀x. MakeupOnFace x ⟶ WearingMakeup x"

(* Explanation 4: ∃x. Men(x) ∧ WearingMakeup(x) ⟶ ∃e. Dressed(e) ∧ Agent(e, x) ∧ Makeup(Patient(e)) *)
axiomatization where
  explanation_4: "∃x. Men x ∧ WearingMakeup x ⟶ ∃e. Dressed e ∧ Agent e x ∧ Makeup (Patient e)"

theorem hypothesis:
  (* Premise: ∃x y z e1 e2. Festival(z) ∧ Displays(e1) ∧ Agent(e1, z) ∧ Men(x) ∧ Men(y) ∧ Dressed(e2) ∧ Agent(e2, x) ∧ Agent(e2, y) ∧ RedMakeup(Patient(e2)) ∧ Costume(Patient(e2)) ∧ OlderMan(w) ∧ Cream(Patient(f)) ∧ Agent(f, w) ∧ Face(Patient(f)) ∧ FaceInFrontOf(x, z) ∧ FaceInFrontOf(y, z) ∧ FaceInFrontOf(w, z) *)
  assumes asm: "Festival z ∧ Displays e1 ∧ Agent e1 z ∧ Men x ∧ Men y ∧ Dressed e2 ∧ Agent e2 x ∧ Agent e2 y ∧ RedMakeup  Patient e2  ∧ Costume  Patient e2  ∧ OlderMan w ∧ Cream  Patient f  ∧ Agent f w ∧ Face  Patient f  ∧ FaceInFrontOf x z ∧ FaceInFrontOf y z ∧ FaceInFrontOf w z"
  (* Hypothesis: ∃x y. Men(x) ∧ Men(y) ∧ Dressed(e) ∧ Agent(e, x) ∧ Agent(e, y) ∧ Makeup(Patient(e)) *)
  shows "∃x y e. Men x ∧ Men y ∧ Dressed e ∧ Agent e x ∧ Agent e y ∧ Makeup  Patient e "
proof -
  from asm have "Men x" "Men y" "Dressed e2" "Agent e2 x" "Agent e2 y" "RedMakeup (Patient e2)" "Costume (Patient e2)" by fastforce
  then have "Wearing e2" "Patient e2 = x ∨ Patient e2 = y" using explanation_2 by metis
  then have "MakeupOnFace x ∨ MakeupOnFace y" using explanation_1 by blast
  then have "WearingMakeup x ∨ WearingMakeup y" using explanation_3 by blast
  then have "∃e. Dressed e ∧ Agent e x ∧ Agent e y ∧ Makeup (Patient e)" using explanation_4 by blast
  then have "∃e. Dressed e ∧ Agent e x ∧ Agent e y ∧ MakeupOnFace (Patient e)" using explanation_3 by blast
  then have "∃e. Wearing e ∧ Agent e x ∧ Agent e y ∧ RedMakeup (Patient e)" using explanation_1 by blast
  then show "∃x y e. Men x ∧ Men y ∧ Dressed e ∧ Agent e x ∧ Agent e y ∧ Makeup  Patient e " using asm by blast
qed

end
